﻿using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class ShopSlideManage
    {
        public static List<T_BAS_ShopSlide> GetPageList(GridModel gridModel)
        {
            using (var query = Factory.CreateT_BAS_ShopSlide())
            {
                return query.GetPageList(gridModel);
            }
        }

        public static Result SaveOrUpdate(T_BAS_ShopSlide entity)
        {
            if (entity == null) return new Result(false, "保存对象不能为空！");

            using (var query = Factory.CreateT_BAS_ShopSlide())
            {
                //新增
                if (entity.ShopSlideGuid == Guid.Empty)
                {
                    entity.ShopSlideGuid = Guid.NewGuid();
                    entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;

                    query.Add(entity);
                }
                else
                {
                    //更新
                    if (query.IsExist(m => m.ShopSlideGuid == entity.ShopSlideGuid))
                    {
                        query.Update(m => new object[]{
                            m.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid,
                            m.SlideImg == entity.SlideImg,
                            m.SlideUrl == entity.SlideUrl,
                        }, v => v.ShopSlideGuid == entity.ShopSlideGuid);
                    }
                    //新增
                    else
                    {
                        entity.ShopSlideGuid = Guid.NewGuid();
                        entity.MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid;

                        query.Add(entity);
                    }
                }
                return new Result(true); 
            }
        }

        public static Result Delete(Guid shopSlideGuid)
        {
            if (shopSlideGuid == Guid.Empty) return new Result(false, "ID不能为空！");

            using (var query = Factory.CreateT_BAS_ShopSlide())
            {
                if (!query.IsExist(m => m.ShopSlideGuid == shopSlideGuid)) return new Result(false, "不存在幻灯片");

                query.Delete(m => m.ShopSlideGuid == shopSlideGuid);

                return new Result(true);
            }
        }

        public static List<T_BAS_ShopSlide> GetList()
        {
            using (var query = Factory.CreateT_BAS_ShopSlide())
            {
                return query.GetList();
            }
        }
    }
}
