﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Timers;

namespace RFrameGenerate.BLL
{
    public class CrowdPeriodLock
    {
        static Timer time;
        static object lockmodel = new object();
        static object lockmodel_3A = new object();

        public static void Start()
        {
            Locks = new List<LockModel>();
            time = new Timer();
            time.Elapsed += time_Elapsed;
            time.Enabled = true;
            time.Interval = 1000 * 60 * 6;
            time.Start();
        }

        public static void Stop()
        {
            time.Stop();
        }

        static void time_Elapsed(object sender, ElapsedEventArgs e)
        {
            lock (lockmodel)
            {
                lock (lockmodel_3A)
                {
                    for (int i = Locks.Count - 1; i >= 0; i--)
                    {
                        if (Locks[i].IsUse != true)
                        {
                            Locks.RemoveAt(i);
                        }
                    }
                }
            }
        }
        /// <summary>
        /// 购物车商品
        /// </summary>
        static List<LockModel> Locks { get; set; }
        /// <summary>
        /// 获取锁,不存在会创建新的锁并返回
        /// </summary>
        public static void Lock(Guid id, Action action)
        {
            if (time == null)
                throw new Exception("CrowdPeriodLock.Start();未开启");

            LockModel model;
            lock (lockmodel)
            {
                model = Locks.Where(a => a.ID == id).FirstOrDefault();
                if (model == null)
                {
                    model = new LockModel() { ID = id, IsUse = true };
                    Locks.Add(model);
                }
            }

            lock (model)
            {
                action();
            }
        }
        /// <summary>
        /// 获取锁,不存在会创建新的锁并返回
        /// </summary>
        public static LockModel GetLock(Guid id)
        {
            if (time == null)
                throw new Exception("CrowdPeriodLock.Start();未开启");
            lock (lockmodel)
            {
                var model = Locks.Where(a => a.ID == id).FirstOrDefault();
                if (model == null)
                {
                    model = new LockModel() { ID = id, IsUse = true };
                    Locks.Add(model);
                }
                return model;
            }
        }


        /// <summary>
        /// 获取锁,不存在会创建新的锁并返回  
        /// （该重载主要用于商家账户维护 暂定 Bing 160429）
        /// </summary>
        public static LockModel GetLock(string key)
        {
            //if (time == null)
            //    throw new Exception("CrowdPeriodLock.Start();未开启");
            lock (lockmodel_3A)
            {
                var model = Locks.FirstOrDefault(a => a.Key == key);
                if (model == null)
                {
                    model = new LockModel() { Key = key, IsUse = true };
                    Locks.Add(model);
                }
                return model;
            }
        }

        /// <summary>
        /// 设置锁的状态
        /// </summary>
        public static void SetLock(Guid PeriodGuid, bool isuse)
        {
            if (time == null)
                throw new Exception("CrowdPeriodLock.Start();未开启");
            lock (lockmodel)
            {
                var model = Locks.Where(a => a.ID == PeriodGuid).FirstOrDefault();
                if (model != null)
                {
                    model.IsUse = isuse;
                }
            }
        }


        /// <summary>
        /// 设置锁的状态
        /// （该重载主要用于商家账户维护 暂定 Bing 160429）
        /// </summary>
        public static void SetLock(string key, bool isuse = false)
        {
            //if (time == null)
            //    throw new Exception("CrowdPeriodLock.Start();未开启");
            lock (lockmodel_3A)
            {
                var model = Locks.FirstOrDefault(a => a.Key == key);
                if (model != null)
                {
                    model.IsUse = isuse;
                }
            }
        }
    }

    public class LockModel
    {
        public Guid ID { get; set; }
        public bool IsUse { get; set; }
        public object Lock { get; set; }
        public string Key { get; set; }
    }
}
