﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLQuery;
using RFrameGenerate.Model.PageModel;

namespace RFrameGenerate.BLL
{
    public class VisitantManager
    {
        #region List<T_BAS_Member> GetList
        /// <summary>
        /// get member list 
        /// </summary>
        /// <returns></returns>
        public static decimal GetBanlanceByMemberguid(Guid memberGuid)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                return query.GetFirstData(c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.MemberGuid == memberGuid).Balance;
            }
        }
        #endregion

        #region List<T_BAS_Member> GetVipList
        /// <summary>
        /// get member datalist
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="userName"></param>
        /// <returns></returns>
        public static List<T_ST_Member> GetVipList(GridModel gridModel, string userName, string _ID, string birthday)
        {
            using (var query = Factory.CreateT_ST_Member())
            {
                if (string.IsNullOrEmpty(birthday))
                {
                    return query.GetPageList(gridModel, c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.MemberNickName.SqlLike(userName) && c.MemberID.SqlLike(_ID), true, b => b.MemberID, DAL.Enums.OrderMethods.ASC);
                }
                else
                {
                    return query.GetPageList(gridModel, c => c.MerchantGuid == RFrameGenerate.Common.CurrentManage.MerchantGuid && c.MemberNickName.SqlLike(userName) && c.Birth == birthday, true, b => b.MemberID, DAL.Enums.OrderMethods.ASC);
                }
            }
        }

        #endregion

        #region Result Update
        /////// <summary>zhou 2015/10/27 del
        /////// Update function
        /////// </summary>
        /////// <param name="entity"></param>
        /////// <returns></returns>
        ////public static Result Update(T_BAS_Member entity)
        ////{

        ////    using (var query = Factory.CreateT_BAS_Member())
        ////    {
        ////        query.Update(a => new object[]
        ////        {
        ////            a.City == entity.City,
        ////            a.Balance==entity.Balance,
        ////            a.ID==entity.ID,
        ////            a.MemberNickName == entity.MemberNickName,
        ////            a.MemberName == entity.MemberName,
        ////            a.Province == entity.Province,
        ////            a.Country == entity.Country,
        ////            a.MemberMobilePhone==entity.MemberMobilePhone,
        ////            a.ExpenseTotal==entity.ExpenseTotal
        ////        }, b => b.MemberGuid == entity.MemberGuid);

        ////        return new Result(true);
        ////    }
        ////}
        /// <summary>
        /// 提现
        /// </summary>
        /// <param name="applyAmount"></param>
        /// <param name="memberGuid"></param>
        /// <returns></returns>
        public static Result Update2(decimal applyAmount, Guid withdrawsCommissionGuid, Guid memberGuid)
        {
            using (var tran = new RFramework.SQLServer.SqlRTransaction())
            {
                var query = Factory.CreateT_BAS_Member(tran);
                var memeber = query.GetFirstData(a => a.MemberGuid == memberGuid);
                decimal Balance = memeber.Balance + applyAmount;
                decimal Amount = memeber.Amount + applyAmount;

                query.Update(a => new object[]
                {
                    a.Balance==Balance,
                    a.Amount==Amount,
                }, b => b.MemberGuid == memberGuid);

                //添加会员账户记录 Bing 160423
                MemberAccountManage.AddMemberAccount(memeber.MemberGuid, MemberAccountConst.TradingType.分销佣金提现, withdrawsCommissionGuid, applyAmount, tran, memeber.Balance, memeber.MerchantGuid, "佣金提现");

                return new Result(true);
            }
        }

        #endregion

        #region Result Delete
        /// <summary>
        /// delete function
        /// </summary>
        /// <param name="id"></param>
        /// <param name="list"></param>
        /// <returns></returns>
        public static Result Delete(Guid id)
        {
            using (var query = Factory.CreateT_BAS_Member())
            {
                query.Delete(c => c.MemberGuid == id);
            }
            return new Result(true);
        }

        #endregion


    }
}
