﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Common.DatabaseConfig;
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.Model;
using RFramework.Helper;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using Wechat.Model;
using Wechat.Enum;
using RFrameGenerate.Common;
using RFramework.SQLServer.Enums;

namespace RFrameGenerate.BLL
{
    public class AutoReplyManage
    {
        public static string GetContentByKeywordToXml(string keyword, string openID, string FromUserName)
        {
            using (var tran = new SqlRTransaction())
            {
                try
                {
                    var queryMer = Factory.CreateProcedure(tran);
                    var mer = queryMer.GetMerchantByWechat(FromUserName);


                    var queryKeyword = Factory.CreateT_BAS_Keywords(tran);
                    var queryMaterial = Factory.CreateT_BAS_Materials(tran);
                    var keywordModel = queryKeyword.GetFirstData(a => a.Keyword == keyword && a.MerchantGuid == mer.MerchantGuid, false, null, OrderMethods.Default, LockType.Default, false);
                    if (keywordModel == null)
                    {//不存在关键字,找默认回复
                        keywordModel = queryKeyword.GetFirstData(a => a.Keyword == DictionaryConst.WeiXinAutoReply.ReplyKeyword.Default && a.MerchantGuid == mer.MerchantGuid, false, null, OrderMethods.Default, LockType.Default, false);

                        if (keywordModel == null)
                        {
                            //SendPassiveTextMsg voice = new SendPassiveTextMsg()
                            //{
                            //    CreateTime = DateTime.Now,
                            //    FromUserName = FromUserName,
                            //    Content = "",
                            //    MsgType = MsgType.text,
                            //    ToUserName = openID,
                            //};
                            //return voice.ToXml();
                            return "success";
                        }
                    }

                    T_BAS_Materials material = queryMaterial.GetFirstData(a => a.MaterialGuid == keywordModel.MaterialGuid, false, null, OrderMethods.Default, LockType.Default, false);
                    if (material == null)
                    {
                        Wechat.LogManage.Log("自动回复找不到素材102");
                        return "success";
                    }

                    return ReplyToXml(material, openID, FromUserName, tran, keywordModel.MerchantGuid.Value);
                }
                catch (Exception ex)
                {
                    Wechat.LogManage.Log("GetContentByKeywordToXml自动回复:" + ex.Message);
                    //SendPassiveTextMsg voice = new SendPassiveTextMsg()
                    //{
                    //    CreateTime = DateTime.Now,
                    //    FromUserName = FromUserName,
                    //    Content = "",
                    //    MsgType = MsgType.text,
                    //    ToUserName = openID,
                    //};
                    //return voice.ToXml();
                    return "success";
                }
            }
        }

        static string ReplyToXml(T_BAS_Materials material, string openID, string FromUserName, SqlRTransaction tran, Guid MerchantGuid)
        {
            switch (material.MaterialType)
            {
                case DictionaryConst.WeiXinAutoReply.MaterialType.Image:
                    SendPassiveImageMsg image = new SendPassiveImageMsg()
                    {
                        FromUserName = FromUserName,
                        CreateTime = DateTime.Now,
                        MediaId = material.MediaID,
                        MsgType = MsgType.image,
                        ToUserName = openID,
                    };
                    return image.ToXml();
                case DictionaryConst.WeiXinAutoReply.MaterialType.Video:
                    {
                        SendPassiveVideoMsg video = new SendPassiveVideoMsg()
                        {
                            CreateTime = DateTime.Now,
                            Description = "",
                            FromUserName = FromUserName,
                            MediaId = material.MediaID,
                            MsgType = MsgType.video,
                            Title = material.Name,
                            ToUserName = openID,
                        };
                        return video.ToXml();
                    }
                case DictionaryConst.WeiXinAutoReply.MaterialType.Voice:
                    {
                        SendPassiveVoiceMsg voice = new SendPassiveVoiceMsg()
                        {
                            CreateTime = DateTime.Now,
                            FromUserName = FromUserName,
                            MediaId = material.MediaID,
                            MsgType = MsgType.video,
                            ToUserName = openID,
                        };
                        return voice.ToXml();
                    }
                case DictionaryConst.WeiXinAutoReply.MaterialType.Txt:
                    {
                        var querytxt = Factory.CreateT_BAS_MaterialTxt(tran);
                        var listtxt = querytxt.GetList(a => a.MaterialGuid == material.MaterialGuid, false, b => b.Sort, OrderMethods.ASC, LockType.Default, false);
                        if (listtxt.Count > 0)
                        {
                            SendImageTXTMsg imageText = new SendImageTXTMsg() { CreateTime = DateTime.Now, FromUserName = FromUserName, ToUserName = openID, MsgType = MsgType.news, };
                            List<Articles> items = new List<Articles>();
                            foreach (var v in listtxt)
                            {
                                items.AddEx(new Articles(v.Name, v.TXTDescribe, v.TXTCover, v.TXTUrl));
                            }
                            imageText.Items = items;
                            return imageText.ToXml();
                        }
                        else
                        {
                            return "success";
                        }
                    }
                default:
                    {
                        if (string.IsNullOrEmpty(material.Content) != true)
                        {
                            SendPassiveTextMsg text = new SendPassiveTextMsg()
                            {
                                CreateTime = DateTime.Now,
                                FromUserName = FromUserName,
                                Content = RFrameGenerate.BLL.AutoReplyRule.RuleParse(material.Content, MerchantGuid, openID),
                                MsgType = MsgType.text,
                                ToUserName = openID,
                            };
                            return text.ToXml();
                        }
                        else
                        {
                            return "success";
                        }
                    }
            }
        }
    }
}
