﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.BLL
{
    public class BaseCommomDictionaryConst
    {

        public class MaterialReplyType
        {
            /// <summary>
            ///  素材回复类型：文本 1
            /// </summary>
            public const int Text = 1;
            /// <summary>
            /// 素材回复类型：外部链接 2
            /// </summary>
            public const int Outurl = 2;
        }

        public class MaterialState
        {
            /// <summary>
            /// 素材状态：正常 0
            /// </summary>
            public const int Normal = 0;
            /// <summary>
            /// 素材状态：暂停 1
            /// </summary>
            public const int Pause = 1;
        }
        /// <summary>
        /// 自动回复类型
        /// </summary>
        public enum AutoReply
        {
            /// <summary>
            /// 文本
            /// </summary>
            text = 0,
            /// <summary>
            /// 图文
            /// </summary> 
            txt = 1,
        }

        public class AutoReplyType
        {
            public static string GetAutoTypeText(string type)
            {
                if (type == AutoReply.text.ToString())
                    return "文本回复";
                else
                    return "图文回复";
            }
        }

        public class ReplyKeyword
        {
            public const string Subscribe = "subscribe";
            public const string NoneMatch = "nonematch";
        }

    }
}