﻿using RFramework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;

namespace RFrameGenerate.Common
{
    /// <summary>
    /// 当前用户数据集合
    /// </summary>
    public class CurrentManage
    {
        /// <summary>
        /// 当前用户名,dal层会调用
        /// </summary>
        public static string UserName
        {
            get
            {
                /*
                 BS框架 需要在这里写获取当前的用户 获取当前用户
                 * 
                 */
                return string.Format("{0}[{1}]", CurrentUser.GetCurrUserName(), CurrentUser.GetCurrUserGuid().ToString());
            }
        }
        /// <summary>
        /// 系统级别参数,写储存过程可用到
        /// </summary>
        public static Guid SMerchantGuid
        {
            get
            {
                return CurrentUser.GetSMerchantGuid();
            }
        }
        /// <summary>
        /// 后台登录类型
        /// </summary>
        public static int LoginType
        {
            get
            {
                return CurrentUser.GetLoginType();
            }
        }
        /// <summary>
        /// 商家表主键
        /// </summary>
        public static Guid MerchantGuid
        {
            get
            {
                return CurrentUser.GetMerchantGuid();
            }
        }
        /// <summary>
        /// 商家userid
        /// </summary>
        public static string MerchantUserID
        {
            get
            {
                return CurrentUser.GetMerchantUserID();
            }
        }
        /// <summary>
        /// 商家公众号AppID
        /// </summary>
        public static string AppId
        {
            get
            {
                return CurrentUser.GetAppID();
            }
        }
        /// <summary>
        /// 是否是商家登录,否帽是员工登录
        /// </summary>
        public static bool IsMerchant
        {
            get
            {
                return CurrentUser.GetSMerchant();
            }
        }
        /// <summary>
        /// 是否分销商
        /// </summary>
        public static bool IsDistribution
        {
            get
            {
                return CurrentUser.GetIsDistribution();
            }
        }
        /// <summary>
        /// 当前微信会员所在店的域名[/结尾]
        /// </summary>
        public static string CurrentDomainWx
        {
            get
            {
                return DomainWx.Replace("shop.", string.Format("{0}.shop.", MerchantUserID));
            }
        }

        /// <summary>
        /// 前台域名/结尾
        /// </summary>
        public static string Domain = "http://base.wx.rightcode.cn/";
        /// <summary>
        /// 微信域名/结尾
        /// </summary>
        public static string DomainWx = "http://base.wx.rightcode.cn/";
        /// <summary>
        /// 微信一级域名
        /// </summary>
        public static string DomainWxRoot;
        /// <summary>
        /// 下线时登录视图/登录视图
        /// </summary>
        public static string OfflineLoginResult = "/Home/AdminIndex";
        /// <summary>
        /// 是否只允许同一用户同时在线
        /// </summary>
        public static bool ApplicationSignOutSwitch = false;
        /// <summary>
        /// 项目标题
        /// </summary>
        public static string ObjectTitle = "广州极欧信息科技有限公司";

        /// <summary>
        /// 是否启用web api
        /// </summary>
        public static bool IsEnableApi = false;

        public static int AuthorizationDay = 0;
        /// <summary>
        /// 贡献榜间隔时间
        /// </summary>
        public static int ContributionInnerTime = 60;

        /// <summary>
        /// 获取商家类型
        /// </summary>
        public static int MerchantType
        {
            get
            {
                return CurrentUser.GetMerchantType();
            }
        }

        #region 加密

        /// <summary>
        /// 私钥
        /// </summary>
        public static string PrivateKey
        {
            get
            {
                return RSACrypto.PrivateKey;
            }
            set
            {
                RSACrypto.PrivateKey = value;
            }
        }
        /// <summary>
        /// 公钥
        /// </summary>
        public static string PublicKey
        {
            get
            {
                return RSACrypto.PublicKey;
            }
            set
            {
                RSACrypto.PublicKey = value;
            }
        }
        #endregion

        #region api限制集合
        /// <summary>
        /// 账号调用频率
        /// </summary>
        public static SessionManage ApiSession = new SessionManage();
        /// <summary>
        /// api调用频率
        /// </summary>
        public static SessionManage IPSession = new SessionManage();
        /// <summary>
        /// 用户验证缓存
        /// </summary>
        public static SessionManage UserSession = new SessionManage();
        #endregion

        #region 测试数据
        /// <summary>
        /// 是否是调试
        /// </summary>
        public static bool IsDebug = false;
        /// <summary>
        /// 是否维护状态
        /// </summary>
        public static bool IsMaintenance = false;
        public static Guid? TestMemberGuid = null;
        public static string TestMemberOpenID = "";
        public static string TestUserID = "";
        public static string TestUserName = "";
        public static string TestToken = "";
        public static string TestAppId = "";
        public static string TestAppSecret = "";
        public static string TestEncodingAESKey = "";
        public static string attentionurl = "http://mp.weixin.qq.com/s?__biz=MzAwMzI3OTc5NA==&mid=206656273&idx=1&sn=49f94b2ab179125550731bc9cb4aa87d#rd";
        /// <summary>
        /// 在Debug下会用测试数据模拟登录,IsDebug=true时会清空Cookie
        /// </summary>
        public static void SimulationLogin()
        {
            if (RFrameGenerate.Common.CurrentManage.IsDebug == true)
            {
#if DEBUG
                RFrameGenerate.Common.CurrentUser.SetCurrUser(RFrameGenerate.Common.CurrentManage.TestUserName, RFrameGenerate.Common.CurrentManage.TestMemberGuid);
#endif

            }
        }
        #endregion

        public static bool IsDevelop()
        {
            if (CurrentManage.IsDebug) return true;

            if (CurrentManage.MerchantUserID == "liuyi" )return true;
            
            if(CurrentManage.MerchantUserID == "jioukeji01" )return true;
            
            if (CurrentManage.MerchantUserID == "jioushuiguo") return true;

            if (System.Web.HttpContext.Current == null) return false;

            if (System.Web.HttpContext.Current.Request == null) return false;

            if (System.Web.HttpContext.Current.Request.Url == null) return false;

            string url = System.Web.HttpContext.Current.Request.Url.AbsoluteUri;

            if (string.IsNullOrEmpty(url)) return false;

            if (url.StartsWith("http://localhost/")) return true;

            if (!System.Text.RegularExpressions.Regex.IsMatch(url, @"http://(?<name>[^\.]*?)\.shop")) return false;

            string name = System.Text.RegularExpressions.Regex.Match(url, @"http://(?<name>[^\.]*?)\.shop").Groups["name"].Value;

            if (string.IsNullOrEmpty(name)) return false;

            if (name == "liuyi") return true;

            if (name == "jioukeji01") return true;

            if (name == "jioushuiguo") return true;

            return false;
        }
    }
}
