﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFrameGenerate.Common;

namespace RFrameGenerate.Common
{
    public class CurrentUser
    {
        public string UserName { get; set; }
        public Guid UserGuid { get; set; }

        public static void SetMemberInfo(CurrnetMemberInfo memberInfo)
        {
            BrowerRequest.SetSession(SessionKeys.SESSION_CURRENT_MEMBERINFO, memberInfo);
        }
        public static CurrnetMemberInfo GetMemberInfo()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.SESSION_CURRENT_MEMBERINFO) != null)
                    return (CurrnetMemberInfo)BrowerRequest.GetSession(SessionKeys.SESSION_CURRENT_MEMBERINFO);
                else
                    return null;
            }
            catch (Exception ex)
            {
                return null;
            }

        }

        public CurrentUser()
        {
            UserName = GetCurrUserName();
            UserGuid = GetCurrUserGuid();
        }
        /// <summary>
        /// 获取当前登录用户的用户名
        /// </summary>
        /// <returns>Username</returns>
        public static string GetCurrUserName()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.SESSION_ADMIN_USERNAME) != null)
                    return BrowerRequest.GetSession(SessionKeys.SESSION_ADMIN_USERNAME).ToString();
                return string.Empty;
            }
            catch
            {
                return string.Empty;
            }
        }
        /// <summary>
        /// 设置Session
        /// </summary>
        /// <param name="userName">用户名</param>
        /// <param name="userGuid">用户唯一标识</param>
        public static void SetCurrUser(string userName, Guid? userGuid)
        {
            BrowerRequest.SetSession(SessionKeys.SESSION_ADMIN_USERNAME, userName);

            BrowerRequest.SetSession(SessionKeys.SESSION_ADMIN_USERGUID, userGuid);
        }
        /// <summary>
        /// 获取当前登录用户的int
        /// </summary>
        /// <returns>int</returns>
        public static Guid GetCurrUserGuid()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.SESSION_ADMIN_USERGUID) != null)
                    return Guid.Parse(BrowerRequest.GetSession(SessionKeys.SESSION_ADMIN_USERGUID).ToString());
                throw new Exception("当前用户为null");
            }
            catch (Exception ex)
            {
                return Guid.Empty;
                //throw new Exception(ex.Message);
            }

        }
        static Guid adminIdentification;
        /// <summary>
        /// 管理员唯一标识
        /// </summary>
        public static Guid AdminIdentification
        {
            get
            {
                return adminIdentification;
            }
            set
            {
                if (value == null)
                {
                    throw new Exception("找不到配置文件中的<configuration><appSettings><add key=\"Admin\" value=\"管理员唯一标识\"/></appSettings></configuration>,添加手动添加");
                }
                adminIdentification = value;
            }
        }

        /// <summary>
        /// 获取框架隔离字段
        /// </summary>
        public static Guid GetSMerchantGuid()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_SMerchantGuid) != null)
                    return Guid.Parse(BrowerRequest.GetSession(SessionKeys.COOKIE_SMerchantGuid).ToString());
                return Guid.Empty;
            }
            catch (Exception ex)
            {
                return Guid.Empty;
                //throw new Exception(ex.Message);
            }
        }
        /// <summary>
        /// 获取框架隔离字段
        /// </summary>
        public static void SetSMerchantGuid(Guid merchantGuid)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_SMerchantGuid, merchantGuid);
        }


        /// <summary>
        /// 获取商家表主键
        /// </summary>
        public static Guid GetMerchantGuid()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.MerchantGuid) != null)
                    return Guid.Parse(BrowerRequest.GetSession(SessionKeys.MerchantGuid).ToString());
                return Guid.Empty;
            }
            catch (Exception ex)
            {
                return Guid.Empty;
                //throw new Exception(ex.Message);
            }
        }
        /// <summary>
        /// 获取框架隔离字段
        /// </summary>
        public static void SetMerchantGuid(Guid merchantGuid)
        {
            BrowerRequest.SetSession(SessionKeys.MerchantGuid, merchantGuid);
        }
        public static void SetMerchant(bool ismerchant)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_IsMerchant, ismerchant);
        }
        public static bool GetSMerchant()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_IsMerchant) != null)
                    return Convert.ToBoolean(BrowerRequest.GetSession(SessionKeys.COOKIE_IsMerchant).ToString());
                throw new Exception("未登录");
            }
            catch (Exception ex)
            {
                return false;
                //throw new Exception(ex.Message);
            }
        }


        /// <summary>
        /// 商家公众号appid
        /// </summary>
        public static string GetAppID()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.AppID) != null)
                    return BrowerRequest.GetSession(SessionKeys.AppID).ToString();
                return string.Empty;
            }
            catch (Exception ex)
            {
                return string.Empty;
                //throw new Exception(ex.Message);
            }
        }
        /// <summary>
        /// 商家公众号appid
        /// </summary>
        public static void SetAppID(string appID)
        {
            BrowerRequest.SetSession(SessionKeys.AppID, appID);
        }
        /// <summary>
        /// 设置是否是分销商
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetIsDistribution(bool isDistribution)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_IsDistribution, isDistribution);
        }
        /// <summary>
        /// 获取是还是是分销商
        /// </summary>
        /// <returns></returns>
        public static bool GetIsDistribution()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_IsDistribution) != null)
                    return Convert.ToBoolean(BrowerRequest.GetSession(SessionKeys.COOKIE_IsDistribution).ToString());
                throw new Exception("未登录");
            }
            catch (Exception ex)
            {
                return false;
                //throw new Exception(ex.Message);
            }
        }

        /// <summary>
        /// 设置商家userid
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetMerchantUserID(string merchantUserID)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_MerchantUserID, merchantUserID);
        }
        /// <summary>
        /// 获取是还是是分销商
        /// </summary>
        /// <returns></returns>
        public static string GetMerchantUserID()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_MerchantUserID) != null)
                    return BrowerRequest.GetSession(SessionKeys.COOKIE_MerchantUserID).ToString();
                return null;
            }
            catch (Exception ex)
            {
                return null;
                //throw new Exception(ex.Message);
            }
        }

        /// <summary>
        /// 设置分销商Guid
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetDistributionGuid(Guid DistributionGuid)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_DistributionGuid, DistributionGuid);
        }
        /// <summary>
        /// 获取分销商Guid
        /// </summary>
        /// <returns></returns>
        public static Guid? GetDistributionGuid()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_DistributionGuid) != null)
                    return Guid.Parse( BrowerRequest.GetSession(SessionKeys.COOKIE_DistributionGuid).ToString());
                return null;
            }
            catch (Exception ex)
            {
                return null;
                //throw new Exception(ex.Message);
            }
        }


        /// <summary>
        /// 设置商家userid
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetLoginType(int type)
        {
            BrowerRequest.SetSession(SessionKeys.COOKIE_IsLoginType, type);
        }
        /// <summary>
        /// 获取是还是是分销商
        /// </summary>
        /// <returns></returns>
        public static int GetLoginType()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.COOKIE_IsLoginType) != null)
                    return Convert.ToInt32(BrowerRequest.GetSession(SessionKeys.COOKIE_IsLoginType));
                return 4;
            }
            catch (Exception ex)
            {
                return 4;
                //throw new Exception(ex.Message);
            }
        }



        /// <summary>
        /// 设置会员是否关注了
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetIsSubscribe(bool? isSubscribe)
        {            
            BrowerRequest.SetSession(SessionKeys.IsSubscribe, isSubscribe??false);
        }
        /// <summary>
        /// 获取会员是否关注了
        /// </summary>
        /// <returns></returns>
        public static bool GetIsSubscribe()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.IsSubscribe) != null)
                    return Convert.ToBoolean(BrowerRequest.GetSession(SessionKeys.IsSubscribe));
                return false;
            }
            catch (Exception ex)
            {
                return false;
                //throw new Exception(ex.Message);
            }
        }

        /// <summary>
        /// 客服代码
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetCS(string cscode)
        {
            BrowerRequest.SetSession(SessionKeys.CustomerServices, cscode);
        }
        /// <summary>
        /// 获取客服代码
        /// </summary>
        /// <returns></returns>
        public static string GetCS()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.CustomerServices) != null)
                    return BrowerRequest.GetSession(SessionKeys.CustomerServices).ToString();
                return string.Empty;
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        /// <summary>
        /// 设置商家类型
        /// </summary>
        /// <param name="isDistribution"></param>
        public static void SetMerchantType(int ver)
        {
            BrowerRequest.SetSession(SessionKeys.MerchantType, ver);
        }
        /// <summary>
        /// 获取商家类型
        /// </summary>
        /// <returns></returns>
        public static int GetMerchantType()
        {
            try
            {
                if (BrowerRequest.GetSession(SessionKeys.MerchantType) != null)
                    return int.Parse(BrowerRequest.GetSession(SessionKeys.MerchantType).ToString());
                throw new Exception("未登录");
            }
            catch (Exception ex)
            {
                throw ex ;
            }
        }
    }
}
