﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using RFrameGenerate.Common.Enums;

namespace RFrameGenerate.Common.DatabaseConfig
{
    /// <summary>
    /// 数据库管理类
    /// </summary>
    public sealed class Database
    {
        /// <summary>
        /// 初始化连接字符
        /// </summary>
        /// <param name="connectionString"></param>
        public static void InitConnection(string connectionString)
        {
            RFramework.SQLServer.SqlRConnection.SqlConnectionBuilder = new SqlConnectionStringBuilder(connectionString);
        }
        
        /// <summary>
        /// 获取连接字符串
        /// </summary>
        public static string ConnectionString
        {
            get { return RFramework.SQLServer.SqlRConnection.SqlConnectionBuilder.ToString(); }
        }

        private static string assemblyName = "RFrameGenerate.DAL";
        /// <summary>
        /// 程序集名
        /// </summary>
        public static string AssemblyName
        {
            get { return assemblyName; }
            set { assemblyName = value; }
        }

        private static DatabaseType databaseType = DatabaseType.SQLServer;
        /// <summary>
        /// 要连接的数据库类型
        /// </summary>
        public static DatabaseType DatabaseType
        {
            get { return databaseType; }
            set { databaseType = value; }
        }

    }
}
