﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace System
{
    public static class DateTimeEx
    {
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(MM-dd)</returns>
        public static string ToMDDateString(this DateTime time)
        {
            return time.ToString("MM-dd");
        }
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(MM-dd)</returns>
        public static string ToMDDateString(this DateTime? time)
        {
            if (time == null)
                return string.Empty;
            return time.Value.ToString("MM-dd");
        }
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(yyyy-MM-dd)</returns>
        public static string ToDateString(this DateTime time)
        {
            return time.ToString("yyyy-MM-dd") ;
        }
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(yyyy-MM-dd HH:mm:ss)</returns>
        public static string ToDateTimeString(this DateTime time)
        {
            return time.ToString("yyyy-MM-dd HH:mm:ss");
        }
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(yyyy-MM-dd)</returns>
        public static string ToDateString(this DateTime? time)
        {
            if (time == null)
                return string.Empty;
            return time.Value.ToString("yyyy-MM-dd");
        }
        /// <summary>
        /// 时间格式转换
        /// </summary>
        /// <returns>格式(yyyy-MM-dd HH:mm:ss)</returns>
        public static string ToDateTimeString(this DateTime? time)
        {
            if (time == null)
                return string.Empty;
            return time.Value.ToString("yyyy-MM-dd HH:mm:ss");
        }

        public static string ToString(this DateTime? time, string formatstr)
        {
            if (time == null)
                return string.Empty;
            return time.Value.ToString(formatstr);
        }

        /// <summary>  
        /// 获取当前时间戳  
        /// </summary>  
        /// <param name="bflag">为真时获取10位时间戳,为假时获取13位时间戳.</param>  
        /// <returns></returns>  
        public static string GetTimeStamp(bool bflag = true)
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            string ret = string.Empty;
            if (bflag)
                ret = Convert.ToInt64(ts.TotalSeconds).ToString();
            else
                ret = Convert.ToInt64(ts.TotalMilliseconds).ToString();

            return ret;
        }
        /// <summary>
        /// 已重载.计算两个日期的时间间隔,返回的是时间间隔的日期差的绝对值.
        /// </summary>
        /// <param name="DateTime1">第一个日期和时间</param>
        /// <returns></returns>
        public static int DateDiff(DateTime DateTime1)
        {
            int dateDiff = 0;
            try
            {
                TimeSpan ts1 = new TimeSpan(DateTime1.Ticks);
                TimeSpan ts2 = new TimeSpan(DateTime.Now.Ticks);
                TimeSpan ts = ts1.Subtract(ts2).Duration();
                dateDiff = int.Parse(ts.Days.ToString());
            }
            catch
            {

            }
            return dateDiff;
        }

        /// <summary>
         /// 已重载.计算两个日期的时间间隔,返回的是时间间隔的日期差的绝对值.
         /// </summary>
         /// <param name="DateTime1">第一个日期和时间</param>
         /// <param name="DateTime2">第二个日期和时间</param>
         /// <returns></returns>
        public static string DateDiff(DateTime DateTime1, DateTime DateTime2)
         {
             string dateDiff=null;
             try
             {
                 TimeSpan ts1=new   TimeSpan(DateTime1.Ticks);
                 TimeSpan ts2=new   TimeSpan(DateTime2.Ticks);
                 TimeSpan ts=ts1.Subtract(ts2).Duration();
                 dateDiff=ts.Days.ToString()+"天"
                         +ts.Hours.ToString()+"小时"
                         +ts.Minutes.ToString()+"分钟"
                         +ts.Seconds.ToString()+"秒";
             }
             catch
             {

             }
             return dateDiff;
         }

    }
}
