﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Text.RegularExpressions;

namespace RFrameGenerate.Common
{
    public class KuaiShangRequest
    {
        public KuaiShangRequest() { }
        public KuaiShangRequest(string keynumber)
        {
            this.keynumber = keynumber;
        }
        string apiurl = "http://shop.kuaishang.cn/api/thirdregist.php";
        /// <summary>
        /// 设置api地址
        /// </summary>
        /// <param name="apiurl"></param>
        public void SetApiUrl(string apiurl)
        {
            this.apiurl = apiurl;
        }
        /// <summary>
        /// 用户名
        /// </summary>
        public string username { get; set; }
        /// <summary>
        /// 密码
        /// </summary>
        public string password { get; set; }
        /// <summary>
        /// 公司名称
        /// </summary>
        public string company { get; set; }
        /// <summary>
        /// 公司地址
        /// </summary>
        public string compAddr { get; set; }
        /// <summary>
        /// 公司网址
        /// </summary>
        public string weburl { get { return RFrameGenerate.Common.CurrentManage.IsDebug == true ? "http://jioukeji.com" : "http://jioufenxiao.com"; } }
        /// <summary>
        /// 行业
        /// </summary>
        public string industryCategory { get; set; }
        /// <summary>
        /// 联系人
        /// </summary>
        public string linkman { get; set; }
        /// <summary>
        /// 联系电话
        /// </summary>
        public string phone { get; set; }
        /// <summary>
        /// 邮箱
        /// </summary>
        public string email { get; set; }
        /// <summary>
        /// 手机号码
        /// </summary>
        public string mobile { get; set; }
        /// <summary>
        /// 平台信息
        /// </summary>
        public string keytype { get { return Utils.Md5(string.Format("{0}{1}", RFrameGenerate.Common.CurrentManage.IsDebug == true ? "jioukeji.com" : "jioufenxiao.com", keynumber)); } }
        /// <summary>
        /// 平台用户
        /// </summary>
        public string keynumber { get; set; }

        /// <summary>
        /// (Post)获取请求的HttpWebResponse
        /// </summary>
        /// <param name="url">请求的url</param>
        /// <param name="postDate">参数</param>
        /// <returns></returns>
        string PostResponseString(string url, string postDate)
        {
            string result;
            HttpWebRequest request = RequestHepler.CreatePostHttpResponse(url);
            using (StreamWriter sw = new StreamWriter(request.GetRequestStream()))
            {
                sw.Write(postDate);
                sw.Flush();
            }
            HttpWebResponse response = request.GetResponse() as HttpWebResponse;
            using (StreamReader sw = new StreamReader(response.GetResponseStream(), encoding))
            {
                result = sw.ReadToEnd();
            }
            response.Close();
            return result;
        }

        System.Text.Encoding encoding = Encoding.UTF8;

        public KuaiShangResponse Request()
        {
            string weburlnew=weburl;
            string keytypenew=keytype;
            if(CurrentManage.Domain.Contains(".a5ws.com")==true)
            {
                weburlnew = "http://shop.a5ws.com/";
                keytypenew = Utils.Md5(string.Format("{0}{1}", "a5ws.com", keynumber)); 
            }

            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("{0}={1}&", "username", System.Web.HttpUtility.UrlEncode(username, encoding));
            sb.AppendFormat("{0}={1}&", "password", System.Web.HttpUtility.UrlEncode(password, encoding));
            sb.AppendFormat("{0}={1}&", "company", System.Web.HttpUtility.UrlEncode(company, encoding));
            sb.AppendFormat("{0}={1}&", "compAddr", System.Web.HttpUtility.UrlEncode(compAddr, encoding));
            sb.AppendFormat("{0}={1}&", "weburl", System.Web.HttpUtility.UrlEncode(weburlnew, encoding));
            sb.AppendFormat("{0}={1}&", "industryCategory", System.Web.HttpUtility.UrlEncode(industryCategory, encoding));
            sb.AppendFormat("{0}={1}&", "linkman", System.Web.HttpUtility.UrlEncode(linkman, encoding));
            sb.AppendFormat("{0}={1}&", "phone", System.Web.HttpUtility.UrlEncode(phone, encoding));
            sb.AppendFormat("{0}={1}&", "email", System.Web.HttpUtility.UrlEncode(email, encoding));
            sb.AppendFormat("{0}={1}&", "mobile", System.Web.HttpUtility.UrlEncode(mobile, encoding));
            sb.AppendFormat("{0}={1}&", "keytype", System.Web.HttpUtility.UrlEncode(keytypenew, encoding));
            sb.AppendFormat("{0}={1}&", "keynumber", System.Web.HttpUtility.UrlEncode(keynumber, encoding));
            sb.Length -= 1;
            //"{\"success\":false,\"msg\":\"keytype or keynumber is not exist\"}"
            var json = PostResponseString(apiurl, sb.ToString());
            KuaiShangResponse response;
            try
            {
                System.Web.Script.Serialization.JavaScriptSerializer java = new System.Web.Script.Serialization.JavaScriptSerializer();
                response = java.Deserialize<KuaiShangResponse>(json);
            }
            catch (Exception ex)
            {
                response = new KuaiShangResponse() { success = false, msg = ex.Message, param = "请求参数:" + sb.ToString() + ",返回结果:" + json };
            }

            response.param = "请求参数:" + sb.ToString() + ",返回结果:" + json;
            return response;
        }
    }

    public class KuaiShangResponse
    {
        /// <summary>
        /// 注册成功或者失败，如果已经注册过，返回是先前注册的信息，返回也是true
        /// </summary>
        public bool success { get; set; }
        /// <summary>
        /// 失败时的错误信息
        /// </summary>
        public string msg { get; set; }
        /// <summary>
        /// 注册成功的公司ID
        /// </summary>
        public string compId { get; set; }
        /// <summary>
        /// 注册成功的默认用户名
        /// </summary>
        public string username { get; set; }
        /// <summary>
        /// 对应的默认生成代码
        /// </summary>
        public string code { get; set; }

        public string param { get; set; }
    }
}
