﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Common
{
    public class OpenIDManage
    {
        const string openidname = "liuyi";
        /// <summary>
        /// 当前openid的key
        /// </summary>
        public static string OpenIDKey
        {
            get
            {
                return openidname + CurrentManage.MerchantUserID;
            }
        }
        /// <summary>
        /// 当前转发的key
        /// </summary>
        public static string OpenTranIDKey
        {
            get
            {
                return "tran" + openidname + CurrentManage.MerchantUserID;
            }
        }
        /// <summary>
        /// 获取openid 
        /// </summary>
        /// <returns></returns>
        public static string GetOpenID()
        {
            var openid = BrowerRequest.GetSession(OpenIDKey);
            if (openid != null)
            {
                return openid.ToString();
            }
            else
            {
                if (CurrentManage.IsDebug == true)
                    return CurrentManage.TestMemberOpenID;
                else
                    return string.Empty;
            }
        }
        /// <summary>
        /// 设置openid到Session
        /// </summary>
        /// <param name="openid"></param>
        public static void SetOpenID(string openid)
        {
            BrowerRequest.SetSession(OpenIDKey, openid);
        }
    }
}
