﻿using Gma.QrCodeNet.Encoding;
using Gma.QrCodeNet.Encoding.Windows.Render;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Web;
namespace RFrameGenerate.Common
{
    public class QrCodeHelper
    {
        public static bool GenerationQrCode(string value, string text, string filename)
        {
            try
            {
                QrEncoder qrEncoder = new QrEncoder(ErrorCorrectionLevel.M);
                QrCode qrCode = qrEncoder.Encode(value);

                GraphicsRenderer gRender = new GraphicsRenderer(new FixedModuleSize(15, QuietZoneModules.Four));

                using (MemoryStream mstream = new MemoryStream())
                {
                    gRender.WriteToStream(qrCode.Matrix, ImageFormat.Png, mstream, new Point(400, 400));

                    using (var img = Image.FromStream(mstream))
                    {
                        if (System.IO.Directory.Exists(Path.GetDirectoryName(filename)) != true)
                            System.IO.Directory.CreateDirectory(Path.GetDirectoryName(filename));

                        img.Save(filename);
                        //ImageWaterMarkText(img, filename, text, 7, 100, "宋体", 40);zhou 2016/4/15 屏蔽 越压缩越大
                    }
                }

                return true;
            }
            catch
            {
                return false;
            }
        }

        public static void ImageWaterMarkText(Image img, string filename, string watermarkText, int watermarkStatus, int quality, string fontname, int fontsize)
        {
            Graphics g = Graphics.FromImage(img);
            Font drawFont = new Font(fontname, fontsize, FontStyle.Regular, GraphicsUnit.Pixel);
            SizeF crSize;
            crSize = g.MeasureString(watermarkText, drawFont);

            float xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
            float ypos = ((float)img.Height * (float).99) - crSize.Height;
            
            g.DrawString(watermarkText, drawFont, new SolidBrush(Color.Black), xpos, ypos);

            ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();
            ImageCodecInfo ici = null;
            foreach (ImageCodecInfo codec in codecs)
            {
                if (codec.MimeType.IndexOf("jpeg") > -1)
                    ici = codec;
            }
            EncoderParameters encoderParams = new EncoderParameters();
            long[] qualityParam = new long[1];
            if (quality < 0 || quality > 100)
                quality = 80;

            qualityParam[0] = quality;

            EncoderParameter encoderParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, qualityParam);
            encoderParams.Param[0] = encoderParam;

            if (System.IO.Directory.Exists(Path.GetDirectoryName(filename)) != true)
                System.IO.Directory.CreateDirectory(Path.GetDirectoryName(filename));

            if (ici != null)
                img.Save(filename, ici, encoderParams);
            else
                img.Save(filename);

            g.Dispose();
            img.Dispose();
        }
    }
}
