﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Web.Caching;


namespace RFrameGenerate.Common
{
    public static class CacheHelper
    {
        #region 基本

        /// <summary>
        /// 创建缓存项的文件依赖
        /// </summary>
        /// <param name="key">缓存Key</param>
        /// <param name="obj">object对象</param>
        /// <param name="fileName">文件绝对路径</param>
        public static void Insert(string key, object obj, string fileName)
        {
            //创建缓存依赖项
            CacheDependency dep = new CacheDependency(fileName);
            //创建缓存
            HttpContext.Current.Cache.Insert(key, obj, dep);
        }
        /// <summary>
        /// 创建缓存项过期
        /// </summary>
        /// <param name="key">缓存Key</param>
        /// <param name="obj">object对象</param>
        /// <param name="expires">过期时间(分钟)</param>
        public static void Insert(string key, object obj, int expires)
        {
            HttpContext.Current.Cache.Insert(key, obj, null, Cache.NoAbsoluteExpiration, new TimeSpan(0, expires, 0));
        }
        /// <summary>
        /// 获取缓存对象
        /// </summary>
        /// <param name="key">缓存Key</param>
        /// <returns>object对象</returns>
        public static object Get(string key)
        {
            if (string.IsNullOrEmpty(key))
            {
                return null;
            }
            return HttpContext.Current.Cache.Get(key);
        }
        /// <summary>
        /// 获取缓存对象
        /// </summary>
        /// <typeparam name="T">T对象</typeparam>
        /// <param name="key">缓存Key</param>
        /// <returns></returns>
        public static T Get<T>(string keyName)
        {
            object obj = Get(keyName);
            return obj == null ? default(T) : (T)obj;
        }

        public static void RemoveCache(string key)
        {
            HttpContext.Current.Cache.Remove(key);
        }
        #endregion

        #region 扩展

        /// <summary>
        /// 用于缓存发生变化时, 通过清除缓存依赖项 清空对应的缓存
        /// </summary>
        /// <param name="dependKey">缓存依赖项</param>
        public static void ClearCache(string keyName, bool isCommonkey = false)
        {

            if (!isCommonkey)
            {
                keyName = "Depend_" + keyName;
            }

            var Cache = HttpContext.Current.Cache;

            if (Cache[keyName] == null)
            {
                Cache[keyName] = 1;
            }
            else
            {
                int currnum = ((int)Cache[keyName] > 10000) ? 1 : (int)Cache[keyName];
                Cache[keyName] = currnum + 1;
            }
        }
        /// <summary>
        /// 获取缓存对象
        /// </summary>
        /// <typeparam name="T">T对象</typeparam>
        /// <param name="key">缓存Key(自动加Cache_)</param>
        /// <returns></returns>
        public static T GetCache<T>(string keyName)
        {
            keyName = "Cache_" + keyName;
            object obj = Get(keyName);
            return obj == null ? default(T) : (T)obj;
        }
        /// <summary>
        /// 设置缓存值
        /// </summary>
        /// <typeparam name="T">数据类型</typeparam>
        /// <param name="keyName">键名(自动加Cache_)</param>
        /// <param name="data">缓存值</param>
        public static void SetCache(string keyName, Object data, string depengkeyName = "")
        {
            var Cache = HttpContext.Current.Cache;
            var cachekeyName = "Cache_" + keyName;
            var depengkey = "Depend_" + keyName;
            if (!string.IsNullOrEmpty(depengkeyName))
            {
                depengkey = depengkeyName;
            }

            if (Cache[depengkey] == null)
                Cache[depengkey] = 1;

            string[] cacheKeys = { depengkey };

            CacheDependency dependency = new CacheDependency(null, cacheKeys);
            //创建缓存
            Cache.Add(cachekeyName, data, dependency, Cache.NoAbsoluteExpiration, new TimeSpan(0, 30, 0), CacheItemPriority.Default, null);
        }

        #endregion

        #region add by Panwp

        public static Dictionary<K, T> CreateDicCache<K, T>()
        {
            return new Dictionary<K, T>();
        }

        public static T GetDicCache<K, T>(K key, Dictionary<K, T> cache)
        {
            if (cache.ContainsKey(key)) return cache[key];

            return default(T);
        }

        public static void SetDicCache<K, T>(K key, T value, Dictionary<K, T> cache)
        {
            if (cache.ContainsKey(key)) return;

            cache.Add(key, value);       
        }

        #endregion
    }
}
