﻿using System;
using System.Text;
using System.Net.Mail;
using System.Threading;

namespace RFrameGenerate.Common
{
    public class EmailServer
    {
        /// <summary>
        /// 发送邮件服务
        /// </summary>
        /// <param name="_companySign">公司标示</param>
        /// <param name="_strAccount">邮箱账户</param>
        /// <param name="_strPwd">账户密码</param>
        /// <param name="_strSend">邮件发送方(Email)</param>
        /// <param name="_smtpServer">邮件发送服务器地址</param>
        /// <param name="_port">邮件发送服务器端口</param>
        public EmailServer(string _companySign, string _strAccount, string _strPwd, string _strSend, string _smtpServer, int _port = 25)
        {
            companySign = _companySign;
            strAccount = _strAccount;
            strPwd = _strPwd;
            strSend = _strSend;
            smtpServer = _smtpServer;
            port = _port;
        }

        private static string companySign = string.Empty;
        private static string strAccount = string.Empty;
        private static string strPwd = string.Empty;
        private static string strSend = string.Empty;
        private static int port = 25;
        private static string smtpServer = string.Empty;


        /// <summary>
        /// 发送邮件
        /// </summary>
        /// <param name="title">标题 </param>
        /// <param name="content">内容</param>
        /// <param name="strReceive">接收方的邮箱地址</param>
        /// <returns></returns>
        public void SendEmail(string title, string content, string strReceive ,bool IsAsync = true )
        {
            string CompanySign = companySign;// "新视野网络";
 

            if (string.IsNullOrEmpty(strSend))
            {
                strSend = strAccount;
            }

            var mailMessage = new MailMessage(new MailAddress(strSend, ""), new MailAddress(strReceive))
            {
                Subject = title,
                Body = content,
                BodyEncoding = Encoding.UTF8,
                IsBodyHtml = true,
                Sender = new MailAddress(strSend, CompanySign),
                From = new MailAddress(strSend, CompanySign),
                Priority = MailPriority.Normal
            };

            var smtpClient = new SmtpClient(smtpServer, port)
            {
                DeliveryMethod = SmtpDeliveryMethod.Network,
                Host = smtpServer,
                Credentials = new System.Net.NetworkCredential(strAccount, strPwd)
            };

            if (!IsAsync)
            {
                smtpClient.Send(mailMessage);
                smtpClient.Dispose();
            }
            else
            {
                Thread thead = new Thread(new ParameterizedThreadStart(SendEmailProcess));
                thead.Start(new Model() { mail = mailMessage, client = smtpClient });
            }

        }

        private void SendEmailProcess(object o)
        {
            Model model = o as Model;
            model.client.Send(model.mail);
            model.client.Dispose();
        }
    }

    public class Model
    {
        public MailMessage mail { get; set; }
        public SmtpClient client { get; set; }
    }
}
