﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Common
{
    /// <summary>
    /// 定义泛型哈希表，定义泛型类型TK和TV，
    /// 此哈希表可以随时调用Sort方法按键对元素进行排序
    /// 泛型TK类型为键的数据类型，泛型TV类型为值的数据类型
    /// </summary>
    /// <typeparam name="TK"></typeparam>
    /// <typeparam name="TV"></typeparam>
    public class SortHashTable<TK, TV>
    {
        //定义系统哈希表变量，用来存放键/值数据
        private Dictionary<TK, TV> dataPool;
        //定义列表变量，存放键的集合，并用其执行排序功能
        private List<TK> sortKey;
        //返回哈希表，也就是返回所有存放的数据
        public Dictionary<TK, TV> Data
        {
            get { return this.dataPool; }
        }
        //返回键的集合
        public List<TK> Key
        {
            get { return this.sortKey; }
        }
        //按照键来返回值,不存在返回默认
        public TV Get(TK key)
        {
            try
            {
                if (this.dataPool.ContainsKey(key))
                {
                    return this.dataPool[key];
                }
                else
                {
                    Type type = typeof(TV);
                    var v = Activator.CreateInstance(type);
                    return (TV)v;
                }
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }
        //返回枚举器
        public IEnumerator<TK> GetEnumerator()
        {
            return this.sortKey.GetEnumerator();
        }
        //向哈希表添加数据
        public void Add(TK key, TV values)
        {
            this.dataPool.Add(key, values);
            this.sortKey.Add(key);
        }
        //对键进行排序
        public void Sort()
        {
            this.sortKey.Sort();
        }
        //构造方法，创建泛型dataPool和sortKey集合
        public SortHashTable()
        {
            this.dataPool = new Dictionary<TK, TV>();
            this.sortKey = new List<TK>();
        }
    }
}
