﻿using RFrameGenerate.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace System.Web
{
    /// <summary>
    /// Url 重写
    /// </summary>
    public class Urls
    {
        public Urls()
        {
            this.UrlList = new List<UrlItem>();
        }
        List<UrlItem> UrlList { get; set; }
        /// <summary>
        /// 设置js域名
        /// </summary>
        /// <param name="domain">域名</param>
        public void SetJsUrl(string domain)
        {
            if (domain.EndsWith("/") != true && domain != "~")
                domain += "/";
            var dom = UrlList.Where(a => a.UrlType == UrlType.js).FirstOrDefault();
            if (dom == null)
                UrlList.Add(new UrlItem(domain, UrlType.js));
            else
                dom.Domain = domain;
        }
        /// <summary>
        /// 设置css域名
        /// </summary>
        /// <param name="domain">域名</param>
        public void SetCssUrl(string domain)
        {
            if (domain.EndsWith("/") != true && domain != "~")
                domain += "/";
            var dom = UrlList.Where(a => a.UrlType == UrlType.css).FirstOrDefault();
            if (dom == null)
                UrlList.Add(new UrlItem(domain, UrlType.css));
            else
                dom.Domain = domain;
        }
        /// <summary>
        /// 设置ing域名
        /// </summary>
        /// <param name="domain">域名</param>
        public void SetImgUrl(string domain)
        {
            if (domain.EndsWith("/") != true && domain != "~")
                domain += "/";
            var dom = UrlList.Where(a => a.UrlType == UrlType.img).FirstOrDefault();
            if (dom == null)
                UrlList.Add(new UrlItem(domain, UrlType.img));
            else
                dom.Domain = domain;
        }

        public static Urls Instance = new Urls();
        /// <summary>
        /// Js Url重写
        /// </summary>
        /// <param name="relativePath">相对路径</param>
        /// <returns>返回重写的url</returns>
        public static string JsUrl(string relativePath)
        {
            return Url(relativePath, UrlType.js);
        }
        /// <summary>
        /// Css Url重写
        /// </summary>
        /// <param name="relativePath">相对路径</param>
        /// <returns>返回重写的url</returns>
        public static string CssUrl(string relativePath)
        {
            return Url(relativePath, UrlType.css);
        }
        /// <summary>
        /// Img Url重写
        /// </summary>
        /// <param name="relativePath">相对路径</param>
        /// <returns>返回重写的url</returns>
        public static string ImgUrl(string relativePath)
        {
            return Url(relativePath, UrlType.img);
        }
        /// <summary>
        /// Url重写
        /// </summary>
        /// <param name="relativePath">相对路径</param>
        /// <returns>返回重写的url</returns>
        public static string Url(string relativePath, UrlType type)
        {

            if(CurrentManage.IsDebug==true)
            {
                relativePath += "?v="+DateTime.Now.Second;
            }

            //未初始化,返回原来路径
            if (Instance.UrlList == null || Instance.UrlList.Count() == 0)
                return relativePath;

            var url = Instance.UrlList.Where(a => a.UrlType == type).FirstOrDefault();
            if (url == null || url.Domain == "~")
            {
                if (relativePath.StartsWith("~") == true)
                {
                    relativePath = relativePath.Substring(1);
                }
                return relativePath;
            }

            /*
            ~/Scripts/
            /Scripts/
             ../Scripts/
             ../../Scripts/
             ../../../Scripts/
             */

            if (relativePath.StartsWith("~") == true)
            {
                relativePath = relativePath.Substring(2);
            }
            else if (relativePath.StartsWith(".") == true)
            {
                relativePath = relativePath.Replace("../", string.Empty);
            }
            else if (relativePath.StartsWith("/") == true)
            {
                relativePath = relativePath.Substring(1);
            }

            return string.Format("{0}{1}", url.Domain, relativePath);
        }
    }

    public class UrlItem
    {
        public UrlItem() { }
        public UrlItem(string domain, UrlType type)
        {
            this.Domain = domain;
            this.UrlType = type;
        }
        public string Domain { get; set; }
        public UrlType UrlType { get; set; }
    }
    /// <summary>
    /// 资源类型
    /// </summary>
    public enum UrlType
    {
        /// <summary>
        /// js资源
        /// </summary>
        js = 1,
        /// <summary>
        /// css资源
        /// </summary>
        css = 2,
        /// <summary>
        /// img资源
        /// </summary>
        img = 3,
    }
}