﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace RFrameGenerate.Common
{
    public class WebManage
    {
        static WebManage()
        {
            time = new System.Timers.Timer();
            time.Interval = 10 * 60 * 1000;
            time.Elapsed += time_Elapsed;
            time.Start();
        }

        static System.Timers.Timer time;
        static object webmanagelock = new object();
        static void time_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            Read();
        }

        public static string filepath = "";
        static List<AllowUrl> AllowUrl = new List<AllowUrl>();
        static List<WebTitle> WebTitle = new List<WebTitle>();
        public static void Read()
        {
            lock (webmanagelock)
            {
                XmlDocument doc = new XmlDocument();
                doc.Load(filepath);
                AllowUrl.Clear();
                foreach (XmlElement v in doc.SelectNodes("Web/AllowUrl/Url"))
                {
                    AllowUrl.Add(new AllowUrl(v.Attributes["urlrule"].Value.ToLower(), (v.Attributes["enable"].Value.ToString().ToLower() == "true" ? true : false)));
                }
                WebTitle.Clear();
                foreach (XmlElement v in doc.SelectNodes("Web/WebTitle/Title"))
                {
                    WebTitle.Add(new WebTitle(v.Attributes["urlrule"].Value.ToLower(), v.Attributes["webtitle"].Value, (v.Attributes["enable"].Value.ToString().ToLower() == "true" ? true : false)));
                }
            }
        }

        public static bool IsAllowVisit(string url)
        {
            lock (webmanagelock)
            {
                url = url.Split(new string[] { "?" }, StringSplitOptions.RemoveEmptyEntries)[0].ToLower();
                foreach (var v in AllowUrl)
                {
                    if (v.enable == true && url.Contains(v.urlrule) == true)
                    {
                        return true;
                    }
                }
                return false;
            }
        }

        public static string GetWebTitle(string url)
        {
            lock (webmanagelock)
            {
                url = url.Split(new string[] { "?" }, StringSplitOptions.RemoveEmptyEntries)[0].ToLower();
                foreach (var v in WebTitle)
                {
                    if (v.enable == true && url.Contains(v.urlrule) == true)
                    {
                        return v.webtitle;
                    }
                }
                return "分销系统";
            }
        }
    }

    public class AllowUrl
    {
        public AllowUrl(string urlrule, bool enable)
        {
            this.urlrule = urlrule;
            this.enable = enable;
        }
        public string urlrule { get; set; }
        public bool enable { get; set; }
    }
    public class WebTitle
    {
        public WebTitle(string urlrule, string webtitle, bool enable)
        {
            this.urlrule = urlrule;
            this.webtitle = webtitle;
            this.enable = enable;
        }
        public string urlrule { get; set; }
        public bool enable { get; set; }
        public string webtitle { get; set; }
    }


}
