﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using RFrameGenerate.Model;
using RFramework.SQLServer;
using RFramework.SQLServer.Enums;
using RFrameGenerate.DAL.Enums;
using RFramework.SQLQuery;
using System.Data.SqlClient;
using RFrameGenerate.Model.Datas;

namespace RFrameGenerate.DAL.SQLServer
{
    public partial class IProcedure : IDisposable
    {
        SqlRTransaction transaction;

        #region ...
        public IProcedure(SqlRTransaction transaction = null)
        {
            this.transaction = transaction;
        }
        #region IDisposable 成员

        public void Dispose()
        {
            if (transaction != null)
                transaction.Dispose();
        }

        #endregion
        #endregion

        #region Datas

        /// <summary>
        /// 获取访问数据统计
        /// </summary>
        /// <returns></returns>
        public List<StatisticsDataModel> GetDataStatisticsList(DataStatisticsType type, DateTime dateFrom, DateTime dateTo, Guid head, Guid agent, Guid merch)
        {
            return SqlHelper.RunProcedureList<StatisticsDataModel>("DataStatisticsProc", transaction,
                SqlRParameter.GetParameter("@DateFrom", SqlDbType.NVarChar, dateFrom),
                SqlRParameter.GetParameter("@DateTo", SqlDbType.NVarChar, dateTo),
                SqlRParameter.GetParameter("@VisitType", SqlDbType.NVarChar, (int)type),
                SqlRParameter.GetParameter("@head", SqlDbType.VarChar, head.ToString()),
                SqlRParameter.GetParameter("@agent", SqlDbType.VarChar, agent.ToString()),
                SqlRParameter.GetParameter("@merch", SqlDbType.VarChar, merch.ToString()));
        }
        public List<StatisticsDataModel> GetDataOnlineStatisticsList(DataType type, DateTime dateFrom, DateTime dateTo)
        {
            return SqlHelper.RunProcedureList<StatisticsDataModel>("DataStatisticsOnlineProc", transaction,
                SqlRParameter.GetParameter("@DateFrom", SqlDbType.NVarChar, dateFrom),
                SqlRParameter.GetParameter("@DateTo", SqlDbType.NVarChar, dateTo),
                SqlRParameter.GetParameter("@Type", SqlDbType.Int, (int)type));
        }
        #endregion

        /// <summary>
        /// 获取List
        /// </summary>
        /// <returns></returns>
        public List<T_SYS_Parameter> GetPDemoList()
        {
            return SqlHelper.RunProcedureList<T_SYS_Parameter>("PDemo", transaction,
                SqlRParameter.GetParameter("@strOrder", SqlDbType.NVarChar, "ParameterName"),
                SqlRParameter.GetParameter<T_SYS_Parameter>("strCondition", SqlDbType.NVarChar, a => a.ParameterName == "小周" || a.ParameterValue == "61"));
        }
        /// <summary>
        /// 获取List
        /// </summary>
        /// <returns></returns>
        public List<T_SYS_Parameter> GetPDemoList(Expression<Func<T_SYS_Parameter, bool>> conditionExpression)
        {
            return SqlHelper.RunProcedureList<T_SYS_Parameter>("PDemo", transaction,
                SqlRParameter.GetParameter("@strOrder", SqlDbType.NVarChar, "ParameterName"),
                SqlRParameter.GetParameter<T_SYS_Parameter>("strCondition", SqlDbType.NVarChar, conditionExpression));
        }

        /// <summary>
        /// 根据关键字查找图文
        /// </summary>
        /// <returns></returns>
        public List<GetTxtByKeyword> GetTxtByKeyword(Guid replyguid)
        {
            return SqlHelper.RunProcedureList<GetTxtByKeyword>("GetTxtByKeyword", transaction,
                SqlRParameter.GetParameter("@replyguid", SqlDbType.UniqueIdentifier, replyguid));
        }

        /// <summary>
        /// 根据关键字查找相应的条数
        /// </summary>
        /// <param name="merchantGuid"></param>
        /// <returns></returns>
        public List<PT_BAS_Orders_Select> GetStatCountByGuid(Guid merchantGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Orders_Select>("PT_BAS_Orders_Select", transaction,
                SqlRParameter.GetParameter("@merchantGuid", SqlDbType.UniqueIdentifier, merchantGuid));
        }

        public List<PT_BAS_Orders_SelectAll> GetOrderList(Guid memberGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Orders_SelectAll>("PT_BAS_Orders_SelectAll", transaction,
                SqlRParameter.GetParameter("@MemberGuid", SqlDbType.UniqueIdentifier, memberGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }
        public List<PT_BAS_FavoritesSelect> GetFavoriteList(Guid memberGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_FavoritesSelect>("PT_BAS_FavoritesSelect", transaction,
                SqlRParameter.GetParameter("@MemberGuid", SqlDbType.UniqueIdentifier, memberGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }
        public List<PT_BAS_ProductByPage> GetProductByPages(int pageIndex, int pageSize, string searchKey, string orderKey, string categoty)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductByPage>("PT_BAS_ProductByPage", transaction,
                SqlRParameter.GetParameter("@pageIndex", SqlDbType.Int, pageIndex),
                SqlRParameter.GetParameter("@pageSize", SqlDbType.Int, pageSize),
                SqlRParameter.GetParameter("@merchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid),
                SqlRParameter.GetParameter("@categoty", SqlDbType.NVarChar, categoty),
                SqlRParameter.GetParameter("@searchKey", SqlDbType.NVarChar, searchKey),
                SqlRParameter.GetParameter("@orderKey", SqlDbType.NVarChar, orderKey)
                );
        }
        /// <summary>
        /// 根据公众原始id获取商家表
        /// </summary>
        /// <param name="user_name"></param>
        /// <returns></returns>
        public PT_BAS_MerchantByWechat GetMerchantByWechat(string user_name)
        {
            return SqlHelper.RunProcedure<PT_BAS_MerchantByWechat>("PT_BAS_MerchantByWechat", transaction,
                SqlRParameter.GetParameter("@user_name", SqlDbType.NVarChar, user_name));
        }
        /// <summary>
        /// 获取分销统计数据
        /// </summary>
        /// <returns></returns>
        public PT_BAS_Distribute_GetTotal GetDistributeTotal()
        {
            return SqlHelper.RunProcedure<PT_BAS_Distribute_GetTotal>("PT_BAS_Distribute_GetTotal", transaction,
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }
        /// <summary>
        /// 设置分销商等级(停用)
        /// </summary>
        /// <returns></returns>
        public int SetDistributionLevel()
        {
            return SqlHelper.RunProcedure("PT_BAS_DistributionLevel", transaction,
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }
        /// <summary>
        /// 获取分销订单商品佣金明细
        /// </summary>
        /// <returns></returns>
        public PT_BAS_Distribution_OrderDetail GetDistribution_OrderDetail(Guid OrderDetailGuid)
        {
            return SqlHelper.RunProcedure<PT_BAS_Distribution_OrderDetail>("PT_BAS_Distribution_OrderDetail", transaction,
                SqlRParameter.GetParameter("@OrderDetailGuid", SqlDbType.UniqueIdentifier, OrderDetailGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }

        /// <summary>
        /// 根据状态获取分销订单商品统计
        /// </summary>
        /// <returns></returns>
        public PT_BAS_Distribution_TotalOrders GetDistribution_TotalOrders(Guid merchantGuid, Guid DistributionPropGuid, int OrderInnerState)
        {
            return SqlHelper.RunProcedure<PT_BAS_Distribution_TotalOrders>("PT_BAS_Distribution_TotalOrders", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, merchantGuid),
                SqlRParameter.GetParameter("@DistributionPropGuid", SqlDbType.UniqueIdentifier, DistributionPropGuid),
                SqlRParameter.GetParameter("@OrderInnerState", SqlDbType.Int, OrderInnerState),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }

        /// <summary>
        /// 获取所有分销订单商品统计
        /// </summary>
        /// <returns></returns>
        public PT_BAS_Distribution_TotalOrders GetDistribution_TotalOrders(Guid merchantGuid, Guid DistributionPropGuid)
        {
            return SqlHelper.RunProcedure<PT_BAS_Distribution_TotalOrders>("PT_BAS_Distribution_TotalOrders_All", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, merchantGuid),
                SqlRParameter.GetParameter("@DistributionPropGuid", SqlDbType.UniqueIdentifier, DistributionPropGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }

        /// <summary>
        /// 根据状态获取分销订单列表
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_Distribution_List_Level> GetDistribution_List(int OrderInnerState, Guid DistributionPropGuid, Guid merchantGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Distribution_List_Level>("PT_BAS_Distribution_List_Level", transaction,
                SqlRParameter.GetParameter("@OrderInnerState", SqlDbType.Int, OrderInnerState),
                SqlRParameter.GetParameter("@DistributionPropGuid", SqlDbType.UniqueIdentifier, DistributionPropGuid),
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, merchantGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }

        /// <summary>
        /// 获取所有分销订单列表
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_Distribution_List_Level> GetDistribution_List(Guid DistributionPropGuid, Guid merchantGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Distribution_List_Level>("PT_BAS_Distribution_List_Level_All", transaction,
                SqlRParameter.GetParameter("@DistributionPropGuid", SqlDbType.UniqueIdentifier, DistributionPropGuid),
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, merchantGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid));
        }
        /// <summary>
        /// 获取所有分销订单列表(佣金)
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_Distribute_List_Level> GetDistribute_List(Guid distributionPropGuid, Guid merchantGuid,int level)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Distribute_List_Level>("PT_BAS_Distribute_List_Level", transaction,
                SqlRParameter.GetParameter("@DistributionPropGuid", SqlDbType.UniqueIdentifier, distributionPropGuid),
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, merchantGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.SMerchantGuid),
                SqlRParameter.GetParameter("@level", SqlDbType.Int, level));
        }

        /// <summary>
        /// 获取商家支付方式列表
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_MerchantByPayWay> GetMerchantByPayWayList()
        {
            return SqlHelper.RunProcedureList<PT_BAS_MerchantByPayWay>("PT_BAS_MerchantByPayWay", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }
        /// <summary>
        /// 获取商家支付方式
        /// </summary>
        /// <returns></returns>
        public PT_BAS_PayWayByOrderNo GetPayWayByOrderNO(string orderNO)
        {
            return SqlHelper.RunProcedure<PT_BAS_PayWayByOrderNo>("PT_BAS_PayWayByOrderNo", transaction,
                SqlRParameter.GetParameter("@orderNO", SqlDbType.NVarChar, orderNO));
        }
        /// <summary>
        /// 获取订单
        /// </summary>
        /// <returns></returns>
        public T_BAS_Orders GetOrderNO(string orderNO)
        {
            return SqlHelper.RunProcedure<T_BAS_Orders>("SelectOrderByOrderNo", transaction,
                SqlRParameter.GetParameter("@orderNO", SqlDbType.NVarChar, orderNO));
        }
        /// <summary>
        /// 获取订单明细
        /// </summary>
        /// <returns></returns>
        public List<T_BAS_OrderDetails> GetOrderDetails(Guid OrderGuid)
        {
            return SqlHelper.RunProcedureList<T_BAS_OrderDetails>("SelectOrderDetailByOrderNo", transaction,
                SqlRParameter.GetParameter("@OrderGuid", SqlDbType.UniqueIdentifier, OrderGuid));
        }

        /// <summary>
        /// 更新订单
        /// </summary>
        /// <returns></returns>
        public bool UpdateOrder(string orderNO, int OrderState, int OrderInnerState, DateTime PayTime, string PayWay, string transaction_id)
        {
            SqlParameter[] pas = new SqlParameter[]
            {
                 new SqlParameter("@OrderState",OrderState){  },
                 new SqlParameter("@OrderInnerState",OrderInnerState){  },
                 new SqlParameter("@PayTime",PayTime){  },
                 new SqlParameter("@PayWay",PayWay){  },
                 new SqlParameter("@orderNO",orderNO){  },
                 new SqlParameter("@transaction_id",transaction_id){  },
            };
            return SqlHelper.ExecuteNonQuery("UpdateOrder", CommandType.StoredProcedure, pas, transaction) > 0;
        }
        /// <summary>
        /// 获取商品
        /// </summary>
        /// <returns></returns>
        public T_BAS_Products GetProduct(Guid ProductGuid)
        {
            return SqlHelper.RunProcedure<T_BAS_Products>("SelectProduct", transaction,
                SqlRParameter.GetParameter("@ProductGuid", SqlDbType.UniqueIdentifier, ProductGuid));
        }
        /// <summary>
        /// 更新商品
        /// </summary>
        /// <returns></returns>
        public bool UpdateProduct(decimal Inventory, decimal BaseSalesVolume, Guid ProductGuid)
        {
            SqlParameter[] pas = new SqlParameter[]
            {
                 new SqlParameter("@Inventory",Inventory){  },
                 new SqlParameter("@BaseSalesVolume",BaseSalesVolume){  },
                 new SqlParameter("@ProductGuid",ProductGuid){  },
            };
            return SqlHelper.ExecuteNonQuery("UpdateProduct", CommandType.StoredProcedure, pas, transaction) > 0;
        }

        /// <summary>
        /// 获取我的团队数量
        /// </summary>
        /// <returns></returns>
        public int GetDistributionPropCount(Guid DistributionPropGuid)
        {
            SqlParameter[] pas = new SqlParameter[]
            {
                 new SqlParameter("@DistributionPropGuid",DistributionPropGuid){  }
            };
            return SqlHelper.ExecuteScalar<int>("SelectDistributionPropCount", CommandType.StoredProcedure, pas, transaction);
        }

        /// <summary>
        /// 获取分销佣金（已结算、未结算）
        /// </summary>
        /// <returns></returns>
        public decimal GetTotalAmount(Guid DistributionPropGuid, bool isSettlement)
        {
            SqlParameter[] parm = new SqlParameter[]
            {
                 new SqlParameter("@DistributionPropGuid",DistributionPropGuid){  },
                 new SqlParameter("@IsSettlement",isSettlement){  },
                 new SqlParameter("@SMerchantGuid",RFrameGenerate.Common.CurrentManage.SMerchantGuid){  }
            };
            return SqlHelper.ExecuteScalar<decimal>("PT_BAS_Distribute_GetTotalAmount", CommandType.StoredProcedure, parm, transaction);
        }

        /// <summary>
        /// 获取规格列表(根据商品类型Guid)
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_ProductSKUName_GetViewByType> GetViewByType(Guid? ProductTypeGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKUName_GetViewByType>("PT_BAS_ProductSKUName_GetViewByType", transaction,
                SqlRParameter.GetParameter("@ProductTypeGuid", SqlDbType.UniqueIdentifier, ProductTypeGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }
        /// <summary>
        /// 获取商品规格
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_ProductSKU_GetProductSKUList> GetProductSKUList(Guid ProductGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKU_GetProductSKUList>("PT_BAS_ProductSKU_GetProductSKUList", transaction,
                SqlRParameter.GetParameter("@ProductGuid", SqlDbType.UniqueIdentifier, ProductGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }

        /// <summary>
        /// 获取商品规格名称
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_ProductSKU_GetProductSKUNameList> GetProductSKUNameList(Guid ProductGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKU_GetProductSKUNameList>("PT_BAS_ProductSKU_GetProductSKUNameList", transaction,
                SqlRParameter.GetParameter("@ProductGuid", SqlDbType.UniqueIdentifier, ProductGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }

        /// <summary>
        /// 获取商品规格值
        /// </summary>
        /// <returns></returns>
        public List<PT_BAS_ProductSKU_GetProductSKUValueList> GetProductSKUValueList(Guid productGuid, Guid productSKUNameGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKU_GetProductSKUValueList>("PT_BAS_ProductSKU_GetProductSKUValueList", transaction,
                SqlRParameter.GetParameter("@ProductGuid", SqlDbType.UniqueIdentifier, productGuid),
                SqlRParameter.GetParameter("@ProductSKUNameGuid", SqlDbType.UniqueIdentifier, productSKUNameGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }
        public decimal GetProductSKUInvenotory(Guid productsGuid)
        {
            SqlParameter[] parm = new SqlParameter[]
            {
                 new SqlParameter("@ProductGuid",productsGuid){  },
                 new SqlParameter("@SMerchantGuid",RFrameGenerate.Common.CurrentManage.MerchantGuid){  }
            };
            return SqlHelper.ExecuteScalar<decimal>("GetProductSKUInvenotory", CommandType.StoredProcedure, parm, transaction);
        }



        /// <summary>
        /// 获取商品规格组合
        /// </summary>
        /// <returns></returns>
        public List<GetProductSKUGroup> GetProductSKUGroup(Guid productGuid)
        {
            return SqlHelper.RunProcedureList<GetProductSKUGroup>("GetProductSKUGroup", transaction,
                SqlRParameter.GetParameter("@ProductGuid", SqlDbType.UniqueIdentifier, productGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }

        /// <summary>
        /// 获取商品分类
        /// </summary>
        /// <returns></returns>
        public List<GetProductCategory> GetProductCategory()
        {
            return SqlHelper.RunProcedureList<GetProductCategory>("GetProductCategory", transaction,
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }


        /// <summary>
        /// 获取我的团队成员
        /// </summary>
        /// <returns></returns>
        public List<SelectTeam> GetMyTeamList(Guid currentDistributionGuid)
        {
            return SqlHelper.RunProcedureList<SelectTeam>("SelectTeam", transaction,
                SqlRParameter.GetParameter("@ParentMemberGuid", SqlDbType.UniqueIdentifier, currentDistributionGuid));
        }

        public List<PT_BAS_OrderDetails_Refund> GetRefundOrder(Guid refundApplyGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_OrderDetails_Refund>("PT_BAS_OrderDetails_Refund", transaction,
                SqlRParameter.GetParameter("@RefundApplyGuid", SqlDbType.UniqueIdentifier, refundApplyGuid),
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }


        public List<SelectKeywordMaterials> GetSelectKeywordMaterials()
        {
            return SqlHelper.RunProcedureList<SelectKeywordMaterials>("SelectKeywordMaterials", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }
        public List<SelectKeywordMaterials> GetSelectKeywordMaterials(string keyword)
        {
            return SqlHelper.RunProcedureList<SelectKeywordMaterials>("SelectKeywordMaterialKeyword", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid),
                SqlRParameter.GetParameter("@Keyword", SqlDbType.NVarChar, keyword));
        }



        public T_BAS_ProductCategorys GetProductCategorys(int top)
        {

            return SqlHelper.RunProcedure<T_BAS_ProductCategorys>("PT_BAS_ProductCategorys", transaction,
                SqlRParameter.GetParameter("@top", SqlDbType.Int, top),
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid));
        }

        public decimal GetPrice(Guid groupGuid)
        {
            SqlParameter[] parm = new SqlParameter[]
            {
                 new SqlParameter("@GroupGuid",groupGuid){  },
                 new SqlParameter("@SMerchantGuid",RFrameGenerate.Common.CurrentManage.SMerchantGuid){  }
            };
            return SqlHelper.ExecuteScalar<decimal>("GetProductSKUPrice", CommandType.StoredProcedure, parm, transaction);
        }

        public List<PT_BAS_ProductSKU_GetSKUGroup> PT_BAS_ProductSKU_GetSKUGroup(Guid groupGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKU_GetSKUGroup>("PT_BAS_ProductSKU_GetSKUGroup", transaction,
                SqlRParameter.GetParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier, RFrameGenerate.Common.CurrentManage.MerchantGuid),
                SqlRParameter.GetParameter("@GroupGuid", SqlDbType.UniqueIdentifier, groupGuid));
        }

        public List<PT_BAS_ProductSKU_GetSKUGroup> PT_BAS_ProductSKU_GetSKUGroup_Helper(Guid groupGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_ProductSKU_GetSKUGroup>("PT_BAS_ProductSKU_GetSKUGroup_Helper", transaction,
                SqlRParameter.GetParameter("@GroupGuid", SqlDbType.UniqueIdentifier, groupGuid));
        }


        public MemberInfo GetMemberInfo(string openid)
        {
            return SqlHelper.RunProcedure<MemberInfo>("GetMemberInfo", transaction,
                SqlRParameter.GetParameter("@openid", SqlDbType.NVarChar, openid));
        }
        public RFrameGenerate.Common.CurrnetMemberInfo GetMemberRelation(string openid, string userID)
        {
            return SqlHelper.RunProcedure<RFrameGenerate.Common.CurrnetMemberInfo>("GetMemberRelation", transaction,
                SqlRParameter.GetParameter("@openid", SqlDbType.NVarChar, openid),
                SqlRParameter.GetParameter("@userID ", SqlDbType.NVarChar, userID));
        }

        public List<T_BAS_Products> GetProductByCategory(Guid topAgentMerchantGuid)
        {
            return SqlHelper.RunProcedureList<T_BAS_Products>("GetProductByCategory", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, topAgentMerchantGuid));
        }

        /// <summary>
        /// 获取指定商家对应代理规则
        /// </summary>
        /// <param name="topAgentMerchantGuid"></param>
        /// <returns></returns>
        public USP_GetAgentRuleByMerchant GetAgentRuleByMerchant(Guid guid)
        {
            return SqlHelper.RunProcedure<USP_GetAgentRuleByMerchant>("USP_GetAgentRuleByMerchant", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, guid));
        }

        /// <summary>
        /// 获取指定分组对应代理规则
        /// </summary>
        /// <param name="topAgentMerchantGuid"></param>
        /// <returns></returns>
        public USP_GetAgentRuleByGroup GetAgentRuleByGroup(Guid groupGuid)
        {
            return SqlHelper.RunProcedure<USP_GetAgentRuleByGroup>("USP_GetAgentRuleByGroup", transaction,
                SqlRParameter.GetParameter("@FlagshipGroupGuid", SqlDbType.UniqueIdentifier, groupGuid));
        }

        /// <summary>
        /// 获取代理分销商
        /// </summary>
        /// <param name="topAgentMerchantGuid"></param>
        /// <returns></returns>
        public List<USP_GetDistributionLite> GetDistributionLite(Guid guid)
        {
            return SqlHelper.RunProcedureList<USP_GetDistributionLite>("USP_GetDistributionLite", transaction,
                SqlRParameter.GetParameter("@MerchantGuid", SqlDbType.UniqueIdentifier, guid));
        }

    }
}
