﻿using RFrameGenerate.Model;
using RFrameGenerate.Model.PageModel;
using RFramework.SQLServer;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;

namespace RFrameGenerate.DAL.SQLServer
{
    public partial class IProcedure
    {
        /// <summary>
        /// 获取分销订单 2016/4/5 zhou
        /// </summary>
        /// <param name="merchantGuid"></param>
        /// <returns></returns>
        public List<T_ST_DistributeOrder> GetDistribution_Order_List(int page, int pageSize, out int pageCount, out int recordCount, Guid merchantGuid, string orderState, string disName, string orderNo)
        {
            SqlParameter[] parameters = new SqlParameter[]{
                                            new SqlParameter("@iPage", SqlDbType.Int),
											new SqlParameter("@iPageSize", SqlDbType.Int),
											new SqlParameter("@iPageCount", SqlDbType.Int),
											new SqlParameter("@iRecordCount", SqlDbType.Int),
                                            new SqlParameter("@merchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@orderState", SqlDbType.NVarChar),
                                            new SqlParameter("@orderNo", SqlDbType.NVarChar),
                                            new SqlParameter("@disName", SqlDbType.NVarChar),
            };
            parameters[0].Value = page;
            parameters[1].Value = pageSize;
            parameters[2].Direction = ParameterDirection.Output;
            parameters[3].Direction = ParameterDirection.Output;
            parameters[4].Value = merchantGuid;
            parameters[5].Value = orderState;
            parameters[6].Value = orderNo;
            parameters[7].Value = disName;

            List<T_ST_DistributeOrder> list = SqlHelper.RunProcedureList<T_ST_DistributeOrder>("PT_BAS_Distribution_Order_List", transaction, parameters); 

            pageCount = (int)parameters[2].Value;
            recordCount = (int)parameters[3].Value;

            return list;
        }

        /// <summary>
        /// 获取分销订单 2016/4/6 zhou
        /// </summary>
        /// <param name="distributeGuid"></param>
        /// <returns></returns>
        public PT_BAS_Distribution_Order_List GetDistribution_Order(Guid distributeGuid)
        {
            return SqlHelper.RunProcedure<PT_BAS_Distribution_Order_List>("PT_BAS_Distribution_Order", transaction,
                SqlRParameter.GetParameter("@distributeGuid", SqlDbType.UniqueIdentifier, distributeGuid));
        }
        /// <summary>
        /// 获取分销订单 2016/4/6 zhou
        /// </summary>
        /// <param name="distributeGuid"></param>
        /// <returns></returns>
        public List<PT_BAS_Get_Distribution_Order> Get_Distribution_Order(Guid merchantGuid)
        {
            return SqlHelper.RunProcedureList<PT_BAS_Get_Distribution_Order>("PT_BAS_Get_Distribution_Order", transaction,
                SqlRParameter.GetParameter("@merchantGuid", SqlDbType.UniqueIdentifier, merchantGuid));
        }
    }
}
