﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Transactions;
using RFrameGenerate.Model; 
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.Common;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using RFramework.SQLServer.Enums;

namespace RFrameGenerate.DAL.SQLServer
{
    internal class T_BAS_OrderDetailsDAL : IQuery<T_BAS_OrderDetails>
    {
        /// <summary>
        /// 事务处理
        /// </summary>
        public SqlRTransaction sqlRTransaction { get; set; }
        
        #region IsExist
        
        /// <summary>
        /// 判断记录是否存在，根据记录的GUID值
        /// </summary>
        /// <param name="dataGuid">待判断的记录的GUID值</param>
        /// <returns>返回判断结果，存在为True，不存在为False</returns>
        public bool IsExist(Guid dataGuid, bool isFilterMerchant = true)
        {
            return IsExist("OrderDetailGuid", dataGuid,isFilterMerchant);
        } 
        
		/// <summary>
        /// 判断记录是否存在，根据字段名称和字段值
        /// </summary>
        /// <param name="field">字段名称</param>
        /// <param name="value">字段值</param>
        /// <returns>返回判断结果，存在为True，不存在为False</returns>
        public bool IsExist<T>(string field, T value, bool isFilterMerchant = true)
        {
            SqlParameter[] parameters = { 
                                            new SqlParameter("@iCount", SqlDbType.Int),
                                            new SqlParameter("@strField", SqlDbType.NVarChar),
                                            new SqlParameter("@strValue", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Direction = ParameterDirection.Output;
            parameters[1].Value = field;
            parameters[2].Value = value.ToString();
            parameters[3].Value = CurrentManage.SMerchantGuid;
            parameters[4].Value = isFilterMerchant;
            try
            {
                SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_IsExistGuid", CommandType.StoredProcedure, parameters, sqlRTransaction);
                return parameters[0].Value.ToString() != "0" ? true : false;
            }
            catch (Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("IsExist()参数:strField={0},strValue={1}获取数据出错,异常:{2}", field, value, ex.Message), ex);
            }
        }
         /// <summary>
        /// 判断是否存在
        /// </summary>
        /// <param name="conditionExpression">条件</param>
        /// <returns></returns>
        public bool IsExist(Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            return IsExist(conditionString,isFilterMerchant);
        }
        /// <summary>
        /// 判断是否存在
        /// </summary>
        /// <param name="conditionString">条件</param>
        /// <returns></returns>
        public bool IsExist(string conditionString, bool isFilterMerchant = true)
        {
            SqlParameter[] parameters = { 
                                            new SqlParameter("@iCount", SqlDbType.Int),
                                            new SqlParameter("@strCondition", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Direction = ParameterDirection.Output;
            parameters[1].Value = conditionString;
            parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;
            try
            {
                SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_IsExist", CommandType.StoredProcedure, parameters, sqlRTransaction);
                return parameters[0].Value.ToString() != "0" ? true : false;
            }
            catch (Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("IsExist()参数:strCondition={0}获取数据出错,异常:{1}", conditionString, ex.Message), ex);
            }
        }   
        #endregion
		
        #region GetDataByGuid
         
        /// <summary>
        /// 获取一条记录，根据记录的GUID值
        /// </summary>
        /// <param name="dataGuid">待获取的记录的GUID值</param>
        /// <returns>返回指定记录，记录不存在则返回Null</returns>
        public T_BAS_OrderDetails GetDataByGuid(Guid dataGuid, bool isFilterMerchant = true)
        {
            SqlParameter[] parameters = {
											new SqlParameter("@OrderDetailGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit)
										};
            parameters[0].Value = dataGuid;
            parameters[1].Value = CurrentManage.SMerchantGuid;
            parameters[2].Value = isFilterMerchant;
            
            SqlDataReader dataReader = SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetDataByGuid", CommandType.StoredProcedure, parameters, sqlRTransaction);

            T_BAS_OrderDetails data = null;
            try
            {
                if (dataReader.Read())
                    data = LoadModel(dataReader);
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetDataByGuid()参数:dataGuid={0}获取数据出错,异常:{1}", dataGuid, ex.Message), ex);
            }        
                
            dataReader.Close();
             
            return data;
        }
        #endregion
        
        #region Add
        /// <summary>
        /// 批量更新记录集，根据dataList中各个记录的状态
        /// 记录的状态为ToBeAdd的，新增这条记录到数据库
        /// 记录的状态为ToBeDelete的，删除这条记录到数据库
        /// 记录的状态为ToBeUpdate的，更新这条记录到数据库
        /// 记录的状态为Original的，不对这条记录进行任何操作
        /// </summary>
        /// <param name="dataList">待更新的记录集</param>
        /// <returns>返回更新结果，成功为True，失败为False</returns>        
        public void AddList(List<T_BAS_OrderDetails> dataList)
        {
            bool istran = false;
            if (sqlRTransaction.IsTransaction == false)
            {
                istran = true;
                sqlRTransaction.BeginTransaction();
            }

            DataTable dataListAdd = SqlHelper.GetTables("T_BAS_OrderDetails",sqlRTransaction);

            
            foreach (var data in dataList)
            {
                DataRow dr = dataListAdd.NewRow();
                if(data.OrderDetailGuid != null)
    			    dr["OrderDetailGuid"] = data.OrderDetailGuid;
                else
                    dr["OrderDetailGuid"] = DBNull.Value;
                    
                if(data.ProductGuid != null)
    			    dr["ProductGuid"] = data.ProductGuid;
                else
                    dr["ProductGuid"] = DBNull.Value;
                    
                if(data.GroupGuid != null)
    			    dr["GroupGuid"] = data.GroupGuid;
                else
                    dr["GroupGuid"] = DBNull.Value;
                    
                if(data.OrderGuid != null)
    			    dr["OrderGuid"] = data.OrderGuid;
                else
                    dr["OrderGuid"] = DBNull.Value;
                    
                if(data.DistributeGuid != null)
    			    dr["DistributeGuid"] = data.DistributeGuid;
                else
                    dr["DistributeGuid"] = DBNull.Value;
                    
                if(data.ProductCategoryGuid != null)
    			    dr["ProductCategoryGuid"] = data.ProductCategoryGuid;
                else
                    dr["ProductCategoryGuid"] = DBNull.Value;
                    
                if(data.ProductName != null)
    			    dr["ProductName"] = data.ProductName;
                else
                    dr["ProductName"] = DBNull.Value;
                    
                if(data.ProductProp != null)
    			    dr["ProductProp"] = data.ProductProp;
                else
                    dr["ProductProp"] = DBNull.Value;
                    
                if(data.SaleProp != null)
    			    dr["SaleProp"] = data.SaleProp;
                else
                    dr["SaleProp"] = DBNull.Value;
                    
                if(data.ProductCode != null)
    			    dr["ProductCode"] = data.ProductCode;
                else
                    dr["ProductCode"] = DBNull.Value;
                    
                if(data.Picture != null)
    			    dr["Picture"] = data.Picture;
                else
                    dr["Picture"] = DBNull.Value;
                    
                if(data.Price != null)
    			    dr["Price"] = data.Price;
                else
                    dr["Price"] = DBNull.Value;
                    
                if(data.DiscountPrice != null)
    			    dr["DiscountPrice"] = data.DiscountPrice;
                else
                    dr["DiscountPrice"] = DBNull.Value;
                    
                if(data.Discount != null)
    			    dr["Discount"] = data.Discount;
                else
                    dr["Discount"] = DBNull.Value;
                    
                if(data.Quantity != null)
    			    dr["Quantity"] = data.Quantity;
                else
                    dr["Quantity"] = DBNull.Value;
                    
                if(data.Amount != null)
    			    dr["Amount"] = data.Amount;
                else
                    dr["Amount"] = DBNull.Value;
                    
                if(data.TotalAmount != null)
    			    dr["TotalAmount"] = data.TotalAmount;
                else
                    dr["TotalAmount"] = DBNull.Value;
                    
                if(data.FirstCommission != null)
    			    dr["FirstCommission"] = data.FirstCommission;
                else
                    dr["FirstCommission"] = DBNull.Value;
                    
                if(data.SecondCommission != null)
    			    dr["SecondCommission"] = data.SecondCommission;
                else
                    dr["SecondCommission"] = DBNull.Value;
                    
                if(data.ThirdCommission != null)
    			    dr["ThirdCommission"] = data.ThirdCommission;
                else
                    dr["ThirdCommission"] = DBNull.Value;
                    
                if(data.FirstCommissionSet != null)
    			    dr["FirstCommissionSet"] = data.FirstCommissionSet;
                else
                    dr["FirstCommissionSet"] = DBNull.Value;
                    
                if(data.SecondCommissionSet != null)
    			    dr["SecondCommissionSet"] = data.SecondCommissionSet;
                else
                    dr["SecondCommissionSet"] = DBNull.Value;
                    
                if(data.ThirdCommissionSet != null)
    			    dr["ThirdCommissionSet"] = data.ThirdCommissionSet;
                else
                    dr["ThirdCommissionSet"] = DBNull.Value;
                    
                if(data.TotalCommission != null)
    			    dr["TotalCommission"] = data.TotalCommission;
                else
                    dr["TotalCommission"] = DBNull.Value;
                    
                if(data.State != null)
    			    dr["State"] = data.State;
                else
                    dr["State"] = DBNull.Value;
                    
                if(data.SKU != null)
    			    dr["SKU"] = data.SKU;
                else
                    dr["SKU"] = DBNull.Value;
                    
                if(data.WXPayMoney != null)
    			    dr["WXPayMoney"] = data.WXPayMoney;
                else
                    dr["WXPayMoney"] = DBNull.Value;
                    
                if(data.IntegralTe != null)
    			    dr["IntegralTe"] = data.IntegralTe;
                else
                    dr["IntegralTe"] = DBNull.Value;
                    
                if(data.PresentExp != null)
    			    dr["PresentExp"] = data.PresentExp;
                else
                    dr["PresentExp"] = DBNull.Value;
                    
                if(data.IntegralMoney != null)
    			    dr["IntegralMoney"] = data.IntegralMoney;
                else
                    dr["IntegralMoney"] = DBNull.Value;
                    
                if(data.AgentDiscount != null)
    			    dr["AgentDiscount"] = data.AgentDiscount;
                else
                    dr["AgentDiscount"] = DBNull.Value;
                    
                if(data.AgentPrice != null)
    			    dr["AgentPrice"] = data.AgentPrice;
                else
                    dr["AgentPrice"] = DBNull.Value;
                    
                dr["SCreateDate"] = DateTime.Now;
                dr["SCreateUserName"] = CurrentManage.UserName;
                if (data.SMerchantGuid != null && data.SMerchantGuid != Guid.Empty)
                    dr["SMerchantGuid"] = data.SMerchantGuid;
                else
                    dr["SMerchantGuid"] = CurrentManage.SMerchantGuid;
                dataListAdd.Rows.Add(dr);
            }
            
            #region 更新到数据库
            if (dataListAdd.Rows.Count>0)
            { 
            //添加
            SqlHelper.BatchAddData(new DataTable[] { dataListAdd }, sqlRTransaction);
            }
            #endregion

            if (istran == true)
                sqlRTransaction.Commit();

            dataListAdd.Clear();
        }
        /// <summary>
        /// 新增一条记录
        /// </summary>
        /// <param name="data">待新增的记录</param>
        /// <returns>返回新增结果，成功为True，失败为False</returns>
        public void Add(T_BAS_OrderDetails data)
        {
            SqlParameter[] parameters = {
                                            new SqlParameter("@SCreateDate", SqlDbType.DateTime),
                                            new SqlParameter("@SCreateUserName", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@OrderDetailGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@GroupGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@OrderGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@DistributeGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductCategoryGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductName", SqlDbType.NVarChar),
											new SqlParameter("@ProductProp", SqlDbType.NVarChar),
											new SqlParameter("@SaleProp", SqlDbType.NVarChar),
											new SqlParameter("@ProductCode", SqlDbType.NVarChar),
											new SqlParameter("@Picture", SqlDbType.NVarChar),
											new SqlParameter("@Price", SqlDbType.Decimal),
											new SqlParameter("@DiscountPrice", SqlDbType.Decimal),
											new SqlParameter("@Discount", SqlDbType.Decimal),
											new SqlParameter("@Quantity", SqlDbType.Decimal),
											new SqlParameter("@Amount", SqlDbType.Decimal),
											new SqlParameter("@TotalAmount", SqlDbType.Decimal),
											new SqlParameter("@FirstCommission", SqlDbType.Decimal),
											new SqlParameter("@SecondCommission", SqlDbType.Decimal),
											new SqlParameter("@ThirdCommission", SqlDbType.Decimal),
											new SqlParameter("@FirstCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@SecondCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@ThirdCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@TotalCommission", SqlDbType.Decimal),
											new SqlParameter("@State", SqlDbType.Int),
											new SqlParameter("@SKU", SqlDbType.NVarChar),
											new SqlParameter("@WXPayMoney", SqlDbType.Decimal),
											new SqlParameter("@IntegralTe", SqlDbType.Int),
											new SqlParameter("@PresentExp", SqlDbType.Int),
											new SqlParameter("@IntegralMoney", SqlDbType.Decimal),
											new SqlParameter("@AgentDiscount", SqlDbType.Decimal),
											new SqlParameter("@AgentPrice", SqlDbType.Decimal),
										};
            
            parameters[0].Direction = ParameterDirection.Output;
            parameters[1].Value = CurrentManage.UserName;
            if (data.SMerchantGuid != null && data.SMerchantGuid != Guid.Empty)
                parameters[2].Value = data.SMerchantGuid;
            else
                parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = data.OrderDetailGuid;
            parameters[4].Value = data.ProductGuid;
            parameters[5].Value = data.GroupGuid;
            parameters[6].Value = data.OrderGuid;
            parameters[7].Value = data.DistributeGuid;
            parameters[8].Value = data.ProductCategoryGuid;
            parameters[9].Value = data.ProductName;
            parameters[10].Value = data.ProductProp;
            parameters[11].Value = data.SaleProp;
            parameters[12].Value = data.ProductCode;
            parameters[13].Value = data.Picture;
            parameters[14].Value = data.Price;
            parameters[15].Value = data.DiscountPrice;
            parameters[16].Value = data.Discount;
            parameters[17].Value = data.Quantity;
            parameters[18].Value = data.Amount;
            parameters[19].Value = data.TotalAmount;
            parameters[20].Value = data.FirstCommission;
            parameters[21].Value = data.SecondCommission;
            parameters[22].Value = data.ThirdCommission;
            parameters[23].Value = data.FirstCommissionSet;
            parameters[24].Value = data.SecondCommissionSet;
            parameters[25].Value = data.ThirdCommissionSet;
            parameters[26].Value = data.TotalCommission;
            parameters[27].Value = data.State;
            parameters[28].Value = data.SKU;
            parameters[29].Value = data.WXPayMoney;
            parameters[30].Value = data.IntegralTe;
            parameters[31].Value = data.PresentExp;
            parameters[32].Value = data.IntegralMoney;
            parameters[33].Value = data.AgentDiscount;
            parameters[34].Value = data.AgentPrice;
			try
            {
                int rowsAffected = SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_Add", CommandType.StoredProcedure, parameters, sqlRTransaction);
                bool result = rowsAffected != -1 ? true : false;
                if(result == false)
                    throw new Exception("新增数据失败");
            }
            catch(Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("Add()参数:data={0}添加数据出错,异常:{1}", data.ToString(), ex.Message), ex);
            }
        }
        #endregion
        
        #region Top
        /// <summary>
        /// 获取前Top，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_OrderDetails>  GetTopData(string top, Expression<Func<T_BAS_OrderDetails , bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_OrderDetails , object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();

            return GetTopData(top,conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }

        /// <summary>
        /// 获取Top，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="top"></param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的第一条记录，记录不存在则返回Null</returns>
        public List<T_BAS_OrderDetails> GetTopData(string top,string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            if (string.IsNullOrEmpty(top) == true)
            {
                throw new Exception("top不能为空,例:top=6或top=10%");
            }
            if (top.Contains("%"))
            {
                top = string.Format(" top {0} percent ", top.Replace("%",string.Empty));
            }
            else
            {
                top = string.Format(" top {0} ", top);
            }

            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
								            new SqlParameter("@top", SqlDbType.NVarChar), 
								            new SqlParameter("@strCondition", SqlDbType.NVarChar), 
								            new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Value = top.Trim();
            parameters[1].Value = conditionString.Trim();
            parameters[2].Value = orderString.Trim();
            parameters[3].Value = flag.ToSqlLock();
            parameters[4].Value = CurrentManage.SMerchantGuid;
            if (orderString.Trim() != string.Empty)
                parameters[2].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[5].Value = isFilterMerchant;

             List<T_BAS_OrderDetails> dataList = new List<T_BAS_OrderDetails>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetTopData",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetTopData获取数据出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
    						
            return dataList;             
        }

        #endregion
		
        #region GetFirstData
        
		/// <summary>
        /// 获取第一条记录，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public T_BAS_OrderDetails GetFirstData(Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_OrderDetails, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            
            return GetFirstData(conditionString, orderString, orderMethod, flag,isFilterMerchant);        
        }

        /// <summary>
        /// 获取第一条记录，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的第一条记录，记录不存在则返回Null</returns>
        public T_BAS_OrderDetails GetFirstData(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
								            new SqlParameter("@strCondition", SqlDbType.NVarChar), 
								            new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Value = conditionString.Trim();
            parameters[1].Value = orderString.Trim();
            parameters[2].Value = flag.ToSqlLock();
            parameters[3].Value = CurrentManage.SMerchantGuid;
            if (orderString.Trim() != string.Empty)
                parameters[1].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[4].Value = isFilterMerchant;
                
            SqlDataReader dataReader = SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetFirstData", CommandType.StoredProcedure, parameters, sqlRTransaction);

            T_BAS_OrderDetails data = null;
            try
            {
                if (dataReader.Read())
                    data = LoadModel(dataReader);
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetFirstData()参数:conditionString={0}获取数据出错,异常:{1}", conditionString, ex.Message), ex);
            }         
            dataReader.Close();
            
            return data;
        }
        #endregion

        #region Update
        /// 更新一条记录
        /// </summary>
        /// <param name="valueExpression">待更新的记录</param>
        /// <param name="conditionExpression">要更新的条件</param>
        /// <returns>返回更新结果，成功为True，失败为False</returns>        
        public void Update(Expression<Func<T_BAS_OrderDetails, object[]>> valueExpression, Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterMerchant = true)
        {            
            QueryTranslator query = new QueryTranslator();
            string value = query.Translate(valueExpression).Replace(")(", ",").Substring(1);
            value = value.Substring(0, value.Length - 1);
            string condition = query.Translate(conditionExpression);
            if (condition == string.Empty)
                throw new Exception("删除条件不能为null或空");


            SqlParameter[] parameters = {
                                            new SqlParameter("@value", SqlDbType.NVarChar),
                                            new SqlParameter("@strCondition", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};

            parameters[0].Value = value;
            parameters[1].Value = condition;
			parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;
            try
            {
                int rowsAffected = SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_SingleUpdate", CommandType.StoredProcedure, parameters, sqlRTransaction);
                bool result = rowsAffected != -1 ? true : false;

                if (result == false)
                    throw new Exception("更新数据失败");
            }
            catch (Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("Update()参数:conditionString={0}更新数据失败,异常:{1}", condition, ex.Message), ex);
            }
        }
        /// <summary>
        /// 更新一条记录
        /// </summary>
        /// <param name="data">待更新的记录</param>
        /// <returns>返回更新结果，成功为True，失败为False</returns>
        public void Update(T_BAS_OrderDetails data, bool isFilterMerchant = true)
        {
            SqlParameter[] parameters = {
                                            new SqlParameter("@SUpdateDate", SqlDbType.DateTime),
                                            new SqlParameter("@SUpdateUserName", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
											new SqlParameter("@OrderDetailGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@GroupGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@OrderGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@DistributeGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductCategoryGuid", SqlDbType.UniqueIdentifier),
											new SqlParameter("@ProductName", SqlDbType.NVarChar),
											new SqlParameter("@ProductProp", SqlDbType.NVarChar),
											new SqlParameter("@SaleProp", SqlDbType.NVarChar),
											new SqlParameter("@ProductCode", SqlDbType.NVarChar),
											new SqlParameter("@Picture", SqlDbType.NVarChar),
											new SqlParameter("@Price", SqlDbType.Decimal),
											new SqlParameter("@DiscountPrice", SqlDbType.Decimal),
											new SqlParameter("@Discount", SqlDbType.Decimal),
											new SqlParameter("@Quantity", SqlDbType.Decimal),
											new SqlParameter("@Amount", SqlDbType.Decimal),
											new SqlParameter("@TotalAmount", SqlDbType.Decimal),
											new SqlParameter("@FirstCommission", SqlDbType.Decimal),
											new SqlParameter("@SecondCommission", SqlDbType.Decimal),
											new SqlParameter("@ThirdCommission", SqlDbType.Decimal),
											new SqlParameter("@FirstCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@SecondCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@ThirdCommissionSet", SqlDbType.Decimal),
											new SqlParameter("@TotalCommission", SqlDbType.Decimal),
											new SqlParameter("@State", SqlDbType.Int),
											new SqlParameter("@SKU", SqlDbType.NVarChar),
											new SqlParameter("@WXPayMoney", SqlDbType.Decimal),
											new SqlParameter("@IntegralTe", SqlDbType.Int),
											new SqlParameter("@PresentExp", SqlDbType.Int),
											new SqlParameter("@IntegralMoney", SqlDbType.Decimal),
											new SqlParameter("@AgentDiscount", SqlDbType.Decimal),
											new SqlParameter("@AgentPrice", SqlDbType.Decimal),
										};										
			
            parameters[0].Direction = ParameterDirection.Output;
            parameters[1].Value = CurrentManage.UserName;
            parameters[2].Value = data.SMerchantGuid==null ? CurrentManage.SMerchantGuid : data.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;
			parameters[4].Value = data.OrderDetailGuid;
			parameters[5].Value = data.ProductGuid;
			parameters[6].Value = data.GroupGuid;
			parameters[7].Value = data.OrderGuid;
			parameters[8].Value = data.DistributeGuid;
			parameters[9].Value = data.ProductCategoryGuid;
			parameters[10].Value = data.ProductName;
			parameters[11].Value = data.ProductProp;
			parameters[12].Value = data.SaleProp;
			parameters[13].Value = data.ProductCode;
			parameters[14].Value = data.Picture;
			parameters[15].Value = data.Price;
			parameters[16].Value = data.DiscountPrice;
			parameters[17].Value = data.Discount;
			parameters[18].Value = data.Quantity;
			parameters[19].Value = data.Amount;
			parameters[20].Value = data.TotalAmount;
			parameters[21].Value = data.FirstCommission;
			parameters[22].Value = data.SecondCommission;
			parameters[23].Value = data.ThirdCommission;
			parameters[24].Value = data.FirstCommissionSet;
			parameters[25].Value = data.SecondCommissionSet;
			parameters[26].Value = data.ThirdCommissionSet;
			parameters[27].Value = data.TotalCommission;
			parameters[28].Value = data.State;
			parameters[29].Value = data.SKU;
			parameters[30].Value = data.WXPayMoney;
			parameters[31].Value = data.IntegralTe;
			parameters[32].Value = data.PresentExp;
			parameters[33].Value = data.IntegralMoney;
			parameters[34].Value = data.AgentDiscount;
			parameters[35].Value = data.AgentPrice;
			try
            {
                int rowsAffected = SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_Update", CommandType.StoredProcedure, parameters, sqlRTransaction);
                bool result = rowsAffected != -1 ? true : false;
                
                if (result == false)
                    throw new Exception("更新数据失败");
            }
            catch (Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("Update()参数:conditionString={0}更新数据失败,异常:{1}", data.ToString(), ex.Message), ex);
            }
        }
        
        /// <summary>
        /// 批量更新记录集，根据dataList中各个记录的状态
        /// 记录的状态为ToBeAdd的，新增这条记录到数据库
        /// 记录的状态为ToBeDelete的，删除这条记录到数据库
        /// 记录的状态为ToBeUpdate的，更新这条记录到数据库
        /// 记录的状态为Original的，不对这条记录进行任何操作
        /// </summary>
        /// <param name="dataList">待更新的记录集</param>
        /// <returns>返回更新结果，成功为True，失败为False</returns>        
        public void UpdateList(List<T_BAS_OrderDetails> dataList)
        {
            bool istran = false;
            if (sqlRTransaction.IsTransaction == false)
            {
                istran = true;
                sqlRTransaction.BeginTransaction();
            }

            DataTable dataListAdd = SqlHelper.GetTables("T_BAS_OrderDetails",sqlRTransaction);

            List<T_BAS_OrderDetails> dataListUpdate = new List<T_BAS_OrderDetails>();
            List<string> dataListDelete = new List<string>();            
            StringBuilder sbDelete = new StringBuilder();
            sbDelete.Append(" OrderDetailGuid in (");
            int deleteCount = 0;
            string strSql = string.Empty;
            foreach (var data in dataList)
            {
                switch (data.EntityState)
                {
                    case EntityStates.ToBeAdd:
                        DataRow dr = dataListAdd.NewRow();
            			dr["OrderDetailGuid"] = data.OrderDetailGuid;
            			dr["ProductGuid"] = data.ProductGuid;
            			dr["GroupGuid"] = data.GroupGuid;
            			dr["OrderGuid"] = data.OrderGuid;
            			dr["DistributeGuid"] = data.DistributeGuid;
            			dr["ProductCategoryGuid"] = data.ProductCategoryGuid;
            			dr["ProductName"] = data.ProductName;
            			dr["ProductProp"] = data.ProductProp;
            			dr["SaleProp"] = data.SaleProp;
            			dr["ProductCode"] = data.ProductCode;
            			dr["Picture"] = data.Picture;
            			dr["Price"] = data.Price;
            			dr["DiscountPrice"] = data.DiscountPrice;
            			dr["Discount"] = data.Discount;
            			dr["Quantity"] = data.Quantity;
            			dr["Amount"] = data.Amount;
            			dr["TotalAmount"] = data.TotalAmount;
            			dr["FirstCommission"] = data.FirstCommission;
            			dr["SecondCommission"] = data.SecondCommission;
            			dr["ThirdCommission"] = data.ThirdCommission;
            			dr["FirstCommissionSet"] = data.FirstCommissionSet;
            			dr["SecondCommissionSet"] = data.SecondCommissionSet;
            			dr["ThirdCommissionSet"] = data.ThirdCommissionSet;
            			dr["TotalCommission"] = data.TotalCommission;
            			dr["State"] = data.State;
            			dr["SKU"] = data.SKU;
            			dr["WXPayMoney"] = data.WXPayMoney;
            			dr["IntegralTe"] = data.IntegralTe;
            			dr["PresentExp"] = data.PresentExp;
            			dr["IntegralMoney"] = data.IntegralMoney;
            			dr["AgentDiscount"] = data.AgentDiscount;
            			dr["AgentPrice"] = data.AgentPrice;
                        dr["SCreateDate"] = DateTime.Now;
                        dr["SCreateUserName"] = CurrentManage.UserName;
                        dr["SMerchantGuid"] = CurrentManage.SMerchantGuid;
                        dataListAdd.Rows.Add(dr);
                        break;
                    case EntityStates.ToBeDelete:
                        sbDelete.AppendFormat(" '{0}',", data.OrderDetailGuid);
                        deleteCount++;
                        if (deleteCount == 20)
                        {
                            sbDelete.Append(")");
                            deleteCount = 0;
                            strSql = sbDelete.ToString();
                            dataListDelete.Add(strSql.Replace(",)",") "));
                            sbDelete.Clear();
                            sbDelete.Append(" OrderDetailGuid in (");
                        }
                        break;
                    case EntityStates.ToBeUpdated:
                        dataListUpdate.Add(data);
                        break;
                }
            }
            if (sbDelete.Length>0 && sbDelete.ToString() != " OrderDetailGuid in (")
            {
                sbDelete.Append(")");
                strSql = sbDelete.ToString();
                dataListDelete.Add(strSql.Replace(",)",") "));
                sbDelete.Clear();
            }

            #region 更新到数据库
            if (dataListAdd.Rows.Count>0)
            { 
            //添加
            SqlHelper.BatchAddData(new DataTable[] { dataListAdd }, sqlRTransaction);
            }
            //修改
            foreach(var v in dataListUpdate)
            {
                Update(v);
            }
            //删除
            foreach(var v in dataListDelete)
            {
                Delete(v);
            }
            #endregion

            if (istran == true)
                sqlRTransaction.Commit();

            dataListAdd.Clear();
            dataListUpdate.Clear();
            dataListDelete.Clear();
            dataList.ForEach(a => a.EntityState = EntityStates.Original);
        }

        #endregion
         
        #region Delete
        /// <summary>
        /// 删除一条记录，根据记录的GUID值
        /// </summary>
        /// <param name="dataGuid">待删除的记录的GUID值</param>
        /// <returns>返回删除结果，成功为True，失败为False</returns>
        public void Delete(Guid dataGuid, bool isFilterMerchant = true)
        { 
			Delete(string.Format("OrderDetailGuid = '{0}'",dataGuid),isFilterMerchant);
        }
                
         /// <summary>
        /// 根据条件删除记录
        /// </summary>
        /// <param name="dataGuid">删除条件</param>
        /// <returns>返回删除结果，成功为True，失败为False</returns>
        public void Delete(Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterMerchant = true)
        { 
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            Delete(conditionString,isFilterMerchant);
        }
        
        /// <summary>
        /// 批量删除数据
        /// 记录的状态为ToBeAdd的，新增这条记录到数据库
        /// 记录的状态为ToBeDelete的，删除这条记录到数据库
        /// 记录的状态为ToBeUpdate的，更新这条记录到数据库
        /// 记录的状态为Original的，不对这条记录进行任何操作
        /// </summary>
        /// <param name="dataList">待更新的记录集</param>
        /// <returns>返回更新结果，成功为True，失败为False</returns>        
        public void DeleteList(List<T_BAS_OrderDetails> dataList, bool isFilterMerchant = true)
        {
            bool istran = false;
            if (sqlRTransaction.IsTransaction == false)
            {
                istran = true;
                sqlRTransaction.BeginTransaction();
            }
            List<string> dataListDelete = new List<string>();            
            StringBuilder sbDelete = new StringBuilder();
            sbDelete.Append(" OrderDetailGuid in (");
            int deleteCount = 0;
            string strSql = string.Empty;
            foreach (var data in dataList)
            {              
                sbDelete.AppendFormat(" '{0}',", data.OrderDetailGuid);
                deleteCount++;
                if (deleteCount == 20)
                {
                    sbDelete.Append(")");
                    deleteCount = 0;
                    strSql = sbDelete.ToString();
                    dataListDelete.Add(strSql.Replace(",)",") "));
                    sbDelete.Clear();
                    sbDelete.Append(" OrderDetailGuid in (");
                }
            }
            if (sbDelete.Length>0 && sbDelete.ToString() != " OrderDetailGuid in (")
            {
                sbDelete.Append(")");
                strSql = sbDelete.ToString();
                dataListDelete.Add(strSql.Replace(",)",") "));
                sbDelete.Clear();
            }

            #region 更新到数据库           
            //删除
            foreach(var v in dataListDelete)
            {
                Delete(v,isFilterMerchant);
            }
            #endregion

            if (istran == true)
                sqlRTransaction.Commit();

            dataListDelete.Clear();
        }
        
         /// <summary>
        /// 根据条件删除记录
        /// </summary>
        /// <param name="dataGuid">删除条件</param>
        /// <returns>返回删除结果，成功为True，失败为False</returns>
        public void Delete(string conditionString = "", bool isFilterMerchant = true)
        {
            if (conditionString == null || conditionString ==String.Empty)
                throw new Exception("删除条件不能为null或空");
            SqlParameter[] parameters =
            {
                new SqlParameter("@strCondition", SqlDbType.NVarChar),
                new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
            };
            parameters[0].Value = conditionString; 
            parameters[1].Value = CurrentManage.SMerchantGuid;
            parameters[2].Value = isFilterMerchant;
            try
            {
                int rowsAffected = SqlHelper.ExecuteNonQuery("PT_BAS_OrderDetails_Delete", CommandType.StoredProcedure, parameters, sqlRTransaction);
                
                if(rowsAffected == -1)
                    throw new Exception("删除数据失败");
            }
            catch (Exception ex)
            {
                Dispose();
                throw new Exception(string.Format("Delete()参数:conditionString={0}删除数据失败,异常:{1}", conditionString, ex.Message), ex);
            }
        }
        
        #endregion
        
        #region GetList
         
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_OrderDetails> GetList(Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_OrderDetails, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            
            return GetList(conditionString, orderString, orderMethod, flag,isFilterMerchant);
         }
        
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_OrderDetails> GetList(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
			SqlParameter[] parameters = {
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = conditionString.Trim();
            parameters[1].Value = orderString.Trim();
            parameters[2].Value = flag.ToSqlLock();
            parameters[3].Value = CurrentManage.SMerchantGuid;
            parameters[4].Value = isFilterMerchant;
			if (orderString.Trim() != string.Empty)
				parameters[1].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
			
            List<T_BAS_OrderDetails> dataList = new List<T_BAS_OrderDetails>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetList",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetList获取数据出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
    						
            return dataList;             
        }	
        
        #endregion
        
        #region GetCount
		
		/// <summary>
        /// 获取记录数，根据查询条件Lambda表达式
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <returns>返回满足条件的记录集</returns>
        public int GetCount(Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            return GetCount(conditionString,isFilterMerchant);
        }

        /// <summary>
        /// 获取记录数，根据查询条件
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <returns>返回满足条件的记录数</returns>
        public int GetCount(string conditionString = "", bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty; 
            SqlParameter[] parameters = {
											new SqlParameter("@strCondition", SqlDbType.NVarChar),
                                            new SqlParameter("@iRecordCount", SqlDbType.Int),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = conditionString.Trim();
            parameters[1].Direction = ParameterDirection.Output;
            parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;
            int recordCount;
            SqlDataReader dataReader =  SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetCount", CommandType.StoredProcedure, parameters, sqlRTransaction);
            try
            {
                recordCount = (int)parameters[1].Value;
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetCount获取总记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return recordCount;
        } 
        
        #endregion
        
        #region GetPageList
		
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_OrderDetails> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_OrderDetails, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
           
            return GetPageList(page, pageSize,out pageCount, out recordCount, conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="gridModel">查询条件</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_OrderDetails> GetPageList(GridModel gridModel, Expression<Func<T_BAS_OrderDetails, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_OrderDetails, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            return GetPageList(gridModel.page, gridModel.rows, out gridModel.pageCount, out gridModel.recordCount, conditionExpression,isFilterNull, orderExpression, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法，分页
        /// </summary>      
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集，分页</returns>
        public List<T_BAS_OrderDetails> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            List<T_BAS_OrderDetails> dataList = new List<T_BAS_OrderDetails>();
            SqlParameter[] parameters = {
											new SqlParameter("@iPage", SqlDbType.Int),
											new SqlParameter("@iPageSize", SqlDbType.Int),
											new SqlParameter("@iPageCount", SqlDbType.Int),
											new SqlParameter("@iRecordCount", SqlDbType.Int),
											new SqlParameter("@strCondition", SqlDbType.NVarChar),
										    new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Value = page;
            parameters[1].Value = pageSize;
            parameters[2].Direction = ParameterDirection.Output;
            parameters[3].Direction = ParameterDirection.Output;
            parameters[4].Value = conditionString.Trim();
            parameters[5].Value = orderString.Trim();
            parameters[6].Value = flag.ToSqlLock();
            parameters[7].Value = CurrentManage.SMerchantGuid;
            parameters[8].Value = isFilterMerchant;
			if (orderString.Trim() != string.Empty)
				parameters[5].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";			
			
			SqlDataReader dataReader = SqlHelper.ExecuteReader("PT_BAS_OrderDetails_GetPageList",CommandType.StoredProcedure, parameters,sqlRTransaction);
            try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
			}
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetPageList获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
			
            pageCount = (int)parameters[2].Value;
            recordCount = (int)parameters[3].Value;
			
            return dataList;
        }
        
        #endregion
   
        /// <summary>
        /// 获取记录实体，从 DataReader 的当前记录装载
        /// </summary>
        /// <param name="dataReader">DataReader 对象</param>
        /// <returns>返回 DataReader 里下一条记录，记录不存在则返回Null</returns>
        private T_BAS_OrderDetails LoadModel(SqlDataReader dataReader)
        {
            T_BAS_OrderDetails data = new T_BAS_OrderDetails();
			if (dataReader["OrderDetailGuid"] != DBNull.Value)
				data.OrderDetailGuid = (Guid)dataReader["OrderDetailGuid"];
			if (dataReader["ProductGuid"] != DBNull.Value)
				data.ProductGuid = (Guid)dataReader["ProductGuid"];
			if (dataReader["GroupGuid"] != DBNull.Value)
				data.GroupGuid = (Guid)dataReader["GroupGuid"];
			if (dataReader["OrderGuid"] != DBNull.Value)
				data.OrderGuid = (Guid)dataReader["OrderGuid"];
			if (dataReader["DistributeGuid"] != DBNull.Value)
				data.DistributeGuid = (Guid)dataReader["DistributeGuid"];
			if (dataReader["ProductCategoryGuid"] != DBNull.Value)
				data.ProductCategoryGuid = (Guid)dataReader["ProductCategoryGuid"];
			if (dataReader["ProductName"] != DBNull.Value)
				data.ProductName = (string)dataReader["ProductName"];
			if (dataReader["ProductProp"] != DBNull.Value)
				data.ProductProp = (string)dataReader["ProductProp"];
			if (dataReader["SaleProp"] != DBNull.Value)
				data.SaleProp = (string)dataReader["SaleProp"];
			if (dataReader["ProductCode"] != DBNull.Value)
				data.ProductCode = (string)dataReader["ProductCode"];
			if (dataReader["Picture"] != DBNull.Value)
				data.Picture = (string)dataReader["Picture"];
			if (dataReader["Price"] != DBNull.Value)
				data.Price = (decimal)dataReader["Price"];
			if (dataReader["DiscountPrice"] != DBNull.Value)
				data.DiscountPrice = (decimal)dataReader["DiscountPrice"];
			if (dataReader["Discount"] != DBNull.Value)
				data.Discount = (decimal)dataReader["Discount"];
			if (dataReader["Quantity"] != DBNull.Value)
				data.Quantity = (decimal)dataReader["Quantity"];
			if (dataReader["Amount"] != DBNull.Value)
				data.Amount = (decimal)dataReader["Amount"];
			if (dataReader["TotalAmount"] != DBNull.Value)
				data.TotalAmount = (decimal)dataReader["TotalAmount"];
			if (dataReader["FirstCommission"] != DBNull.Value)
				data.FirstCommission = (decimal)dataReader["FirstCommission"];
			if (dataReader["SecondCommission"] != DBNull.Value)
				data.SecondCommission = (decimal)dataReader["SecondCommission"];
			if (dataReader["ThirdCommission"] != DBNull.Value)
				data.ThirdCommission = (decimal)dataReader["ThirdCommission"];
			if (dataReader["FirstCommissionSet"] != DBNull.Value)
				data.FirstCommissionSet = (decimal)dataReader["FirstCommissionSet"];
			if (dataReader["SecondCommissionSet"] != DBNull.Value)
				data.SecondCommissionSet = (decimal)dataReader["SecondCommissionSet"];
			if (dataReader["ThirdCommissionSet"] != DBNull.Value)
				data.ThirdCommissionSet = (decimal)dataReader["ThirdCommissionSet"];
			if (dataReader["TotalCommission"] != DBNull.Value)
				data.TotalCommission = (decimal)dataReader["TotalCommission"];
			if (dataReader["State"] != DBNull.Value)
				data.State = (int)dataReader["State"];
			if (dataReader["SMerchantGuid"] != DBNull.Value)
				data.SMerchantGuid = (Guid)dataReader["SMerchantGuid"];
			if (dataReader["SKU"] != DBNull.Value)
				data.SKU = (string)dataReader["SKU"];
			if (dataReader["WXPayMoney"] != DBNull.Value)
				data.WXPayMoney = (decimal)dataReader["WXPayMoney"];
			if (dataReader["IntegralTe"] != DBNull.Value)
				data.IntegralTe = (int)dataReader["IntegralTe"];
			if (dataReader["PresentExp"] != DBNull.Value)
				data.PresentExp = (int)dataReader["PresentExp"];
			if (dataReader["IntegralMoney"] != DBNull.Value)
				data.IntegralMoney = (decimal)dataReader["IntegralMoney"];
			if (dataReader["AgentDiscount"] != DBNull.Value)
				data.AgentDiscount = (decimal)dataReader["AgentDiscount"];
			if (dataReader["AgentPrice"] != DBNull.Value)
				data.AgentPrice = (decimal)dataReader["AgentPrice"];
            data.EntityState = EntityStates.Original; 
            return data;
        }
        
          #region IDisposable 成员
        /// <summary>
        /// 回收
        /// </summary>
        public void Dispose()
        {
            sqlRTransaction.Dispose();
        }

        #endregion

    }
}

