﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Transactions;
using RFrameGenerate.Model; 
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.Common;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using RFramework.SQLServer.Enums;

namespace RFrameGenerate.DAL.SQLServer
{
    internal class T_BAS_ProductsWithAgentDAL  : IQuery<T_BAS_ProductsWithAgent>
    {  
        /// <summary>
        /// 事务处理
        /// </summary>
        public SqlRTransaction sqlRTransaction { get; set; }
        
         #region Top
        /// <summary>
        /// 获取前Top，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_ProductsWithAgent>  GetTopData(string top, Expression<Func<T_BAS_ProductsWithAgent , bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_ProductsWithAgent , object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();

            return GetTopData(top,conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }

        /// <summary>
        /// 获取Top，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="top"></param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的第一条记录，记录不存在则返回Null</returns>
         public List<T_BAS_ProductsWithAgent> GetTopData(string top,string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            if (string.IsNullOrEmpty(top) == true)
            {
                throw new Exception("top不能为空,例:top=6或top=10%");
            }
            if (top.Contains("%"))
            {
                top = string.Format(" top {0} percent ", top.Replace("%",string.Empty));
            }
            else
            {
                top = string.Format(" top {0} ", top);
            }

            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@top", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_ProductsWithAgent";
            parameters[1].Value =" "+ top + " ProductGuid,ProductCategoryGuid,ProductTypeGuid,MerchantGuid,ProductName,ProductUrl,QRCodeUrl,ProductCode,MarketPrice,Price,MinPrice,MaxPrice,IsAgentsProduct,Inventory,Weight,SalesVolume,BaseSalesVolume,ProductImage,ProductImage1,ProductImage2,ProductImage3,ProductImage4,ProductImage5,FirstCommission,SecondCommission,ThirdCommission,IsDefault,Description,InventoryWay,Recommend,Quota,IsPutaway,Sort,IsProperty,IsStandards,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,PutawayDate,OriginalProductGuid,AgentsIsPutaway,TemplatesGuid,CommissionType,FirstCommissionAmount,SecondCommissionAmount,ThirdCommissionAmount,NoDelivery,NoReceive,CategoryCode,ProductClassify,AgentPrice,CategoryName";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
            if (orderString.Trim() != string.Empty)
                parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
				
            parameters[6].Value = isFilterMerchant;

           List<T_BAS_ProductsWithAgent> dataList = new List<T_BAS_ProductsWithAgent>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProc",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetTopData()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return dataList;
        }
        #endregion
        
        #region GetFirstData
        public T_BAS_ProductsWithAgent GetFirstData(Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_ProductsWithAgent, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
           
            return GetFirstData(conditionString, orderString, orderMethod, flag,isFilterMerchant);  
        }

        public T_BAS_ProductsWithAgent GetFirstData(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_ProductsWithAgent";
            parameters[1].Value = "ProductGuid,ProductCategoryGuid,ProductTypeGuid,MerchantGuid,ProductName,ProductUrl,QRCodeUrl,ProductCode,MarketPrice,Price,MinPrice,MaxPrice,IsAgentsProduct,Inventory,Weight,SalesVolume,BaseSalesVolume,ProductImage,ProductImage1,ProductImage2,ProductImage3,ProductImage4,ProductImage5,FirstCommission,SecondCommission,ThirdCommission,IsDefault,Description,InventoryWay,Recommend,Quota,IsPutaway,Sort,IsProperty,IsStandards,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,PutawayDate,OriginalProductGuid,AgentsIsPutaway,TemplatesGuid,CommissionType,FirstCommissionAmount,SecondCommissionAmount,ThirdCommissionAmount,NoDelivery,NoReceive,CategoryCode,ProductClassify,AgentPrice,CategoryName";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[6].Value = isFilterMerchant;
			
            T_BAS_ProductsWithAgent data = null;
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProcGetFirstData",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    data = LoadModel(dataReader);
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetFirstData()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return data;
        }
        #endregion
        
        #region GetCount
		
		/// <summary>
        /// 获取记录数，根据查询条件Lambda表达式
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <returns>返回满足条件的记录集</returns>
        public int GetCount(Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            return GetCount(conditionString,isFilterMerchant);
        }

        /// <summary>
        /// 获取记录数，根据查询条件
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <returns>返回满足条件的记录数</returns>
        public int GetCount(string conditionString = "", bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty; 
            SqlParameter[] parameters = {
											new SqlParameter("@tablesOrView", SqlDbType.NVarChar),
                                            new SqlParameter("@strCondition", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_ProductsWithAgent";
            parameters[1].Value = conditionString.Trim();
            parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;

           int recordCount =  SqlHelper.ExecuteScalar<int>("RunProcGetCount", CommandType.StoredProcedure, parameters, sqlRTransaction);
           
           return recordCount;
        } 
        
        #endregion
       
		#region GetList
         
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_ProductsWithAgent> GetList(Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_ProductsWithAgent, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);

            return GetList(conditionString, orderString, orderMethod, flag,isFilterMerchant);
         }
        
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_ProductsWithAgent> GetList(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_ProductsWithAgent";
            parameters[1].Value = "ProductGuid,ProductCategoryGuid,ProductTypeGuid,MerchantGuid,ProductName,ProductUrl,QRCodeUrl,ProductCode,MarketPrice,Price,MinPrice,MaxPrice,IsAgentsProduct,Inventory,Weight,SalesVolume,BaseSalesVolume,ProductImage,ProductImage1,ProductImage2,ProductImage3,ProductImage4,ProductImage5,FirstCommission,SecondCommission,ThirdCommission,IsDefault,Description,InventoryWay,Recommend,Quota,IsPutaway,Sort,IsProperty,IsStandards,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,PutawayDate,OriginalProductGuid,AgentsIsPutaway,TemplatesGuid,CommissionType,FirstCommissionAmount,SecondCommissionAmount,ThirdCommissionAmount,NoDelivery,NoReceive,CategoryCode,ProductClassify,AgentPrice,CategoryName";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[6].Value = isFilterMerchant;
			
            List<T_BAS_ProductsWithAgent> dataList = new List<T_BAS_ProductsWithAgent>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProc",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetList()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return dataList;
        }	
        
        #endregion
        
        #region GetPageList
		
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_ProductsWithAgent> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_ProductsWithAgent, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);

            return GetPageList(page, pageSize,out pageCount, out recordCount, conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="gridModel">查询条件</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_ProductsWithAgent> GetPageList(GridModel gridModel, Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_ProductsWithAgent, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            return GetPageList(gridModel.page, gridModel.rows, out gridModel.pageCount, out gridModel.recordCount, conditionExpression,isFilterNull, orderExpression, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法，分页
        /// </summary>      
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集，分页</returns>
        public List<T_BAS_ProductsWithAgent> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            List<T_BAS_ProductsWithAgent> dataList = new List<T_BAS_ProductsWithAgent>();
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar),
                                            new SqlParameter("@primaryField", SqlDbType.NVarChar,100),
											new SqlParameter("@iPage", SqlDbType.Int),
											new SqlParameter("@iPageSize", SqlDbType.Int),
											new SqlParameter("@iPageCount", SqlDbType.Int),
											new SqlParameter("@iRecordCount", SqlDbType.Int),
											new SqlParameter("@strCondition", SqlDbType.NVarChar),
										    new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Value = "T_BAS_ProductsWithAgent";
            parameters[1].Value = "ProductGuid,ProductCategoryGuid,ProductTypeGuid,MerchantGuid,ProductName,ProductUrl,QRCodeUrl,ProductCode,MarketPrice,Price,MinPrice,MaxPrice,IsAgentsProduct,Inventory,Weight,SalesVolume,BaseSalesVolume,ProductImage,ProductImage1,ProductImage2,ProductImage3,ProductImage4,ProductImage5,FirstCommission,SecondCommission,ThirdCommission,IsDefault,Description,InventoryWay,Recommend,Quota,IsPutaway,Sort,IsProperty,IsStandards,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,PutawayDate,OriginalProductGuid,AgentsIsPutaway,TemplatesGuid,CommissionType,FirstCommissionAmount,SecondCommissionAmount,ThirdCommissionAmount,NoDelivery,NoReceive,CategoryCode,ProductClassify,AgentPrice,CategoryName";
            parameters[2].Value = "ProductGuid";
            parameters[3].Value = page;
            parameters[4].Value = pageSize;
            parameters[5].Direction = ParameterDirection.Output;
            parameters[6].Direction = ParameterDirection.Output;
            parameters[7].Value = conditionString.Trim();
            parameters[8].Value = orderString.Trim();
            parameters[9].Value = flag.ToSqlLock();
            parameters[10].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[8].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";			
            parameters[11].Value = isFilterMerchant;
			
			SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProcPage",CommandType.StoredProcedure, parameters,sqlRTransaction);
            try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
			}
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetPageList()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }		
            dataReader.Close();
            
            pageCount = (int)parameters[5].Value;
            recordCount = (int)parameters[6].Value;
			
            return dataList;
        }
        
        #endregion
   
        /// <summary>
        /// 获取记录实体，从 DataReader 的当前记录装载
        /// </summary>
        /// <param name="dataReader">DataReader 对象</param>
        /// <returns>返回 DataReader 里下一条记录，记录不存在则返回Null</returns>
        private T_BAS_ProductsWithAgent LoadModel(SqlDataReader dataReader)
        {
            T_BAS_ProductsWithAgent data = new T_BAS_ProductsWithAgent();
			if (dataReader["ProductGuid"] != DBNull.Value)
				data.ProductGuid = (Guid)dataReader["ProductGuid"];
			if (dataReader["ProductCategoryGuid"] != DBNull.Value)
				data.ProductCategoryGuid = (Guid)dataReader["ProductCategoryGuid"];
			if (dataReader["ProductTypeGuid"] != DBNull.Value)
				data.ProductTypeGuid = (Guid)dataReader["ProductTypeGuid"];
			if (dataReader["MerchantGuid"] != DBNull.Value)
				data.MerchantGuid = (Guid)dataReader["MerchantGuid"];
			if (dataReader["ProductName"] != DBNull.Value)
				data.ProductName = (string)dataReader["ProductName"];
			if (dataReader["ProductUrl"] != DBNull.Value)
				data.ProductUrl = (string)dataReader["ProductUrl"];
			if (dataReader["QRCodeUrl"] != DBNull.Value)
				data.QRCodeUrl = (string)dataReader["QRCodeUrl"];
			if (dataReader["ProductCode"] != DBNull.Value)
				data.ProductCode = (string)dataReader["ProductCode"];
			if (dataReader["MarketPrice"] != DBNull.Value)
				data.MarketPrice = (decimal)dataReader["MarketPrice"];
			if (dataReader["Price"] != DBNull.Value)
				data.Price = (decimal)dataReader["Price"];
			if (dataReader["MinPrice"] != DBNull.Value)
				data.MinPrice = (decimal)dataReader["MinPrice"];
			if (dataReader["MaxPrice"] != DBNull.Value)
				data.MaxPrice = (decimal)dataReader["MaxPrice"];
			if (dataReader["IsAgentsProduct"] != DBNull.Value)
				data.IsAgentsProduct = (bool)dataReader["IsAgentsProduct"];
			if (dataReader["Inventory"] != DBNull.Value)
				data.Inventory = (int)dataReader["Inventory"];
			if (dataReader["Weight"] != DBNull.Value)
				data.Weight = (int)dataReader["Weight"];
			if (dataReader["SalesVolume"] != DBNull.Value)
				data.SalesVolume = (decimal)dataReader["SalesVolume"];
			if (dataReader["BaseSalesVolume"] != DBNull.Value)
				data.BaseSalesVolume = (decimal)dataReader["BaseSalesVolume"];
			if (dataReader["ProductImage"] != DBNull.Value)
				data.ProductImage = (string)dataReader["ProductImage"];
			if (dataReader["ProductImage1"] != DBNull.Value)
				data.ProductImage1 = (string)dataReader["ProductImage1"];
			if (dataReader["ProductImage2"] != DBNull.Value)
				data.ProductImage2 = (string)dataReader["ProductImage2"];
			if (dataReader["ProductImage3"] != DBNull.Value)
				data.ProductImage3 = (string)dataReader["ProductImage3"];
			if (dataReader["ProductImage4"] != DBNull.Value)
				data.ProductImage4 = (string)dataReader["ProductImage4"];
			if (dataReader["ProductImage5"] != DBNull.Value)
				data.ProductImage5 = (string)dataReader["ProductImage5"];
			if (dataReader["FirstCommission"] != DBNull.Value)
				data.FirstCommission = (decimal)dataReader["FirstCommission"];
			if (dataReader["SecondCommission"] != DBNull.Value)
				data.SecondCommission = (decimal)dataReader["SecondCommission"];
			if (dataReader["ThirdCommission"] != DBNull.Value)
				data.ThirdCommission = (decimal)dataReader["ThirdCommission"];
			if (dataReader["IsDefault"] != DBNull.Value)
				data.IsDefault = (bool)dataReader["IsDefault"];
			if (dataReader["Description"] != DBNull.Value)
				data.Description = (string)dataReader["Description"];
			if (dataReader["InventoryWay"] != DBNull.Value)
				data.InventoryWay = (int)dataReader["InventoryWay"];
			if (dataReader["Recommend"] != DBNull.Value)
				data.Recommend = (bool)dataReader["Recommend"];
			if (dataReader["Quota"] != DBNull.Value)
				data.Quota = (int)dataReader["Quota"];
			if (dataReader["IsPutaway"] != DBNull.Value)
				data.IsPutaway = (bool)dataReader["IsPutaway"];
			if (dataReader["Sort"] != DBNull.Value)
				data.Sort = (int)dataReader["Sort"];
			if (dataReader["IsProperty"] != DBNull.Value)
				data.IsProperty = (bool)dataReader["IsProperty"];
			if (dataReader["IsStandards"] != DBNull.Value)
				data.IsStandards = (bool)dataReader["IsStandards"];
			if (dataReader["SMerchantGuid"] != DBNull.Value)
				data.SMerchantGuid = (Guid)dataReader["SMerchantGuid"];
			if (dataReader["PutawayDate"] != DBNull.Value)
				data.PutawayDate = (DateTime)dataReader["PutawayDate"];
			if (dataReader["OriginalProductGuid"] != DBNull.Value)
				data.OriginalProductGuid = (Guid)dataReader["OriginalProductGuid"];
			if (dataReader["AgentsIsPutaway"] != DBNull.Value)
				data.AgentsIsPutaway = (bool)dataReader["AgentsIsPutaway"];
			if (dataReader["TemplatesGuid"] != DBNull.Value)
				data.TemplatesGuid = (Guid)dataReader["TemplatesGuid"];
			if (dataReader["CommissionType"] != DBNull.Value)
				data.CommissionType = (int)dataReader["CommissionType"];
			if (dataReader["FirstCommissionAmount"] != DBNull.Value)
				data.FirstCommissionAmount = (decimal)dataReader["FirstCommissionAmount"];
			if (dataReader["SecondCommissionAmount"] != DBNull.Value)
				data.SecondCommissionAmount = (decimal)dataReader["SecondCommissionAmount"];
			if (dataReader["ThirdCommissionAmount"] != DBNull.Value)
				data.ThirdCommissionAmount = (decimal)dataReader["ThirdCommissionAmount"];
			if (dataReader["NoDelivery"] != DBNull.Value)
				data.NoDelivery = (bool)dataReader["NoDelivery"];
			if (dataReader["NoReceive"] != DBNull.Value)
				data.NoReceive = (bool)dataReader["NoReceive"];
			if (dataReader["CategoryCode"] != DBNull.Value)
				data.CategoryCode = (string)dataReader["CategoryCode"];
			if (dataReader["ProductClassify"] != DBNull.Value)
				data.ProductClassify = (int)dataReader["ProductClassify"];
			if (dataReader["AgentPrice"] != DBNull.Value)
				data.AgentPrice = (decimal)dataReader["AgentPrice"];
			if (dataReader["CategoryName"] != DBNull.Value)
				data.CategoryName = (string)dataReader["CategoryName"];
            data.EntityState = EntityStates.Original; 
            return data;
        }
        
          #region IDisposable 成员
        /// <summary>
        /// 回收
        /// </summary>
        public void Dispose()
        {
            sqlRTransaction.Dispose();
        }

        #endregion
        
        #region 未实现
        public bool IsExist(Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        
        public bool IsExist(string conditionString, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public void AddList(List<T_BAS_ProductsWithAgent> dataList)
        {
            throw new NotImplementedException();
        }

        public void DeleteList(List<T_BAS_ProductsWithAgent> dataList, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public bool IsExist(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public bool IsExist<U>(string field, U value, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public T_BAS_ProductsWithAgent GetDataByGuid(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Add(T_BAS_ProductsWithAgent data)
        {
            throw new NotImplementedException();
        }

        public void Update(T_BAS_ProductsWithAgent data, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public void Update(Expression<Func<T_BAS_ProductsWithAgent, object[]>> valueExpression, Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        
        public void UpdateList(List<T_BAS_ProductsWithAgent> dataList)
        {
            throw new NotImplementedException();
        }

        public void Delete(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Delete(Expression<Func<T_BAS_ProductsWithAgent, bool>> conditionExpression, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Delete(string conditionString = "", bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        #endregion
    }
}

