﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Transactions;
using RFrameGenerate.Model; 
using RFrameGenerate.DAL.Enums;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.Common;
using RFramework.SQLQuery;
using RFramework.SQLServer;
using RFramework.SQLServer.Enums;

namespace RFrameGenerate.DAL.SQLServer
{
    internal class T_BAS_RefundApplysWithLiteDAL  : IQuery<T_BAS_RefundApplysWithLite>
    {  
        /// <summary>
        /// 事务处理
        /// </summary>
        public SqlRTransaction sqlRTransaction { get; set; }
        
         #region Top
        /// <summary>
        /// 获取前Top，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_RefundApplysWithLite>  GetTopData(string top, Expression<Func<T_BAS_RefundApplysWithLite , bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_RefundApplysWithLite , object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();

            return GetTopData(top,conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }

        /// <summary>
        /// 获取Top，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="top"></param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的第一条记录，记录不存在则返回Null</returns>
         public List<T_BAS_RefundApplysWithLite> GetTopData(string top,string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            if (string.IsNullOrEmpty(top) == true)
            {
                throw new Exception("top不能为空,例:top=6或top=10%");
            }
            if (top.Contains("%"))
            {
                top = string.Format(" top {0} percent ", top.Replace("%",string.Empty));
            }
            else
            {
                top = string.Format(" top {0} ", top);
            }

            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@top", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_RefundApplysWithLite";
            parameters[1].Value =" "+ top + " RefundApplyGuid,MerchantGuid,OrderGuid,OrderNo,Recipients,Telephone,RefundType,IsSignIn,IsRefund,RefundAddress,RefundWay,RefundAmount,ApplyDateTime,RefundRemark,State,Account,Express,ExpressNo,SerialNumber,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,RefundOrderNo,UserWeChatType,GoodsDeliveryType,CommodityRefundAudit,AgentComType,AgentComRatio,HasCountedCommission,CountedCommissionTime";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
            if (orderString.Trim() != string.Empty)
                parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
				
            parameters[6].Value = isFilterMerchant;

           List<T_BAS_RefundApplysWithLite> dataList = new List<T_BAS_RefundApplysWithLite>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProc",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetTopData()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return dataList;
        }
        #endregion
        
        #region GetFirstData
        public T_BAS_RefundApplysWithLite GetFirstData(Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_RefundApplysWithLite, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
           
            return GetFirstData(conditionString, orderString, orderMethod, flag,isFilterMerchant);  
        }

        public T_BAS_RefundApplysWithLite GetFirstData(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.NOLOCK, bool isFilterMerchant = true)
        {
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_RefundApplysWithLite";
            parameters[1].Value = "RefundApplyGuid,MerchantGuid,OrderGuid,OrderNo,Recipients,Telephone,RefundType,IsSignIn,IsRefund,RefundAddress,RefundWay,RefundAmount,ApplyDateTime,RefundRemark,State,Account,Express,ExpressNo,SerialNumber,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,RefundOrderNo,UserWeChatType,GoodsDeliveryType,CommodityRefundAudit,AgentComType,AgentComRatio,HasCountedCommission,CountedCommissionTime";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[6].Value = isFilterMerchant;
			
            T_BAS_RefundApplysWithLite data = null;
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProcGetFirstData",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    data = LoadModel(dataReader);
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetFirstData()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return data;
        }
        #endregion
        
        #region GetCount
		
		/// <summary>
        /// 获取记录数，根据查询条件Lambda表达式
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <returns>返回满足条件的记录集</returns>
        public int GetCount(Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            return GetCount(conditionString,isFilterMerchant);
        }

        /// <summary>
        /// 获取记录数，根据查询条件
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <returns>返回满足条件的记录数</returns>
        public int GetCount(string conditionString = "", bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty; 
            SqlParameter[] parameters = {
											new SqlParameter("@tablesOrView", SqlDbType.NVarChar),
                                            new SqlParameter("@strCondition", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_RefundApplysWithLite";
            parameters[1].Value = conditionString.Trim();
            parameters[2].Value = CurrentManage.SMerchantGuid;
            parameters[3].Value = isFilterMerchant;

           int recordCount =  SqlHelper.ExecuteScalar<int>("RunProcGetCount", CommandType.StoredProcedure, parameters, sqlRTransaction);
           
           return recordCount;
        } 
        
        #endregion
       
		#region GetList
         
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_RefundApplysWithLite> GetList(Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_RefundApplysWithLite, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);

            return GetList(conditionString, orderString, orderMethod, flag,isFilterMerchant);
         }
        
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法
        /// </summary>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_RefundApplysWithLite> GetList(string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar), 
											new SqlParameter("@strCondition", SqlDbType.NVarChar), 
											new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
										};
            parameters[0].Value = "T_BAS_RefundApplysWithLite";
            parameters[1].Value = "RefundApplyGuid,MerchantGuid,OrderGuid,OrderNo,Recipients,Telephone,RefundType,IsSignIn,IsRefund,RefundAddress,RefundWay,RefundAmount,ApplyDateTime,RefundRemark,State,Account,Express,ExpressNo,SerialNumber,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,RefundOrderNo,UserWeChatType,GoodsDeliveryType,CommodityRefundAudit,AgentComType,AgentComRatio,HasCountedCommission,CountedCommissionTime";
            parameters[2].Value = conditionString.Trim();
            parameters[3].Value = orderString.Trim();
            parameters[4].Value = flag.ToSqlLock();
            parameters[5].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[3].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";
            parameters[6].Value = isFilterMerchant;
			
            List<T_BAS_RefundApplysWithLite> dataList = new List<T_BAS_RefundApplysWithLite>();
			           
            SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProc",CommandType.StoredProcedure, parameters, sqlRTransaction);

			try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
            }
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetList()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }
            dataReader.Close();
            
            return dataList;
        }	
        
        #endregion
        
        #region GetPageList
		
		/// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_RefundApplysWithLite> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_RefundApplysWithLite, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        {
            QueryTranslator where = new QueryTranslator();
            string conditionString = where.Translate(conditionExpression);
            if (isFilterNull == true)
                conditionString = conditionString.SqlFilterNull();
            string orderString = string.Empty;
            if (orderExpression != null)
                orderString = where.Translate(orderExpression);

            return GetPageList(page, pageSize,out pageCount, out recordCount, conditionString, orderString, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件Lambda表达式及排序字段Lambda表达式、排序方法
        /// </summary>
        /// <param name="gridModel">查询条件</param>
        /// <param name="conditionExpression">查询条件Lambda表达式</param>
        /// <param name="orderString">排序字段Lambda表达式，字段间用“+”号连接</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集</returns>
        public List<T_BAS_RefundApplysWithLite> GetPageList(GridModel gridModel, Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, Expression<Func<T_BAS_RefundApplysWithLite, object>> orderExpression = null, OrderMethods orderMethod = OrderMethods.Default, LockType flag = LockType.Default, bool isFilterMerchant = true)
        {
            return GetPageList(gridModel.page, gridModel.rows, out gridModel.pageCount, out gridModel.recordCount, conditionExpression,isFilterNull, orderExpression, orderMethod, flag,isFilterMerchant);
        }
        /// <summary>
        /// 获取记录集，根据查询条件及排序字段、排序方法，分页
        /// </summary>      
        /// <param name="page">页号</param>
        /// <param name="pageSize">每页的记录数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="recordCount">返回总记录数</param>
        /// <param name="conditionString">查询条件字符串，SQL语句中的WHERE表达式</param>
        /// <param name="orderString">排序字段字符串，SQL语句中的OrderBy表达式，字段间用“,”号隔开</param>
        /// <param name="orderMethod">排序方法，升序或降序排列</param>
        /// <returns>返回满足条件的记录集，分页</returns>
        public List<T_BAS_RefundApplysWithLite> GetPageList(int page, int pageSize, out int pageCount, out int recordCount, string conditionString = "", string orderString = "", OrderMethods orderMethod = OrderMethods.Default,LockType flag=LockType.Default, bool isFilterMerchant = true)
        { 
            if (conditionString == null)
                conditionString = string.Empty;
            if (orderString == null)
                orderString = string.Empty;
            List<T_BAS_RefundApplysWithLite> dataList = new List<T_BAS_RefundApplysWithLite>();
            SqlParameter[] parameters = {
                                            new SqlParameter("@tablesOrView", SqlDbType.NVarChar), 
                                            new SqlParameter("@fieldNames", SqlDbType.NVarChar),
                                            new SqlParameter("@primaryField", SqlDbType.NVarChar,100),
											new SqlParameter("@iPage", SqlDbType.Int),
											new SqlParameter("@iPageSize", SqlDbType.Int),
											new SqlParameter("@iPageCount", SqlDbType.Int),
											new SqlParameter("@iRecordCount", SqlDbType.Int),
											new SqlParameter("@strCondition", SqlDbType.NVarChar),
										    new SqlParameter("@strOrder", SqlDbType.NVarChar),
                                            new SqlParameter("@strLockType", SqlDbType.NVarChar),
                                            new SqlParameter("@SMerchantGuid", SqlDbType.UniqueIdentifier),
                                            new SqlParameter("@isFilterMerchant", SqlDbType.Bit),
                                        };
            parameters[0].Value = "T_BAS_RefundApplysWithLite";
            parameters[1].Value = "RefundApplyGuid,MerchantGuid,OrderGuid,OrderNo,Recipients,Telephone,RefundType,IsSignIn,IsRefund,RefundAddress,RefundWay,RefundAmount,ApplyDateTime,RefundRemark,State,Account,Express,ExpressNo,SerialNumber,SCreateDate,SUpdateUserName,SCreateUserName,SUpdateDate,SMerchantGuid,RefundOrderNo,UserWeChatType,GoodsDeliveryType,CommodityRefundAudit,AgentComType,AgentComRatio,HasCountedCommission,CountedCommissionTime";
            parameters[2].Value = "RefundApplyGuid";
            parameters[3].Value = page;
            parameters[4].Value = pageSize;
            parameters[5].Direction = ParameterDirection.Output;
            parameters[6].Direction = ParameterDirection.Output;
            parameters[7].Value = conditionString.Trim();
            parameters[8].Value = orderString.Trim();
            parameters[9].Value = flag.ToSqlLock();
            parameters[10].Value = CurrentManage.SMerchantGuid;
			if (orderString.Trim() != string.Empty)
				parameters[8].Value += orderMethod == OrderMethods.DESC ? " DESC" : " ASC";			
            parameters[11].Value = isFilterMerchant;
			
			SqlDataReader dataReader = SqlHelper.ExecuteReader("RunProcPage",CommandType.StoredProcedure, parameters,sqlRTransaction);
            try
            {
                while (dataReader.Read())
                {
                    dataList.Add(LoadModel(dataReader));
                }
			}
            catch (Exception ex)
            {
                dataReader.Close();
                Dispose();
                throw new Exception(string.Format("GetPageList()获取数据记录出错,conditionString={0},异常:{1}", conditionString, ex.Message), ex);
            }		
            dataReader.Close();
            
            pageCount = (int)parameters[5].Value;
            recordCount = (int)parameters[6].Value;
			
            return dataList;
        }
        
        #endregion
   
        /// <summary>
        /// 获取记录实体，从 DataReader 的当前记录装载
        /// </summary>
        /// <param name="dataReader">DataReader 对象</param>
        /// <returns>返回 DataReader 里下一条记录，记录不存在则返回Null</returns>
        private T_BAS_RefundApplysWithLite LoadModel(SqlDataReader dataReader)
        {
            T_BAS_RefundApplysWithLite data = new T_BAS_RefundApplysWithLite();
			if (dataReader["RefundApplyGuid"] != DBNull.Value)
				data.RefundApplyGuid = (Guid)dataReader["RefundApplyGuid"];
			if (dataReader["MerchantGuid"] != DBNull.Value)
				data.MerchantGuid = (Guid)dataReader["MerchantGuid"];
			if (dataReader["OrderGuid"] != DBNull.Value)
				data.OrderGuid = (Guid)dataReader["OrderGuid"];
			if (dataReader["OrderNo"] != DBNull.Value)
				data.OrderNo = (string)dataReader["OrderNo"];
			if (dataReader["Recipients"] != DBNull.Value)
				data.Recipients = (string)dataReader["Recipients"];
			if (dataReader["Telephone"] != DBNull.Value)
				data.Telephone = (string)dataReader["Telephone"];
			if (dataReader["RefundType"] != DBNull.Value)
				data.RefundType = (string)dataReader["RefundType"];
			if (dataReader["IsSignIn"] != DBNull.Value)
				data.IsSignIn = (bool)dataReader["IsSignIn"];
			if (dataReader["IsRefund"] != DBNull.Value)
				data.IsRefund = (bool)dataReader["IsRefund"];
			if (dataReader["RefundAddress"] != DBNull.Value)
				data.RefundAddress = (string)dataReader["RefundAddress"];
			if (dataReader["RefundWay"] != DBNull.Value)
				data.RefundWay = (string)dataReader["RefundWay"];
			if (dataReader["RefundAmount"] != DBNull.Value)
				data.RefundAmount = (decimal)dataReader["RefundAmount"];
			if (dataReader["ApplyDateTime"] != DBNull.Value)
				data.ApplyDateTime = (DateTime)dataReader["ApplyDateTime"];
			if (dataReader["RefundRemark"] != DBNull.Value)
				data.RefundRemark = (string)dataReader["RefundRemark"];
			if (dataReader["State"] != DBNull.Value)
				data.State = (int)dataReader["State"];
			if (dataReader["Account"] != DBNull.Value)
				data.Account = (string)dataReader["Account"];
			if (dataReader["Express"] != DBNull.Value)
				data.Express = (string)dataReader["Express"];
			if (dataReader["ExpressNo"] != DBNull.Value)
				data.ExpressNo = (string)dataReader["ExpressNo"];
			if (dataReader["SerialNumber"] != DBNull.Value)
				data.SerialNumber = (string)dataReader["SerialNumber"];
			if (dataReader["SMerchantGuid"] != DBNull.Value)
				data.SMerchantGuid = (Guid)dataReader["SMerchantGuid"];
			if (dataReader["RefundOrderNo"] != DBNull.Value)
				data.RefundOrderNo = (string)dataReader["RefundOrderNo"];
			if (dataReader["UserWeChatType"] != DBNull.Value)
				data.UserWeChatType = (int)dataReader["UserWeChatType"];
			if (dataReader["GoodsDeliveryType"] != DBNull.Value)
				data.GoodsDeliveryType = (int)dataReader["GoodsDeliveryType"];
			if (dataReader["CommodityRefundAudit"] != DBNull.Value)
				data.CommodityRefundAudit = (int)dataReader["CommodityRefundAudit"];
			if (dataReader["AgentComType"] != DBNull.Value)
				data.AgentComType = (int)dataReader["AgentComType"];
			if (dataReader["AgentComRatio"] != DBNull.Value)
				data.AgentComRatio = (decimal)dataReader["AgentComRatio"];
			if (dataReader["HasCountedCommission"] != DBNull.Value)
				data.HasCountedCommission = (bool)dataReader["HasCountedCommission"];
			if (dataReader["CountedCommissionTime"] != DBNull.Value)
				data.CountedCommissionTime = (DateTime)dataReader["CountedCommissionTime"];
            data.EntityState = EntityStates.Original; 
            return data;
        }
        
          #region IDisposable 成员
        /// <summary>
        /// 回收
        /// </summary>
        public void Dispose()
        {
            sqlRTransaction.Dispose();
        }

        #endregion
        
        #region 未实现
        public bool IsExist(Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterNull = false, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        
        public bool IsExist(string conditionString, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public void AddList(List<T_BAS_RefundApplysWithLite> dataList)
        {
            throw new NotImplementedException();
        }

        public void DeleteList(List<T_BAS_RefundApplysWithLite> dataList, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public bool IsExist(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public bool IsExist<U>(string field, U value, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public T_BAS_RefundApplysWithLite GetDataByGuid(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Add(T_BAS_RefundApplysWithLite data)
        {
            throw new NotImplementedException();
        }

        public void Update(T_BAS_RefundApplysWithLite data, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        public void Update(Expression<Func<T_BAS_RefundApplysWithLite, object[]>> valueExpression, Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        
        public void UpdateList(List<T_BAS_RefundApplysWithLite> dataList)
        {
            throw new NotImplementedException();
        }

        public void Delete(Guid dataGuid, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Delete(Expression<Func<T_BAS_RefundApplysWithLite, bool>> conditionExpression, bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }

        public void Delete(string conditionString = "", bool isFilterMerchant = true)
        {
            throw new NotImplementedException();
        }
        #endregion
    }
}

