﻿using RFramework.SQLServer;
using RFrameGenerate.DAL.Interface;
using RFrameGenerate.DAL.SQLServer;
using RFrameGenerate.Model;
using RFrameGenerate.Common.DatabaseConfig;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace RFrameGenerate.DAL
{
    public abstract class IFactory
    { 
        #region 核心
        /// <summary>
        /// 获取连接对象
        /// </summary>
        /// <returns></returns>
        protected static SqlRTransaction GetSqlConnection()
        {
            return new SqlRTransaction();
        }
        /// <summary>
        /// 根据完整命名空间创建对象
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="tableName">对象名</param>
        /// <returns></returns>
        protected static IQuery<T> CreateInstance<T>(string tableName, SqlRTransaction transaction)
        {
            string className = string.Format("{0}.{1}.{2}", Database.AssemblyName, Database.DatabaseType, tableName);
            IQuery<T> iquery = (IQuery<T>)Assembly.Load(Database.AssemblyName).CreateInstance(className);

            if (iquery != null)
            {
                if (transaction == null)
                {
                    iquery.sqlRTransaction = GetSqlConnection();
                }
                else
                {
                    iquery.sqlRTransaction = transaction;
                }
            }
            else
            {
                throw new Exception("路径错误!");
            }
            return iquery;
        }
        /// <summary>
        /// 调用自定义存储过程
        /// </summary>
        /// <param name="transaction">连接事务</param>
        /// <returns></returns>
        public static IProcedure CreateProcedure(SqlRTransaction transaction = null)
        {
            if (transaction == null)
                transaction = GetSqlConnection();
            return new IProcedure(transaction);
        }
        #endregion
        
        
        public static IQuery<T_BAS_AdvanceAgentAccount> CreateT_BAS_AdvanceAgentAccount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AdvanceAgentAccount>("T_BAS_AdvanceAgentAccountDAL" , transaction);
        }
        public static IQuery<T_BAS_AgentPrepaidRrecords> CreateT_BAS_AgentPrepaidRrecords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AgentPrepaidRrecords>("T_BAS_AgentPrepaidRrecordsDAL" , transaction);
        }
        public static IQuery<T_BAS_AgentProductDiscount> CreateT_BAS_AgentProductDiscount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AgentProductDiscount>("T_BAS_AgentProductDiscountDAL" , transaction);
        }
        public static IQuery<T_BAS_AgentProductDiscountDetail> CreateT_BAS_AgentProductDiscountDetail(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AgentProductDiscountDetail>("T_BAS_AgentProductDiscountDetailDAL" , transaction);
        }
        public static IQuery<T_BAS_Agents> CreateT_BAS_Agents(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Agents>("T_BAS_AgentsDAL" , transaction);
        }
        public static IQuery<T_BAS_AgentsFlagship> CreateT_BAS_AgentsFlagship(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AgentsFlagship>("T_BAS_AgentsFlagshipDAL" , transaction);
        }
        public static IQuery<T_BAS_ApplyDistributionRecords> CreateT_BAS_ApplyDistributionRecords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ApplyDistributionRecords>("T_BAS_ApplyDistributionRecordsDAL" , transaction);
        }
        public static IQuery<T_BAS_ApplyWeiXinHaiRecords> CreateT_BAS_ApplyWeiXinHaiRecords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ApplyWeiXinHaiRecords>("T_BAS_ApplyWeiXinHaiRecordsDAL" , transaction);
        }
        public static IQuery<T_BAS_AreaPrice> CreateT_BAS_AreaPrice(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AreaPrice>("T_BAS_AreaPriceDAL" , transaction);
        }
        public static IQuery<T_BAS_Areas> CreateT_BAS_Areas(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Areas>("T_BAS_AreasDAL" , transaction);
        }
        public static IQuery<T_BAS_Authos> CreateT_BAS_Authos(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Authos>("T_BAS_AuthosDAL" , transaction);
        }
        public static IQuery<T_BAS_Comments> CreateT_BAS_Comments(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Comments>("T_BAS_CommentsDAL" , transaction);
        }
        public static IQuery<T_BAS_CommentsImg> CreateT_BAS_CommentsImg(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_CommentsImg>("T_BAS_CommentsImgDAL" , transaction);
        }
        public static IQuery<T_BAS_ContributionError> CreateT_BAS_ContributionError(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ContributionError>("T_BAS_ContributionErrorDAL" , transaction);
        }
        public static IQuery<T_BAS_CustomerServices> CreateT_BAS_CustomerServices(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_CustomerServices>("T_BAS_CustomerServicesDAL" , transaction);
        }
        public static IQuery<T_BAS_DeliveryMethod> CreateT_BAS_DeliveryMethod(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_DeliveryMethod>("T_BAS_DeliveryMethodDAL" , transaction);
        }
        public static IQuery<T_BAS_DeliveryMethodDetail> CreateT_BAS_DeliveryMethodDetail(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_DeliveryMethodDetail>("T_BAS_DeliveryMethodDetailDAL" , transaction);
        }
        public static IQuery<T_BAS_Distribute> CreateT_BAS_Distribute(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Distribute>("T_BAS_DistributeDAL" , transaction);
        }
        public static IQuery<T_BAS_DistributionCommissions> CreateT_BAS_DistributionCommissions(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_DistributionCommissions>("T_BAS_DistributionCommissionsDAL" , transaction);
        }
        public static IQuery<T_BAS_DistributionProp> CreateT_BAS_DistributionProp(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_DistributionProp>("T_BAS_DistributionPropDAL" , transaction);
        }
        public static IQuery<T_BAS_DistributionType> CreateT_BAS_DistributionType(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_DistributionType>("T_BAS_DistributionTypeDAL" , transaction);
        }
        public static IQuery<T_BAS_FactorageAccount> CreateT_BAS_FactorageAccount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FactorageAccount>("T_BAS_FactorageAccountDAL" , transaction);
        }
        public static IQuery<T_BAS_FactorageWithdrawal> CreateT_BAS_FactorageWithdrawal(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FactorageWithdrawal>("T_BAS_FactorageWithdrawalDAL" , transaction);
        }
        public static IQuery<T_BAS_Favorites> CreateT_BAS_Favorites(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Favorites>("T_BAS_FavoritesDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagAgentComUp> CreateT_BAS_FlagAgentComUp(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagAgentComUp>("T_BAS_FlagAgentComUpDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipCommission> CreateT_BAS_FlagshipCommission(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipCommission>("T_BAS_FlagshipCommissionDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipGroup> CreateT_BAS_FlagshipGroup(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipGroup>("T_BAS_FlagshipGroupDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipOrders> CreateT_BAS_FlagshipOrders(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipOrders>("T_BAS_FlagshipOrdersDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipPack> CreateT_BAS_FlagshipPack(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipPack>("T_BAS_FlagshipPackDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipPara> CreateT_BAS_FlagshipPara(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipPara>("T_BAS_FlagshipParaDAL" , transaction);
        }
        public static IQuery<T_BAS_Keywords> CreateT_BAS_Keywords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Keywords>("T_BAS_KeywordsDAL" , transaction);
        }
        public static IQuery<T_BAS_Level> CreateT_BAS_Level(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Level>("T_BAS_LevelDAL" , transaction);
        }
        public static IQuery<T_BAS_LoginRelation> CreateT_BAS_LoginRelation(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_LoginRelation>("T_BAS_LoginRelationDAL" , transaction);
        }
        public static IQuery<T_BAS_Logistics> CreateT_BAS_Logistics(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Logistics>("T_BAS_LogisticsDAL" , transaction);
        }
        public static IQuery<T_BAS_LogisticsCompanys> CreateT_BAS_LogisticsCompanys(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_LogisticsCompanys>("T_BAS_LogisticsCompanysDAL" , transaction);
        }
        public static IQuery<T_BAS_Materials> CreateT_BAS_Materials(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Materials>("T_BAS_MaterialsDAL" , transaction);
        }
        public static IQuery<T_BAS_MaterialTxt> CreateT_BAS_MaterialTxt(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MaterialTxt>("T_BAS_MaterialTxtDAL" , transaction);
        }
        public static IQuery<T_BAS_Member> CreateT_BAS_Member(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Member>("T_BAS_MemberDAL" , transaction);
        }
        public static IQuery<T_BAS_MemberAccount> CreateT_BAS_MemberAccount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MemberAccount>("T_BAS_MemberAccountDAL" , transaction);
        }
        public static IQuery<T_BAS_MemberLevel> CreateT_BAS_MemberLevel(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MemberLevel>("T_BAS_MemberLevelDAL" , transaction);
        }
        public static IQuery<T_BAS_Merchants> CreateT_BAS_Merchants(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Merchants>("T_BAS_MerchantsDAL" , transaction);
        }
        public static IQuery<T_BAS_MerchantsPayWay> CreateT_BAS_MerchantsPayWay(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MerchantsPayWay>("T_BAS_MerchantsPayWayDAL" , transaction);
        }
        public static IQuery<T_BAS_MessageTemplate> CreateT_BAS_MessageTemplate(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MessageTemplate>("T_BAS_MessageTemplateDAL" , transaction);
        }
        public static IQuery<T_BAS_MessageTemplateRecipient> CreateT_BAS_MessageTemplateRecipient(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MessageTemplateRecipient>("T_BAS_MessageTemplateRecipientDAL" , transaction);
        }
        public static IQuery<T_BAS_OnlineCount> CreateT_BAS_OnlineCount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OnlineCount>("T_BAS_OnlineCountDAL" , transaction);
        }
        public static IQuery<T_BAS_OpenAgentsApply> CreateT_BAS_OpenAgentsApply(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OpenAgentsApply>("T_BAS_OpenAgentsApplyDAL" , transaction);
        }
        public static IQuery<T_BAS_OpenMerchantRrecords> CreateT_BAS_OpenMerchantRrecords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OpenMerchantRrecords>("T_BAS_OpenMerchantRrecordsDAL" , transaction);
        }
        public static IQuery<T_BAS_OrderDetails> CreateT_BAS_OrderDetails(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OrderDetails>("T_BAS_OrderDetailsDAL" , transaction);
        }
        public static IQuery<T_BAS_Orders> CreateT_BAS_Orders(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Orders>("T_BAS_OrdersDAL" , transaction);
        }
        public static IQuery<T_BAS_PackageMail> CreateT_BAS_PackageMail(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_PackageMail>("T_BAS_PackageMailDAL" , transaction);
        }
        public static IQuery<T_BAS_PayAccount> CreateT_BAS_PayAccount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_PayAccount>("T_BAS_PayAccountDAL" , transaction);
        }
        public static IQuery<T_BAS_PayWays> CreateT_BAS_PayWays(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_PayWays>("T_BAS_PayWaysDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductAntiFake> CreateT_BAS_ProductAntiFake(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductAntiFake>("T_BAS_ProductAntiFakeDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductCategorys> CreateT_BAS_ProductCategorys(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductCategorys>("T_BAS_ProductCategorysDAL" , transaction);
        }
        public static IQuery<T_BAS_Products> CreateT_BAS_Products(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Products>("T_BAS_ProductsDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductSKU> CreateT_BAS_ProductSKU(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductSKU>("T_BAS_ProductSKUDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductSKUName> CreateT_BAS_ProductSKUName(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductSKUName>("T_BAS_ProductSKUNameDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductSKUValue> CreateT_BAS_ProductSKUValue(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductSKUValue>("T_BAS_ProductSKUValueDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductTag> CreateT_BAS_ProductTag(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductTag>("T_BAS_ProductTagDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductTagName> CreateT_BAS_ProductTagName(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductTagName>("T_BAS_ProductTagNameDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductType> CreateT_BAS_ProductType(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductType>("T_BAS_ProductTypeDAL" , transaction);
        }
        public static IQuery<T_BAS_Recharge> CreateT_BAS_Recharge(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Recharge>("T_BAS_RechargeDAL" , transaction);
        }
        public static IQuery<T_BAS_RechargeRecord> CreateT_BAS_RechargeRecord(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_RechargeRecord>("T_BAS_RechargeRecordDAL" , transaction);
        }
        public static IQuery<T_BAS_RecieverAddress> CreateT_BAS_RecieverAddress(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_RecieverAddress>("T_BAS_RecieverAddressDAL" , transaction);
        }
        public static IQuery<T_BAS_RefundApplys> CreateT_BAS_RefundApplys(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_RefundApplys>("T_BAS_RefundApplysDAL" , transaction);
        }
        public static IQuery<T_BAS_RefundOrderDetails> CreateT_BAS_RefundOrderDetails(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_RefundOrderDetails>("T_BAS_RefundOrderDetailsDAL" , transaction);
        }
        public static IQuery<T_BAS_ShipAddress> CreateT_BAS_ShipAddress(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ShipAddress>("T_BAS_ShipAddressDAL" , transaction);
        }
        public static IQuery<T_BAS_ShippingMethod> CreateT_BAS_ShippingMethod(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ShippingMethod>("T_BAS_ShippingMethodDAL" , transaction);
        }
        public static IQuery<T_BAS_ShopSlide> CreateT_BAS_ShopSlide(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ShopSlide>("T_BAS_ShopSlideDAL" , transaction);
        }
        public static IQuery<T_BAS_Templates> CreateT_BAS_Templates(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Templates>("T_BAS_TemplatesDAL" , transaction);
        }
        public static IQuery<T_BAS_TradingProfit> CreateT_BAS_TradingProfit(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_TradingProfit>("T_BAS_TradingProfitDAL" , transaction);
        }
        public static IQuery<T_BAS_Visit> CreateT_BAS_Visit(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Visit>("T_BAS_VisitDAL" , transaction);
        }
        public static IQuery<T_BAS_Withdraws> CreateT_BAS_Withdraws(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_Withdraws>("T_BAS_WithdrawsDAL" , transaction);
        }
        public static IQuery<T_BAS_WithdrawsCommission> CreateT_BAS_WithdrawsCommission(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_WithdrawsCommission>("T_BAS_WithdrawsCommissionDAL" , transaction);
        }
        public static IQuery<T_CR_CrowdLuckyNumber> CreateT_CR_CrowdLuckyNumber(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_CrowdLuckyNumber>("T_CR_CrowdLuckyNumberDAL" , transaction);
        }
        public static IQuery<T_CR_CrowdParticipate> CreateT_CR_CrowdParticipate(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_CrowdParticipate>("T_CR_CrowdParticipateDAL" , transaction);
        }
        public static IQuery<T_CR_CrowdParticipateDetails> CreateT_CR_CrowdParticipateDetails(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_CrowdParticipateDetails>("T_CR_CrowdParticipateDetailsDAL" , transaction);
        }
        public static IQuery<T_CR_CrowdWinning> CreateT_CR_CrowdWinning(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_CrowdWinning>("T_CR_CrowdWinningDAL" , transaction);
        }
        public static IQuery<T_CR_LotteryResult> CreateT_CR_LotteryResult(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_LotteryResult>("T_CR_LotteryResultDAL" , transaction);
        }
        public static IQuery<T_CR_ProductCrowd> CreateT_CR_ProductCrowd(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_ProductCrowd>("T_CR_ProductCrowdDAL" , transaction);
        }
        public static IQuery<T_CR_ProductCrowdPeriods> CreateT_CR_ProductCrowdPeriods(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_ProductCrowdPeriods>("T_CR_ProductCrowdPeriodsDAL" , transaction);
        }
        public static IQuery<T_CR_Share> CreateT_CR_Share(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_CR_Share>("T_CR_ShareDAL" , transaction);
        }
        public static IQuery<T_INT_IntegralRules> CreateT_INT_IntegralRules(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_INT_IntegralRules>("T_INT_IntegralRulesDAL" , transaction);
        }
        public static IQuery<T_INT_IntegralTrading> CreateT_INT_IntegralTrading(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_INT_IntegralTrading>("T_INT_IntegralTradingDAL" , transaction);
        }
        public static IQuery<T_JD_ProductCategory> CreateT_JD_ProductCategory(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_JD_ProductCategory>("T_JD_ProductCategoryDAL" , transaction);
        }
        public static IQuery<T_SA_ActivityDetail> CreateT_SA_ActivityDetail(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_SA_ActivityDetail>("T_SA_ActivityDetailDAL" , transaction);
        }
        public static IQuery<T_SA_StoreActivity> CreateT_SA_StoreActivity(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_SA_StoreActivity>("T_SA_StoreActivityDAL" , transaction);
        }
        public static IQuery<T_SA_StoreCoupons> CreateT_SA_StoreCoupons(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_SA_StoreCoupons>("T_SA_StoreCouponsDAL" , transaction);
        }
        public static IQuery<T_ST_Notice> CreateT_ST_Notice(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_Notice>("T_ST_NoticeDAL" , transaction);
        }
        public static IQuery<T_ST_Permission> CreateT_ST_Permission(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_Permission>("T_ST_PermissionDAL" , transaction);
        }
        public static IQuery<T_ST_Role> CreateT_ST_Role(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_Role>("T_ST_RoleDAL" , transaction);
        }
        public static IQuery<T_ST_Role_Permission> CreateT_ST_Role_Permission(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_Role_Permission>("T_ST_Role_PermissionDAL" , transaction);
        }
        public static IQuery<T_ST_User> CreateT_ST_User(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_User>("T_ST_UserDAL" , transaction);
        }
        public static IQuery<T_ST_User_Role> CreateT_ST_User_Role(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_User_Role>("T_ST_User_RoleDAL" , transaction);
        }
        public static IQuery<T_SYS_Dictionary> CreateT_SYS_Dictionary(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_SYS_Dictionary>("T_SYS_DictionaryDAL" , transaction);
        }
        public static IQuery<T_SYS_Parameter> CreateT_SYS_Parameter(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_SYS_Parameter>("T_SYS_ParameterDAL" , transaction);
        }
        public static IQuery<T_Vip_ProductDiscount> CreateT_Vip_ProductDiscount(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_Vip_ProductDiscount>("T_Vip_ProductDiscountDAL" , transaction);
        }
        public static IQuery<T_VIP_VipCoupon> CreateT_VIP_VipCoupon(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_VIP_VipCoupon>("T_VIP_VipCouponDAL" , transaction);
        }
        public static IQuery<T_WP_AttributeData> CreateT_WP_AttributeData(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WP_AttributeData>("T_WP_AttributeDataDAL" , transaction);
        }
        public static IQuery<T_WP_WinportMain> CreateT_WP_WinportMain(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WP_WinportMain>("T_WP_WinportMainDAL" , transaction);
        }
        public static IQuery<T_WP_WinportPage> CreateT_WP_WinportPage(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WP_WinportPage>("T_WP_WinportPageDAL" , transaction);
        }
        public static IQuery<T_WX_AutoReply> CreateT_WX_AutoReply(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WX_AutoReply>("T_WX_AutoReplyDAL" , transaction);
        }
        public static IQuery<T_WX_AutoReply_Material> CreateT_WX_AutoReply_Material(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WX_AutoReply_Material>("T_WX_AutoReply_MaterialDAL" , transaction);
        }
        public static IQuery<T_WX_Material> CreateT_WX_Material(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WX_Material>("T_WX_MaterialDAL" , transaction);
        }
        public static IQuery<T_WX_WeChat> CreateT_WX_WeChat(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WX_WeChat>("T_WX_WeChatDAL" , transaction);
        }
        public static IQuery<T_WX_WeChatMenu> CreateT_WX_WeChatMenu(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_WX_WeChatMenu>("T_WX_WeChatMenuDAL" , transaction);
        }
        
        public static IQuery<T_BAS_AdvanceAgentAccountWithLite> CreateT_BAS_AdvanceAgentAccountWithLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_AdvanceAgentAccountWithLite>("T_BAS_AdvanceAgentAccountWithLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_FactorageAccountWithMer> CreateT_BAS_FactorageAccountWithMer(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FactorageAccountWithMer>("T_BAS_FactorageAccountWithMerDAL" , transaction);
        }
        public static IQuery<T_BAS_FactorageWithdrawalHqLite> CreateT_BAS_FactorageWithdrawalHqLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FactorageWithdrawalHqLite>("T_BAS_FactorageWithdrawalHqLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipGroupWithParaLite> CreateT_BAS_FlagshipGroupWithParaLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipGroupWithParaLite>("T_BAS_FlagshipGroupWithParaLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_FlagshipParaWithComUpLite> CreateT_BAS_FlagshipParaWithComUpLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_FlagshipParaWithComUpLite>("T_BAS_FlagshipParaWithComUpLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_MerchantsAgent> CreateT_BAS_MerchantsAgent(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MerchantsAgent>("T_BAS_MerchantsAgentDAL" , transaction);
        }
        public static IQuery<T_BAS_MerchantsWithLite> CreateT_BAS_MerchantsWithLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_MerchantsWithLite>("T_BAS_MerchantsWithLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_OrderDetailsWithDiscout> CreateT_BAS_OrderDetailsWithDiscout(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OrderDetailsWithDiscout>("T_BAS_OrderDetailsWithDiscoutDAL" , transaction);
        }
        public static IQuery<T_BAS_OrderDetailsWithFlagship> CreateT_BAS_OrderDetailsWithFlagship(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OrderDetailsWithFlagship>("T_BAS_OrderDetailsWithFlagshipDAL" , transaction);
        }
        public static IQuery<T_BAS_OrderDetailsWithHq> CreateT_BAS_OrderDetailsWithHq(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_OrderDetailsWithHq>("T_BAS_OrderDetailsWithHqDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductsWithAgent> CreateT_BAS_ProductsWithAgent(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductsWithAgent>("T_BAS_ProductsWithAgentDAL" , transaction);
        }
        public static IQuery<T_BAS_ProductsWithAgentSub> CreateT_BAS_ProductsWithAgentSub(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_ProductsWithAgentSub>("T_BAS_ProductsWithAgentSubDAL" , transaction);
        }
        public static IQuery<T_BAS_RefundApplysWithLite> CreateT_BAS_RefundApplysWithLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_RefundApplysWithLite>("T_BAS_RefundApplysWithLiteDAL" , transaction);
        }
        public static IQuery<T_BAS_TradingProfitWithLite> CreateT_BAS_TradingProfitWithLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_BAS_TradingProfitWithLite>("T_BAS_TradingProfitWithLiteDAL" , transaction);
        }
        public static IQuery<T_INT_IntegralTradingWithLite> CreateT_INT_IntegralTradingWithLite(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_INT_IntegralTradingWithLite>("T_INT_IntegralTradingWithLiteDAL" , transaction);
        }
        public static IQuery<T_ST_ActivityCoupons> CreateT_ST_ActivityCoupons(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_ActivityCoupons>("T_ST_ActivityCouponsDAL" , transaction);
        }
        public static IQuery<T_ST_ActivityOrders> CreateT_ST_ActivityOrders(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_ActivityOrders>("T_ST_ActivityOrdersDAL" , transaction);
        }
        public static IQuery<T_ST_CrowdParticipateBuyListView> CreateT_ST_CrowdParticipateBuyListView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_CrowdParticipateBuyListView>("T_ST_CrowdParticipateBuyListViewDAL" , transaction);
        }
        public static IQuery<T_ST_CrowdParticipateListView> CreateT_ST_CrowdParticipateListView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_CrowdParticipateListView>("T_ST_CrowdParticipateListViewDAL" , transaction);
        }
        public static IQuery<T_ST_CrowdPeriodsView> CreateT_ST_CrowdPeriodsView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_CrowdPeriodsView>("T_ST_CrowdPeriodsViewDAL" , transaction);
        }
        public static IQuery<T_ST_CrowdPeriodsWinningView> CreateT_ST_CrowdPeriodsWinningView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_CrowdPeriodsWinningView>("T_ST_CrowdPeriodsWinningViewDAL" , transaction);
        }
        public static IQuery<T_ST_DistributeOrder> CreateT_ST_DistributeOrder(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_DistributeOrder>("T_ST_DistributeOrderDAL" , transaction);
        }
        public static IQuery<T_ST_GetMyTeamByMember> CreateT_ST_GetMyTeamByMember(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_GetMyTeamByMember>("T_ST_GetMyTeamByMemberDAL" , transaction);
        }
        public static IQuery<T_ST_Member> CreateT_ST_Member(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_Member>("T_ST_MemberDAL" , transaction);
        }
        public static IQuery<T_ST_MemberAndApply> CreateT_ST_MemberAndApply(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_MemberAndApply>("T_ST_MemberAndApplyDAL" , transaction);
        }
        public static IQuery<T_ST_MemberAndDistribution> CreateT_ST_MemberAndDistribution(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_MemberAndDistribution>("T_ST_MemberAndDistributionDAL" , transaction);
        }
        public static IQuery<T_ST_MemberCoupons> CreateT_ST_MemberCoupons(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_MemberCoupons>("T_ST_MemberCouponsDAL" , transaction);
        }
        public static IQuery<T_ST_MemberToWitthdrawsCommission> CreateT_ST_MemberToWitthdrawsCommission(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_MemberToWitthdrawsCommission>("T_ST_MemberToWitthdrawsCommissionDAL" , transaction);
        }
        public static IQuery<T_ST_MerchantRecords> CreateT_ST_MerchantRecords(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_MerchantRecords>("T_ST_MerchantRecordsDAL" , transaction);
        }
        public static IQuery<T_ST_OrderList> CreateT_ST_OrderList(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_OrderList>("T_ST_OrderListDAL" , transaction);
        }
        public static IQuery<T_ST_ProductCategorys> CreateT_ST_ProductCategorys(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_ProductCategorys>("T_ST_ProductCategorysDAL" , transaction);
        }
        public static IQuery<T_ST_ProductFormat> CreateT_ST_ProductFormat(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_ProductFormat>("T_ST_ProductFormatDAL" , transaction);
        }
        public static IQuery<T_ST_ProductTagFormat> CreateT_ST_ProductTagFormat(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_ProductTagFormat>("T_ST_ProductTagFormatDAL" , transaction);
        }
        public static IQuery<T_ST_SharePeriodListView> CreateT_ST_SharePeriodListView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_SharePeriodListView>("T_ST_SharePeriodListViewDAL" , transaction);
        }
        public static IQuery<T_ST_UserAndRoleView> CreateT_ST_UserAndRoleView(SqlRTransaction transaction = null)
        {
             return CreateInstance<T_ST_UserAndRoleView>("T_ST_UserAndRoleViewDAL" , transaction);
        }
    }
}