﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Model
{

    /// <summary>
    /// 购物车
    /// </summary>
    public class CrowdProduct
    {
        public CrowdProduct() { joinDate = DateTime.Now; }
        /// <summary>
        /// 众筹期数Guid
        /// </summary>
        public Guid ProductCrowdPeriodGuid { get; set; }
        /// <summary>
        /// 期数
        /// </summary>
        public int CrowdPeriods { get; set; }
        /// <summary>
        /// 总参与次数
        /// </summary>
        public int TotalTime { get; set; }
        /// <summary>
        /// 剩余次数
        /// </summary>
        public int RemainTime { get; set; }

        /// <summary>
        /// 商品Guid
        /// </summary>
        public Guid ProductCrowdGuid { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string ProductName { get; set; }
        /// <summary>
        /// 商品主图
        /// </summary>
        public string ProductImage { get; set; }

        /// <summary>
        /// 购买的次数
        /// </summary>
        public int MyBuyTime { get; set; }

        DateTime joinDate;
        /// <summary>
        /// 加入时间
        /// </summary>
        public DateTime JoinDate
        {
            get { return joinDate; }
        }
        private int _unitPrice = 1;
        public int UnitBuy
        {
            get
            {
                return _unitPrice;
            }
            set
            {
                if (value <= 1)
                {
                    _unitPrice = 1;
                }
                else
                {
                    _unitPrice = value;
                }
            }
        }

    }
}
