﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using RFramework;

namespace RFrameGenerate.Model
{
    /// <summary>
    /// 数据记录基类
    /// </summary>
    public abstract class EntityBase<T>
    {
        /// <summary>
        /// 数据记录的状态，用于批量更新记录集（UpdateList）
        /// </summary>
        private EntityStates entityState = EntityStates.Original;

        /// <summary>
        /// 获取或设置数据记录的状态，用于批量更新记录集（UpdateList）
        /// </summary>
        public EntityStates EntityState
        {
            get { return this.entityState; }
            set { this.entityState = value; }
        }

        /// <summary>
        /// 实体之间相互转换,只对相同字段赋值,忽略大小写
        /// </summary>
        /// <typeparam name="T">转换后的类型</typeparam>
        /// <returns>返回转换后的对象</returns>
        public Result ToEntity<Result>()
        {
            return CurrentEntity().EntityConvert<Result>();
        }
        /// <summary>
        /// 更新实体
        /// </summary>
        /// <typeparam name="Result">要更新实体的类型</typeparam>
        /// <param name="t">要更新的实体</param>
        /// <returns>更新后的实体</returns>
        public Result UpdateToEntity<Result>(Result result)
        {
            try
            {
                T entity = CurrentEntity();
                
                PropertyDescriptorCollection proT = TypeDescriptor.GetProperties(entity.GetType());
                PropertyDescriptorCollection proResult = TypeDescriptor.GetProperties(typeof(Result));
                object o;
                foreach (PropertyDescriptor v in proResult)
                {
                    PropertyDescriptor r = proT.Find(v.Name, false);
                    if (r != null)
                    {
                        o = r.GetValue(entity);
                        v.SetValue(result, o);
                    }
                }

                return result;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        /// <summary>
        /// 当前派生类
        /// </summary>
        /// <returns>返回派生类</returns>
        protected abstract T CurrentEntity();

        //public Guid SMerchantGuid
        //{
        //    get { return RFrameGenerate.Common; }
        //}
    }
}
