﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Model
{
    public class GridModel
    {
        /// <summary>
        /// 排序字段
        /// </summary>
        public string sidx { get; set; }
        /// <summary>
        /// 排序方式{ asc | desc }
        /// </summary>
        public string sord { get; set; }
        /// <summary>
        /// 当前页码，表示第page页
        /// </summary>
        public int page { get; set; }
        /// <summary>
        /// 每页行数
        /// </summary>
        public int rows { get; set; }
        /// <summary>
        /// 所有数据分页后的总页数
        /// </summary>
        public int pageCount;
        /// <summary>
        /// 所有数据记录条数
        /// </summary>
        public int recordCount;
        /// <summary>
        /// 当页的数据列表
        /// </summary>
        public object datarows { get; set; }// = jqData; toArray
        /// <summary>
        /// 所有数据记录条数
        /// </summary>
        public object expendData;

        public object PackagePageModel()
        {
            //以json格式传输，依次以”total/page/records/rows"封装，名称固定
            var jsonData = new
            {
                total = this.pageCount,
                page = this.page,
                records = this.recordCount,
                datarows = this.datarows,
                expendData = this.expendData
            };
            return jsonData;
        }
        public object EmptyPageModel(object jqData)
        {
            //以json格式传输，依次以”total/page/records/rows"封装，名称固定
            var jsonData = new
            {
                total = 0,
                page = this.page,
                records = 0
            };
            return jsonData;
        }

    }
}
