﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Model.PageModel
{
    /// <summary>
    /// 积分数据转换实体
    /// </summary>
    public class IntegralTranData
    {
        /// <summary>
        /// 使用积分
        /// </summary>
        public int IntegralTe { get; set; }

        /// <summary>
        /// 使用金额
        /// </summary>
        public decimal MoneyTe { get; set; }


        /// <summary>
        /// 对应状态-IntegralTranSate
        /// </summary>
        public IntegralTranSate State { get; set; }

        public string Remark { get; set; }
        public object Data { get; set; }

        public IntegralTranData(int integralTe, decimal moneyTe, object data = null)
        {
            this.IntegralTe = integralTe;
            this.MoneyTe = moneyTe;
            this.Data = data;
        }

        public IntegralTranData(IntegralTranSate state, int integralTe, decimal moneyTe, object data = null)
            : this(integralTe, moneyTe, data)
        {
            this.State = state;
        }

        public IntegralTranData(IntegralTranSate state, int integralTe, decimal moneyTe, string remark, object data = null)
            : this(state, integralTe, moneyTe, data = null)
        {
            this.Remark = remark;
        }

    }


    /// <summary>
    /// 积分数据转换状态
    /// </summary>
    public enum IntegralTranSate
    {
        /// <summary>
        /// 转换成功-默认
        /// </summary>
        SuccessDefault = 1,

        /// <summary>
        /// 转换成功-积分转换为空(备用)
        /// </summary>
        SuccessWithoutTe = 2,

        /// <summary>
        /// 转换失败/无法转换
        /// </summary>
        Error = 3,

    }


    /// <summary>
    /// 积分流水常量
    /// </summary>
    public class IntegralTradingConst
    {

        /// <summary>
        /// 交易类型
        /// </summary>
        public class TradeType
        {
            /// <summary>
            /// 赠送积分
            /// </summary>
            public const int PresentExpType = 1;

            /// <summary>
            /// 购物抵现
            /// </summary>
            public const int IntegralTeType = 2;

            /// <summary>
            /// 参与活动
            /// </summary>
            public const int ActivityType = 3;

            /// <summary>
            /// 退款积分
            /// </summary>
            public const int RefundType = 4;


        }


        /// <summary>
        /// 积分流向
        /// </summary>
        public class IntegralToDir
        {
            /// <summary>
            /// 收入
            /// </summary>
            public const int Income = 1;

            /// <summary>
            /// 支出
            /// </summary>
            public const int Expend = 2;


        }

    }


}
