﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Model
{
    public class MessageBox
    {
        /// <summary>
        /// 执行结果
        /// </summary>
        /// <param name="state"></param>
        public MessageBox(bool state)
            : this(state, string.Empty,string.Empty,string.Empty)
        {
        }

        /// <summary>
        /// 执行结果
        /// </summary>
        /// <param name="state"></param>
        public MessageBox(bool state,string msg)
            : this(state, string.Empty, string.Empty, msg)
        {
        }
        /// <summary>
        /// 执行结果
        /// </summary>
        /// <param name="state"></param>
        public MessageBox(bool state, string merchants, string msg)
            : this(state, merchants, string.Empty, msg)
        {
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="state">执行结果</param>
        /// <param name="merchants">商家名称</param>
        /// <param name="orderNo">订单名称</param>
        /// <param name="msg">消息</param>
        public MessageBox(bool state,string merchants,string orderNo, string msg)
        {
            this.State = state;
            this.Merchants = merchants;
            this.OrderNo = orderNo;
            this.Msg = msg;
            this.ClearDate = DateTime.Now;
        }
        /// <summary>
        /// 执行结果
        /// </summary>
        public bool State { get; set; }
        /// <summary>
        /// 商家名称
        /// </summary>
        public string Merchants { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 消息
        /// </summary>
        public string Msg { get; set; }
        /// <summary>
        /// 结算时间
        /// </summary>
        public DateTime ClearDate { get; set; }
    }
}
