﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework;

namespace RFrameGenerate.Model.PageModel
{
    /// <summary>
    /// 分销订单
    /// </summary>
    public class PT_BAS_Distribution_Order_List : EntityBase<PT_BAS_Distribution_Order_List>, ICloneable
    {
        public Guid DistributeGuid { get; set; }
        public Guid? OrderGuid { get; set; }
        public Guid MerchantGuid { get; set; }
        public string OrderNo { get; set; }
        public DateTime? CreateDate { get; set; }
        public DateTime? CompletionDate { get; set; }
        public DateTime? SettlementDate { get; set; }
        public decimal? TotalMoney { get; set; }
        public decimal? TotalCommission { get; set; }
        public int OrderState { get; set; }
        public int? OrderInnerState { get; set; }
        public string OrderSource { get; set; }
        public string DistributionName { get; set; }
        public string DistributionTelphone { get; set; }
        public Guid? DistributionPropGuid { get; set; }
        public Guid? SuperiorDistributorGuid { get; set; }
        public Guid? TopDistributorGuid { get; set; }
        public decimal? FirstCommission { get; set; }
        public decimal? SecondCommission { get; set; }
        public decimal? ThirdCommission { get; set; }

        //public decimal? Freight { get; set; }



        public override string ToString()
        {
            StringBuilder sb = this.EntityToGetKeyValue();
            if (sb == null)
                return base.ToString();
            else
            {
                return sb.ToString();
            }
        }

        #region 创建副本
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public object Clone()
        {
            return this.MemberwiseClone();
        }

        /// <summary>
        /// 创建当前 System.Object 的深表副本
        /// </summary>
        /// <returns>返回当前实例的深表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public PT_BAS_Distribution_Order_List DeepClone()
        {
            using (System.IO.Stream objectStream = new System.IO.MemoryStream())
            {
                System.Runtime.Serialization.IFormatter formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                formatter.Serialize(objectStream, this);
                objectStream.Seek(0, System.IO.SeekOrigin.Begin);
                return formatter.Deserialize(objectStream) as PT_BAS_Distribution_Order_List;
            }
        }
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public PT_BAS_Distribution_Order_List ShallowClone()
        {
            return Clone() as PT_BAS_Distribution_Order_List;
        }

        #endregion

        #region 实体相互转换
        protected override PT_BAS_Distribution_Order_List CurrentEntity()
        {
            return this;
        }
        #endregion
    }
}
