﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Script.Serialization;

namespace RFrameGenerate.Model
{
    public class PT_BAS_PayWayByOrderNo
    {
        public Guid OrderGuid { get; set; }
        /// <summary>
        /// 订单编号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 订单状态
        /// </summary>
        public int OrderState { get; set; }
        /// <summary>
        /// 订单属性 Json数据
        /// </summary>
        public string Prop { get; set; }
        /// <summary>
        /// 支付名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool? IsEnable { get; set; }

        Dictionary<string, string> dic;
        /// <summary>
        /// 获取值
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public string GetValue(string name)
        {
            if (string.IsNullOrEmpty(name) == true)
                throw new Exception("name不能为空");

            if (dic == null)
                dic = JsonToDictionary(Prop);
            var value = dic[name];

            var d = JsonToDictionary("{"+value+"}");

            return d["value"];
        }

        /// <summary>
        /// json转为Dictionary类型(不支持数组,例:{"errcode":40013,"errmsg":"invalid appid"})
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        Dictionary<string, string> JsonToDictionary(string json)
        {
            json = json.Substring(1, json.Length - 2);
            JObject jo = JObject.Parse(json);
            Dictionary<string, string> dic = new Dictionary<string, string>();
            foreach (var v in jo)
            {
                dic.Add(v.Key, v.Value.ToString());
            }
            return dic;
        }


    }
}
