﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RFrameGenerate.Model
{
    public class TemplateType
    {
        public int TypeID { get; set; }
        public string TypeName { get; set; }
        public string Msg { get; set; }
        public string Detail { get; set; }
        public string MessageType { get; set; }

        public TemplateType(int _typeID, string _typeName)
            : this(_typeID, _typeName, string.Empty, string.Empty,string.Empty)
        {
          
        }

        public TemplateType(int _typeID, string _typeName,string _msg,string _detail,string _messageType)
        {
            this.TypeID = _typeID;
            this.TypeName = _typeName;
            this.Detail = _detail;
            this.Msg = _msg;
            this.MessageType = _messageType;
        }

        public static List<TemplateType> TemplateTypeList()
        {
            List<TemplateType> list = new List<TemplateType>();
            list.AddRange(new TemplateType[]
                {
                    new TemplateType(1,"订单提交成功","TM00016",@"亲，您的订单已经提交成功，请及时付款，别错过哦。

订单号：2015042701053087
待付金额：100.00
如您在支付中遇到问题，请联系我们的客服，协助您处理！","交易消息"),
                    new TemplateType(2,"购买成功通知","TM00976",@"您的订单已支付成功，我们开始为您打包商品，准备发货。
商品名称：lufee牌风衣
消费金额：348.00
购买时间：2015-04-08 16:57:36
感谢您对本店的信赖与支持，期待您下次光临！","交易消息"),
                    new TemplateType(3,"订单发货通知","OPENTM202243318",@"您的订单已发货，您可以通过“我的订单”中查询物流信息。
订单内容：订单号（2015040801073005）
物流服务：顺丰速递
快递单号：111111111111
收货信息：小李 中国山西省朔州市朔城区235号
请耐心等候，谢谢！","交易消息"),
                    new TemplateType(4,"退款申请通知","TM00431",@"您已申请退款，我们将尽快处理您的退款申请。您可以在“退换货”中查看到退款申请的进度。

退款金额：28.80
商品详情：夏威夷果218gx2袋
订单编号：2015040801073005
如您在退款中遇到问题，请联系我们的客服人员，协助您处理！","交易消息"),
                    new TemplateType(5,"退款通知","TM00004",@"您的退款申请已确认，您可以在“退换货”中查看详细退款信息。

退款原因：拍错了，重新拍。
退款金额：28.80
如有任何疑问，请联系我们的客服","交易消息"),
                    new TemplateType(6,"新订单通知","OPENTM200750297",@"您的店铺有一个新订单，赶紧去看看吧。
店铺名称：果果果店
商品名称：苹果2斤装
下单时间：2015-04-08 16:57:36
下单金额：30.00
付款状态：已付款
感谢您的使用,祝您生意兴隆。","分销消息"),
                    new TemplateType(7,"新代理加入通知","OPENTM202809789",@"有一位新成员加入您的团队，赶紧去看看吧。
代理姓名：张三
代理微信：zhangsan
代理手机：13222222222
感谢您的使用,祝您生意兴隆。","代理商"),
                    new TemplateType(8,"佣金提醒","OPENTM201812627",@"恭喜您，获得了一笔新的佣金，您可以在“我的佣金”中查看详细佣金信息。
佣金金额：2.80
时间：2015-05-01 12:12:12
感谢您的使用,祝您生意兴隆。","分销消息"),
                    new TemplateType(9,"提现审核结果通知","OPENTM202425107",@"您的提现申请已处理。
提现金额：100.00
提现方式：提现到余额
申请时间：2015-05-01 12:12:12
审核结果：已同意
审核时间：2015-05-01 13:00:00
如有任何疑问，请联系我们的客服。","提现消息"),
                    new TemplateType(10,"分销商申请成功提醒","OPENTM207126233",@"分销商申请成功提醒
分销商名称：张三
分销商电话：15050510328
申请时间：2015.07.28 10:01
如有疑问，请在微信中留言，我们将第一时间为您服务。","分销商申请"),
                    new TemplateType(11,"订单改价通知","OPENTM203998003",@"您好，您的订单123123123-123123123，卖家已经将价格由xxx元修改为xxx元，请您确认价格后支付。
订单号：853850033-20140609-1281050643
商品名称：简木男装2014夏装新款男士短袖T恤男纯棉圆领灰色韩流版潮男装T恤
下单时间：2013年9月30日 17:58
订单总价：88元
订单状态：等待支付
请您尽快支付！","交易消息"),
                    new TemplateType(13,"邀请关注成功通知","OPENTM400152188",@"您好，以下会员是通过您的二维码关注我们的：
微信昵称/姓名：小明
扫码时间：2015-10-26 10
系统推荐人：小明
如有疑问，请播打我们的400号码
","分销消息")    
                });

            return list;
        }

        public static string GetTypeName(int typeID)
        {
            string typeName = "";
            List<TemplateType> list = new List<TemplateType>();
            list.AddRange(new TemplateType[]
                {
                    new TemplateType(1,"订单提交成功"),
                    new TemplateType(2,"购买成功通知"),
                    new TemplateType(3,"订单发货通知"),
                    new TemplateType(4,"退款申请通知"),
                    new TemplateType(5,"退款通知"),
                    new TemplateType(6,"新订单通知"),
                    new TemplateType(7,"新代理加入通知"),
                    new TemplateType(8,"佣金提醒"),
                    new TemplateType(9,"提现审核结果通知"),
                    new TemplateType(10,"分销商申请成功提醒"),
                    new TemplateType(11,"订单改价通知"),                    
                    new TemplateType(13,"邀请关注成功通知")
                });
            foreach (TemplateType item in list)
            {
                if (item.TypeID == typeID)
                {
                    typeName = item.TypeName;
                    break;
                }
            }
            return typeName;
        }
    }
}
