﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework;

namespace RFrameGenerate.Model
{
    public partial class T_BAS_Agents : EntityBase<T_BAS_Agents>, ICloneable
    {
        public Guid AgentGuid{ get;set; }
        public Guid? LevelGuid{ get;set; }   
        public Guid? ParentAgentGuid{ get;set; }   
        public string UserID{ get;set; }
        public string Password{ get;set; }
        public int UserType{ get;set; }   
        public decimal DepositsAmount{ get;set; }   
        public decimal CumulativeAmount{ get;set; }   
        public string AgentCompany{ get;set; }
        public string AgentName{ get;set; }
        public string AgentTel{ get;set; }
        public string Remark{ get;set; }
        public DateTime? StartDate{ get;set; }   
        public DateTime? ExpireData{ get;set; }   
        public Guid? SMerchantGuid{ get;set; }   
        public bool? IsCustomerServices{ get;set; }   
        public bool? IsEnable{ get;set; }   
        
        public override string ToString()
        {
            StringBuilder sb = this.EntityToGetKeyValue();
            if (sb == null)
                return base.ToString();
            else
            {
                return sb.ToString();
            }
        }
        
        #region 创建副本
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public object Clone()
        {
            return this.MemberwiseClone();
        }
        /// <summary>
        /// 创建当前 System.Object 的深表副本
        /// </summary>
        /// <returns>返回当前实例的深表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_Agents DeepClone()
        {
            using (System.IO.Stream objectStream = new System.IO.MemoryStream())
            {
                System.Runtime.Serialization.IFormatter formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                formatter.Serialize(objectStream, this);
                objectStream.Seek(0, System.IO.SeekOrigin.Begin);
                return formatter.Deserialize(objectStream) as T_BAS_Agents;
            }
        }
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_Agents ShallowClone()
        {
            return Clone() as T_BAS_Agents;
        }
        #endregion
        
        #region 实体相互转换
        protected override T_BAS_Agents CurrentEntity()
        {
            return this;
        }
        #endregion
    }
}

