﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework;

namespace RFrameGenerate.Model
{
    public partial class T_BAS_Member : EntityBase<T_BAS_Member>, ICloneable
    {
        public Guid MemberGuid{ get;set; }
        public Guid? MerchantGuid{ get;set; }   
        public string ID{ get;set; }
        public string MemberMobilePhone{ get;set; }
        public bool? IsAccredited{ get;set; }   
        public DateTime? AccreditedTime{ get;set; }   
        public string MemberOpenID{ get;set; }
        public string MemberName{ get;set; }
        public string MemberNickName{ get;set; }
        public string UnionID{ get;set; }
        public string HeadImgUrl{ get;set; }
        public string Sex{ get;set; }
        public string City{ get;set; }
        public string Province{ get;set; }
        public string Country{ get;set; }
        public decimal Amount{ get;set; }   
        public decimal AmountFrozen{ get;set; }   
        public decimal Balance{ get;set; }   
        public decimal ExpenseTotal{ get;set; }   
        public bool? IsDistributor{ get;set; }   
        public string Area{ get;set; }
        public string WeChatName{ get;set; }
        public DateTime? Birthday{ get;set; }   
        public DateTime CreateDate{ get;set; }   
        public Guid? SMerchantGuid{ get;set; }   
        public string IP{ get;set; }
        public Guid? DID{ get;set; }   
        public int? Integral{ get;set; }   
        public decimal? GrowthValue{ get;set; }   
        
        public override string ToString()
        {
            StringBuilder sb = this.EntityToGetKeyValue();
            if (sb == null)
                return base.ToString();
            else
            {
                return sb.ToString();
            }
        }
        
        #region 创建副本
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public object Clone()
        {
            return this.MemberwiseClone();
        }
        /// <summary>
        /// 创建当前 System.Object 的深表副本
        /// </summary>
        /// <returns>返回当前实例的深表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_Member DeepClone()
        {
            using (System.IO.Stream objectStream = new System.IO.MemoryStream())
            {
                System.Runtime.Serialization.IFormatter formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                formatter.Serialize(objectStream, this);
                objectStream.Seek(0, System.IO.SeekOrigin.Begin);
                return formatter.Deserialize(objectStream) as T_BAS_Member;
            }
        }
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_Member ShallowClone()
        {
            return Clone() as T_BAS_Member;
        }
        #endregion
        
        #region 实体相互转换
        protected override T_BAS_Member CurrentEntity()
        {
            return this;
        }
        #endregion
    }
}

