﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RFramework;

namespace RFrameGenerate.Model
{
    public partial class T_BAS_ShipAddress : EntityBase<T_BAS_ShipAddress>, ICloneable
    {
        public Guid ShipAddressGuid{ get;set; }
        public Guid? MerchantGuid{ get;set; }   
        public string AddressName{ get;set; }
        public string ContantName{ get;set; }
        public string Country{ get;set; }
        public string Province{ get;set; }
        public string City{ get;set; }
        public string Area{ get;set; }
        public string Address{ get;set; }
        public string Telephone{ get;set; }
        public string Company{ get;set; }
        public string Remark{ get;set; }
        public string Zip{ get;set; }
        public Guid? SMerchantGuid{ get;set; }   
        
        public override string ToString()
        {
            StringBuilder sb = this.EntityToGetKeyValue();
            if (sb == null)
                return base.ToString();
            else
            {
                return sb.ToString();
            }
        }
        
        #region 创建副本
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public object Clone()
        {
            return this.MemberwiseClone();
        }
        /// <summary>
        /// 创建当前 System.Object 的深表副本
        /// </summary>
        /// <returns>返回当前实例的深表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_ShipAddress DeepClone()
        {
            using (System.IO.Stream objectStream = new System.IO.MemoryStream())
            {
                System.Runtime.Serialization.IFormatter formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
                formatter.Serialize(objectStream, this);
                objectStream.Seek(0, System.IO.SeekOrigin.Begin);
                return formatter.Deserialize(objectStream) as T_BAS_ShipAddress;
            }
        }
        /// <summary>
        /// 创建当前 System.Object 的浅表副本
        /// </summary>
        /// <returns>返回当前实例的浅表副本,(如果当前实例中有引用对象,引用对象的地址还是指向原来的地址)</returns>
        public T_BAS_ShipAddress ShallowClone()
        {
            return Clone() as T_BAS_ShipAddress;
        }
        #endregion
        
        #region 实体相互转换
        protected override T_BAS_ShipAddress CurrentEntity()
        {
            return this;
        }
        #endregion
    }
}

