﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using JiouSDP.Models;
using RFrameGenerate.Common;
using System.Web.Mvc;

namespace JiouSDP
{
    [PF(PCode.NoPermission)]
    [LF(IsLoginFilter = false, IsMaintenance = false)]
    public class ApiBaseController : ApiController
    {
        /// <summary>
        /// 返回错误结果
        /// </summary>
        /// <param name="message">错误信息</param>
        /// <returns></returns>
        public static HttpResponseMessage ErrorException(string message)
        {
            return ErrorException(message, null, null, null);
        }
        /// <summary>
        /// 返回错误结果
        /// </summary>
        /// <param name="message">错误信息</param>
        /// <returns></returns>
        public static HttpResponseMessage ErrorException(string message, Uri url, CommonModel commonModel, NameValueCollection param)
        {
            return IResponseMessage.ToResponseMessage(new ErrorMessage() { ReturnCode = 300, FailReason = message }, url, commonModel, param);
        }

        /// <summary>
        /// 调用频率检测(账号检测)
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        protected bool CallFrequency(string userid, ref string msg)
        {
            DateTime? dt = CurrentManage.ApiSession.GetValue(userid) as DateTime?;
            if (dt == null)
            {
                CurrentManage.ApiSession.Add(userid, DateTime.Now);
                return true;
            }
            else
            {
                if (DateTime.Now - dt <= new TimeSpan(0, 0, 0, 0, 0))
                {
                    msg = "调用接口太频繁(U),请稍候再试!";
                    return false;
                }
                else
                {
                    CurrentManage.ApiSession.Update(userid, DateTime.Now);
                    return true;
                }
            }
        }
        /// <summary>
        /// 调用频率检测(ip检测)
        /// </summary>
        /// <param name="request"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        protected bool CallIP(HttpRequestMessage request, ref string msg)
        {
            string ip = GetClientIp(request);
            DateTime? dt = CurrentManage.IPSession.GetValue(ip) as DateTime?;
            if (dt == null)
            {
                CurrentManage.IPSession.Add(ip, DateTime.Now);
                return true;
            }
            else
            {
                if (DateTime.Now - dt <= new TimeSpan(0, 0, 0, 0, 0))
                {
                    msg = ip + "调用接口太频繁(I),请稍候再试!";
                    return false;
                }
                else
                {
                    CurrentManage.IPSession.Update(ip, DateTime.Now);
                    return true;
                }
            }
        }
        /// <summary>
        /// 获取客户ip
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        protected string GetClientIp(HttpRequestMessage request)
        {
            if (request.Properties.ContainsKey("MS_HttpContext"))
            {
                return ((HttpContextWrapper)request.Properties["MS_HttpContext"]).Request.UserHostAddress;
            }
            //else if (request.Properties.ContainsKey(RemoteEndpointMessageProperty.Name))
            //{
            //    RemoteEndpointMessageProperty prop;
            //    prop = (RemoteEndpointMessageProperty)request.Properties[RemoteEndpointMessageProperty.Name];
            //    return prop.Address;
            //}
            else
            {
                return "unkown";
            }
        }

    }
}