﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using System.Web.Script.Serialization;
using System.Text;
using JiouSDP.Models;
using System.Threading;
using System.Collections.Specialized;
using System.Reflection;

namespace JiouSDP.Controllers
{
    public class ApiController : ApiBaseController
    {
        //http://localhost:63601/api

        [HttpGet]
        [HttpPost]
        public HttpResponseMessage Index()
        {
            if(RFrameGenerate.Common.CurrentManage.IsEnableApi!=true)
                return ErrorException("api接口已停用,请联系管理员.");

            string msg = string.Empty;
            //调用频率检测（ip）
            if (CallIP(Request, ref msg) == false)
                return ErrorException(msg);

            #region 读参数
            var formData = Request.Content.ReadAsFormDataAsync();
            for (int i = 1; formData.IsCompleted == false && i <= 10; i++)
            {
                if (formData.IsCanceled == true)
                    return ErrorException("操作取消");
                if (formData.IsFaulted == true)
                    return ErrorException("发生异常了");
                Thread.Sleep(200);
            }
            #endregion

            if (formData.Result != null)
            {
                string log = string.Empty;
                CommonModel commonModel = new CommonModel(formData.Result);

                //参数,权限验证
                if (commonModel.IsCheckParam(ref msg) != true)
                    return ErrorException(msg, Request.RequestUri, commonModel, formData.Result);
                //调用频率检测(userid)
                if (CallFrequency(commonModel.userid, ref msg) == false)
                    return ErrorException(msg, Request.RequestUri, commonModel, formData.Result);
                //逻辑  
                dynamic rm = Assembly.Load("JiouSDP").CreateInstance(string.Format("JiouSDP.Areas.Api.ResponseMessage.{0}ResponseMessage", commonModel.action), true);
                if (rm == null)
                    return ErrorException("不支持:action=" + commonModel.action + "的操作!", Request.RequestUri, commonModel, formData.Result);

                return rm.CallApi(Request.RequestUri, commonModel, formData.Result);
            }
            else
            {
                var param = Request.RequestUri.ParseQueryString();
                string log = string.Empty;
                CommonModel commonModel = new CommonModel(param);

                //参数,权限验证
                if (commonModel.IsCheckParam(ref msg) != true)
                    return ErrorException(msg, Request.RequestUri, commonModel, param);
                //调用频率检测(userid)
                if (CallFrequency(commonModel.userid, ref msg) == false)
                    return ErrorException(msg, Request.RequestUri, commonModel, param);
                //逻辑  
                dynamic rm = Assembly.Load("JiouSDP").CreateInstance(string.Format("JiouSDP.Areas.Api.ResponseMessage.{0}ResponseMessage", commonModel.action), true);
                if (rm == null)
                    return ErrorException("不支持:action=" + commonModel.action + "的操作!", Request.RequestUri, commonModel, param);

                return rm.CallApi(Request.RequestUri, commonModel, param);

                //return ErrorException("只支持POST请求!");
            }
        }
    }
}
