﻿using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFramework;
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Web;

namespace JiouSDP.Models
{
    /// <summary>
    /// 公共参数
    /// </summary>
    public class CommonModel : RouteList
    {
        NameValueCollection param;
        public CommonModel(NameValueCollection para)
        {
            this.param = para;
            this.userid = string.Empty;
            this.userstr = string.Empty;
            this.email = string.Empty;
        }
        /// <summary>
        /// 数字ID
        /// </summary>
        public string userid { get; set; }
        /// <summary>
        /// md5
        /// </summary>
        public string userstr { get; set; }
        /// <summary>
        /// 常量(操作类型)
        /// </summary>
        public string action { get; set; }
        /// <summary>
        /// 操作行为
        /// </summary>
        public string email { get; set; }
        /// <summary>
        /// 提交时间
        /// </summary>
        public string vtime { get; set; }
        /// <summary>
        /// 加载参数,检查是否正确,url过期,账号验证
        /// </summary>
        /// <param name="msg"></param>
        /// <returns></returns>
        public bool IsCheckParam(ref string msg)
        {
            msg = string.Empty;
            //是否post请求
            if (param == null)
            {
                msg = "仅支持POST请求";
                return false;
            }
            //是否missing parameters
            if (IsParamCheck(ref msg) == true)
                return false;

            //验证值是否为空 
            if (IsParamValueCheck(ref msg) == true)
                return false;

            //判断url是否过期
            if (IsUrlExpire(ref msg) == true)
                return false;

            //md5验证
            if (IsMD5Verify(ref msg) == false)
                return false;

            return true;
        }
        /// <summary>
        /// 请求是否过期
        /// </summary>
        /// <param name="msg"></param>
        /// <returns></returns>
        private bool IsUrlExpire(ref string msg)
        {
            //DateTime dtpost = new DateTime(int.Parse(vtime.Substring(0, 4)),
            //                                int.Parse(vtime.Substring(4, 2)),
            //                                int.Parse(vtime.Substring(6, 2)),
            //                                int.Parse(vtime.Substring(8, 2)),
            //                                int.Parse(vtime.Substring(10, 2)),
            //                                int.Parse(vtime.Substring(12, 2)));
            //TimeSpan ts = DateTime.Now - dtpost;
            //if (ts > new TimeSpan(0, 10, 0) || ts < new TimeSpan(0, -10, 0))
            //{
            //    msg = "vtime过期";
            //    return true;
            //}
            //else
            //{
            return false;
            //}
        }
        /// <summary>
        /// 值是否为空
        /// </summary>
        /// <param name="msg"></param>
        /// <returns></returns>
        private bool IsParamValueCheck(ref string msg)
        {
            //赋值
            if (param.AllKeys.Contains("userid") == true)
                this.userid = param["userid"];
            if (param.AllKeys.Contains("userstr") == true)
                this.userstr = param["userstr"];
            if (param.AllKeys.Contains("email") == true)
                this.email = param["email"];
            this.action = param["action"];
            this.vtime = param["vtime"];
            bool result = false;
            //验证值
            #region 验证值
            if (string.IsNullOrEmpty(this.action) == true)
            {
                msg += "action,";
                result = true;
            }
            if (string.IsNullOrEmpty(this.vtime) == true)
            {
                msg += "vtime,";
                result = true;
            }
            #endregion
            if (result == true)
                msg += "的值不能为空";
            return result;
        }
        /// <summary>
        /// 是否missing parameters
        /// </summary>
        /// <param name="msg">错误信息</param>
        /// <returns></returns>
        private bool IsParamCheck(ref string msg)
        {
            bool result = false;
            msg = "missing parameters:";
            if (param.AllKeys.Contains("action") == false)
            {
                msg += "action,";
                result = true;
            }
            if (param.AllKeys.Contains("vtime") == false)
            {
                msg += "vtime,";
                result = true;
            }
            if (result == false)
                msg = string.Empty;
            return result;
        }
        /// <summary>
        /// MD5验证
        /// </summary>
        /// <returns></returns>
        private bool IsMD5Verify(ref string msg)
        {
            if (RouteFilter.Contains(action.ToUpper()))
            {
                return true;
            }

            var list = param.AllKeys.Where(a => a.ToLower() != "userstr").OrderBy(a => a);
            if (list == null)
            {
                msg = "missing parameters:userstr";
                return false;
            }
            StringBuilder sb = new StringBuilder();
            foreach (var v in list)
            {
                sb.AppendFormat("{0}", param[v]);
            }
            bool issession = true;//默认缓存验证
            string password = CurrentManage.UserSession.GetValue(userid) as string;
            if (string.IsNullOrEmpty(password) == true)
            {
                issession = false;
                password = APIVerify.GetPassword(userid);
                if (password == null)
                {
                    msg = "userid error";
                    return false;
                }
            }

            string userstr_new = MD5Crypto.MD5(password + sb.ToString());
            if (this.userstr == userstr_new)
            {
                if (issession == false)
                    CurrentManage.UserSession.Add(userid, password);
                return true;
            }
            else
            {
                if (issession == true)
                {//说明缓存可能过期
                    password = APIVerify.GetPassword(userid);
                    userstr_new = MD5Crypto.MD5(password + sb.ToString());
                    if (this.userstr == userstr_new)
                    {
                        CurrentManage.UserSession.Update(userid, password);
                        return true;
                    }
                }
                msg = "userstr error";
                return false;
            }
        }
    }
}