﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using Wechat.Model;
using jiouosdp.Controllers;

namespace jiouosdp.Areas.Balance.Controllers
{
    public class ExtractionListController : BaseController
    {
        //
        // GET: /Balance/ExtractionList/

        [PF(PCode.TradeManage.Balance)]
        public ActionResult Index()
        {
            return View();
        }

        #region JsonResult GetPageList
        /// <summary>
        /// get withdraw list
        /// </summary>
        /// <param name="gridModel"></param>
        /// <param name="name"></param>
        /// <returns></returns>
        public JsonResult GetPageList(GridModel gridModel, string name)
        {


            var withdrawList = WithdrawsManage.GetWithdrawsList(gridModel, name);

            gridModel.datarows = (withdrawList.Select(c => c.State != null ? new
            {
                id = c.WithdrawGuid,
                cell = new object[]
                {
                    c.Name, 
                    c.Telephone,
                    c.WithdrawsAmount,
                    c.ApplyAmount,
                    c.WithdrawalWay,
                    c.CarNo,
                    c.ApplyDateTime.ToString("yyyy-MM-dd"),
                    RFrameGenerate.BLL.DictionaryConst.Withdraws.GetText(c.State.Value),
                    c.State,
                    c.MemberGuid,
                    c.MerchantGuid,
                    ""
                }
            } : null)).ToArray();

            return Json(gridModel.PackagePageModel());
        }

        #endregion

        #region JsonResult ApprovalWithdraws
        /// <summary>
        /// approval by withdraws
        /// </summary>
        /// <param name="state"></param>
        /// <param name="withdrawGuid"></param>
        /// <param name="remark"></param>
        /// <param name="balance"></param>
        /// <param name="memberGuid"></param>
        /// <returns></returns>
        public JsonResult ApprovalWithdraws(int state, Guid withdrawGuid, string remark, string balance, Guid memberGuid)
        {
            Result result = WithdrawsManage.UpdateApprovalState(state, withdrawGuid, remark, memberGuid,GetIP()); 
            
            if (result != null && result.State)
            {
                return Json(new { Result = "OK" });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

        #region JsonResult GetExtSettingParameter
        /// <summary>
        /// get banlance setting parameter
        /// </summary>
        /// <param name="guid"></param>
        /// <returns></returns>
        public JsonResult GetExtSettingParameter(Guid guid)
        {
            var allParList = ParameterManage.GetSettingParameters(RFrameGenerate.BLL.ParameterName.Withdraw.Payments);

            var parameterList = from c in allParList
                                where c.MerchantGuid == guid
                                select new
                                    {
                                        ParameterName = c.ParameterName,
                                        ParameterValue = c.ParameterValue,
                                        ParameterGuid = c.ParameterGuid
                                    };
            return Json(new { Result = "OK", Data = parameterList.ToArray() });

        }
        #endregion

        #region JsonResult UpdateParameterSetting
        /// <summary>
        /// updata (or add)banlace parameter setting
        /// </summary>
        /// <param name="parameterGuid"></param>
        /// <param name="parameterName"></param>
        /// <param name="parameterValue"></param>
        /// <param name="merchantGuid"></param>
        /// <param name="hasPar"></param>
        /// <returns></returns>
        public JsonResult UpdateParameterSetting(string parameterGuid, string parameterName, string parameterValue, int hasPar)
        {
            var length = parameterName.Split(',').Length;

            List<T_SYS_Parameter> plist = new List<T_SYS_Parameter>();

            for (int i = 0; i < length; i++)
            {
                T_SYS_Parameter parameterObj = new T_SYS_Parameter()
                {
                    MerchantGuid = RFrameGenerate.Common.CurrentManage.MerchantGuid,
                    ParameterGuid = hasPar > 0 ? Guid.Parse(parameterGuid.Split(',')[i]) : Guid.NewGuid(),
                    ParameterName = parameterName.Split(',')[i],
                    ParameterValue = parameterValue.Split(',')[i]
                };
                plist.Add(parameterObj);
            }

            var result = hasPar > 0
                ? ParameterManage.UpdateExtSettingParameters(plist)
                : ParameterManage.AddExtSettingParameters(plist);
            if (result.State)
            {
                return Json(new { Result = "OK", Data = plist });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

    }
}
