﻿using RFrameGenerate.BLL.Category;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Category.Controllers
{
    public class MainController : Controller
    {
        // GET: /Category/Main/

        [PF(PCode.CategoryManage.Category)]
        public ActionResult Index()
        {
            return View();
        }

        public JsonResult GetCategories(string code)
        {
            if (code.Contains(","))
            {
                var list = CategoryManage.GetCategories(code.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries), m => new { m.ProductCategoryGuid, m.CategoryCode, m.Leaf, m.CategoryName, m.Level });
                return Json(list);
            }
            else
            {
                var list = CategoryManage.GetCategories(code, m => new { m.ProductCategoryGuid, m.CategoryCode, m.Leaf, m.CategoryName, m.Level });
                return Json(list);
            }
        }

        public JsonResult GetCategory(string code)
        {
            var model = CategoryManage.GetCategory(code, m => new { m.ProductCategoryGuid, m.CategoryName, m.CategoryNameSpell, m.Status, m.Sort });

            if (model == null) return Json(new { Result = "NO" });

            return Json(new { Result = "OK", Model = model });
        }

        public JsonResult UpdateCategory(RFrameGenerate.Model.T_JD_ProductCategory category)
        {
            var result = CategoryManage.UpdateCategory(category);

            if (result.State) return Json(new { Result = "OK", Model = category });

            return Json(new { Result = "NO", Msg = result.Msg });
        }
    }
}
