﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;

namespace jiouosdp.Areas.Distribution.Controllers
{
    public class CommissionSetController : Controller
    {
        //
        // GET: /Distribution/CommissionSet/

        [PF(PCode.DistributionManage.CommissionSet)]
        public ActionResult Index()
        {
            return View();
        }

        #region JsonResult ChangeCommissionSetting
        /// <summary>
        /// updata (or add)commission parameter setting
        /// </summary>
        /// <param name="parameterGuid"></param>
        /// <param name="parameterName"></param>
        /// <param name="parameterValue"></param>
        /// <param name="hasPar"></param>
        /// <returns></returns>
        public JsonResult ChangeCommissionSetting(string parameterGuid, string parameterName, string parameterValue, int hasPar)
        {
            var length = parameterName.Split(',').Length;

            List<T_SYS_Parameter> plist = new List<T_SYS_Parameter>();

            for (int i = 0; i < length; i++)
            {
                if (parameterName.Split(',')[i] == "commissionSettlementTime")
                {
                    var OpenRefundService = ParameterManage.GetParameterByName("refundService_validity");
                    if (int.Parse(OpenRefundService) > int.Parse(parameterValue.Split(',')[i]))
                    {
                        return Json(new { Result = "NO", Msg = string.Format("佣金结算天数一定要大于退款申请有效天数,当前退款天数是{0}天", OpenRefundService) });
                    }
                }


                T_SYS_Parameter parameterObj = new T_SYS_Parameter()
                {
                    MerchantGuid = CurrentManage.MerchantGuid,
                    ParameterGuid = hasPar > 0 ? Guid.Parse(parameterGuid.Split(',')[i]) : Guid.NewGuid(),
                    ParameterName = parameterName.Split(',')[i],
                    ParameterValue = parameterValue.Split(',')[i]
                };
                plist.Add(parameterObj);
            }

            var result = hasPar > 0
                ? ParameterManage.UpdateExtSettingParameters(plist)
                : ParameterManage.AddExtSettingParameters(plist);
            if (result.State)
            {
                return Json(new { Result = "OK", Data = plist });
            }
            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

        #region JsonResult GetCommissionSettingParameter
        /// <summary>
        /// get commission setting parameter
        /// </summary>
        /// <returns></returns>
        public JsonResult GetCommissionSettingParameter()
        {
            var allParList = ParameterManage.GetSettingParameters(RFrameGenerate.BLL.ParameterName.CommissionMember.FirstCommission);

            var parameterList = from c in allParList
                                where c.MerchantGuid == CurrentManage.MerchantGuid
                                select new
                                {
                                    ParameterName = c.ParameterName,
                                    ParameterValue = c.ParameterValue,
                                    ParameterGuid = c.ParameterGuid
                                };
            return Json(new { Result = "OK", Data = parameterList.ToArray() });

        }
        #endregion
    }
}
