﻿using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace JiouSDP.Areas.Distribution.Controllers
{
    public class DistributionTotal : Controller
    {
        //
        // GET: /Distribution/DistributionTotal/

        public ActionResult Index()
        {
            return View();
        }

        #region JsonResult GetTotalList
        public JsonResult GetTotalList(GridModel gridModel)
        {
            var dlist = DistributionManage.GetDistributionPropPageList(gridModel, "");
            if (dlist != null && dlist.Count > 0)
            {
                dlist = dlist.OrderByDescending(a => a.DistributionAmount).ToList();
            }
            gridModel.datarows = dlist.Select(c => new
            {
                id = c.DistributionPropGuid,
                cell = new object[]
                {
                    c.DistributionName,
                    c.JoinDateTime.ToString("yyyy-MM-dd"),
                    c.DistributionAmount
                }
            }).ToArray();
            return Json(gridModel.PackagePageModel());
        }
        #endregion
    }
}
