﻿
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Distribution.Controllers
{
    public class MainController : Controller
    {
        //
        // GET: /Distribution/Main/

        [PF(PCode.DistributionManage.DistributionOrder)]
        public ActionResult Index()
        {
            return View();
        }
        /// <summary>
        /// 获取分销订单列表（分页）
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public JsonResult GetPageList(GridModel gridModel, string orderState, string disName, string orderNo)
        {
            var list = DistributionManage.GetPageList(gridModel,orderState,disName,orderNo);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.DistributeGuid,
                                      cell = new object[]
                                            {
                                                s.DistributeGuid,
                                                s.OrderGuid,
                                                s.MerchantGuid,
                                                s.DistributionPropGuid,
                                                s.SuperiorDistributorGuid,
                                                s.TopDistributorGuid,
                                                s.FirstCommission.Value.ToString("0.00"),
                                                s.SecondCommission.Value.ToString("0.00"),
                                                s.ThirdCommission.Value.ToString("0.00"),
                                                s.OrderNo,
                                                s.CreateDate,
                                                s.CompletionDate,
                                                s.SettlementDate,
                                                s.TotalMoney,
                                                s.TotalCommission.Value.ToString("0.00"),
                                                s.OrderState,
                                                s.OrderInnerState,
                                                s.OrderSource,
                                                s.DistributionName,
                                                s.DistributionTelphone,
                                               
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }


        /// <summary>
        /// 获取分销订单商品明细列表
        /// </summary>
        /// <param name="gridModel"></param>
        /// <returns></returns>
        public JsonResult GetOrderDetailPageList(GridModel gridModel, Guid orderGuid, Guid merchantGuid)
        {
            var list = DistributionManage.GetPageList(orderGuid, merchantGuid);
            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.OrderDetailGuid,
                                      cell = new object[]
                                            {
                                                s.OrderDetailGuid,
                                                s.OrderGuid,
                                                s.ProductGuid,
                                                s.ProductName,
                                                (s.Price * s.DiscountPrice).ToString("0.00"),
                                                s.Quantity,
                                                (s.Amount * s.DiscountPrice).ToString("0.00"),
                                                s.Discount,
                                                s.IntegralMoney.ToString("F2"),
                                                s.firstCommissionAmount,
                                                s.secondCommissionAmount,
                                                s.thirdCommissionAmount,
                                                s.State,
                                            }
                                  }).ToArray();
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult GetDistributionAmount()
        {
            var result = DistributionManage.GetTotalAmount();
            //var result = DistributionManage.GetAmount();//测试自动结算
            if (result.State)
                return Json(new { Result = "OK" });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
            //return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult ShowOrders(Guid guid)
        {
            string str = "";
            var result = DistributionManage.GetDistributionOrders(guid, ref str);
            if (result.State)
                return Json(new { Result = "OK", Rows = str });
            else
                return Json(new { Result = "NO", Msg = result.Msg });
        }
    }
}
