﻿using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using RFramework.SQLQuery.SQLExpands;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;

namespace jiouosdp.Areas.Distribution.Models
{
    public class ContributionModel
    {
        #region 属性

        private int _topNum = -1;
        protected int TopNum
        {
            get
            {
                var value = RFrameGenerate.BLL.ParameterManage.GetParamValue(ParameterName.DistributeContribute.TopNum);

                if (string.IsNullOrEmpty(value))
                {
                    _topNum = 5;
                    return _topNum;
                }
                if (!int.TryParse(value, out _topNum))
                {
                    _topNum = 5;
                    return _topNum;
                }
                if (_topNum <= 0)
                {
                    _topNum = 5;
                    return _topNum;
                }
                return _topNum;
            }
        }

        public string HeadImgUrl { get; set; }
        public string DistributionName { get; set; }
        public DateTime? JoinTime { get; set; }
        public bool IsEnable { get; set; }
        public decimal TotalAmount { get; set; }
        public string DistributionTypeName { get; set; }
        #endregion

        public List<ContributionModel> ToContributionList()
        {
            using (var sql = new SqlModel<T_BAS_DistributionProp, T_BAS_Member, T_BAS_DistributionType>())
            {
                var list = sql.SqlPage((a, b, c) => new { b.HeadImgUrl, a.DistributionName, a.JoinDateTime, a.IsEnable, a.ContributeValue, c.Name }, 1, this.TopNum)
                              .SqlJionInner((a, b, c) => b).SqlOn((a, b, c) => a.MemberGuid == b.MemberGuid)
                              .SqlJionLeft((a, b, c) => c).SqlOn((a, b, c) => a.DistributionTypeGuid == c.DistributionTypeGuid)
                              .SqlWhere((a, b, c) => b.MerchantGuid == CurrentManage.MerchantGuid)
                              .SqlOrderDescBy(m => m.ContributeValue)
                              .ToPageList();

                if (list.Data == null || list.Data.Count <= 0) return new List<ContributionModel>();

                List<ContributionModel> result = new List<ContributionModel>();
                list.Data.ForEach(m =>
                {
                    result.Add(new ContributionModel()
                    {
                        HeadImgUrl = m.HeadImgUrl,
                        DistributionName = m.DistributionName,
                        IsEnable = m.IsEnable ?? false,
                        TotalAmount = m.ContributeValue ?? 0.0m,
                        JoinTime = m.JoinDateTime,
                        DistributionTypeName = m.Name
                    });
                });
                return result;
            }
        }

    }
}