﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.Model;
using RFrameGenerate.BLL;

namespace jiouosdp.Areas.HeadOffice.Controllers
{
    public class FlagshipPackController : Controller
    {
        //
        // GET: /HeadOffice/FlagshipPack/

        #region acitons

        public ActionResult Index()
        {
            return View();
        }

        public ActionResult AddOrEdit(Guid? guid)
        {
            var model = new T_BAS_FlagshipPack();

            if (guid == null || guid == Guid.Empty) return View(model);

            model = FlagshipPackManage.GetEntityByGuid(guid.Value);

            return View(model);
        }

        #endregion

        #region 异步调用

        public JsonResult LoadList(GridModel gridModel, string name)
        {
            var list = FlagshipPackManage.GetPageList(gridModel, name);

            gridModel.datarows = (from s in list
                                  select new
                                  {
                                      id = s.FlagshipPackGuid,
                                      cell = new object[]{
                                          s.PackName,
                                          s.PackPrice.HasValue ? s.PackPrice.Value : 0,
                                          s.MerchantNum
                                      }
                                  });

            return Json(gridModel.PackagePageModel());
        }

        public JsonResult SaveChangeEntity(T_BAS_FlagshipPack entity)
        {
            var result = FlagshipPackManage.SaveChangeEntity(entity);

            if (result.State) return Json(new { Result = "OK" });

            return Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DeleteEntity(Guid guid)
        {
            var result = FlagshipPackManage.DeleteEntity(guid);

            if (result.State) return Json(new { Result = "OK" });

            return Json(new { Result = "NO", Msg = result.Msg });
        }

        #endregion

    }
}
