﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using RFrameGenerate.BLL;
using RFrameGenerate.Model;
using Wechat.Model;

namespace jiouosdp.Areas.Keywords.Controllers
{
    public class KeywordReplyController : Controller
    {
        //
        // GET: /Keywords/KeywordReply/

        [PF(PCode.WeiXinManage.KeywordReply)]
        public ActionResult Index()
        {
            return View();
        }

        public JsonResult GetKeyWordList(GridModel gridModel)
        {
            //var klist = KeywordsManage.GetKeyWordList(gridModel);

            //gridModel.datarows = (klist.Select(c => c.MaterialGuid != null ? new
            //{
            //    id = c.KeywordGuid,
            //    cell = new object[]
            //        {
            //            c.Keyword,
            //            MaterialsManage.GetMaterialList(c.MaterialGuid.Value).Name,
            //            DictionaryConst.WeiXinAutoReply.MaterialType.GetMaterialByState(MaterialsManage.GetMaterialList(c.MaterialGuid.Value).MaterialType),
            //            c.MaterialGuid,
            //            ""
            //        }
            //} : null).ToArray());

            var klist = KeywordsManage.GetKeyList();

            gridModel.datarows = (klist.Select(c => new
            {
                id = c.KeywordGuid,
                cell = new object[]
                    {
                        c.Keyword,
                        c.Name,
                        DictionaryConst.WeiXinAutoReply.MaterialType.GetMaterialByState( c.MaterialType),
                        c.MaterialGuid
                    }
            }).ToArray());

            return Json(gridModel.PackagePageModel());
        }

        public JsonResult CheckKeyWordList()
        {
            return Json(KeywordsManage.GetKeyWordList());
        }

        public JsonResult GetMaterialList()
        {
            return Json(MaterialsManage.GetMaterialList());
        }

        public JsonResult AddAndUpdateKeyword(T_BAS_Keywords entity)
        {
            var result = KeywordsManage.AddAndUpdateKeyword(entity);
            return result.State ? Json(new { Result = "OK" }) : Json(new { Result = "NO", Msg = result.Msg });
        }

        public JsonResult DeleteKeyword(Guid keywordGuid)
        {
            return KeywordsManage.DeleteKeyword(keywordGuid).State ? Json(new { Result = "OK" }) : Json(new { Result = "NO" });
        }
    }
}
