﻿using jiouosdp.Areas.Logistics.Models;
using RFrameGenerate.BLL;
using RFrameGenerate.BLL.Logistics;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Logistics.Controllers
{
    public class TemplateController : Controller
    {
        // GET: /Logistics/Template/

        #region 页面Action

        [PF(PCode.LogisticsManage.LogisticsTemplate)]
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Save(Guid? templatesGuid)
        {
            if (templatesGuid == null || templatesGuid.Value == Guid.Empty) return View(new LogisticsModel());

            var template = TemplatesManage.GetEntity(templatesGuid.Value);

            if (template == null) return View(new LogisticsModel());

            LogisticsModel model = new LogisticsModel();
            model.Templates = template;

            return View(model);
        }

        #endregion

        #region 逻辑处理

        //加载模板列表
        public JsonResult LoadTemplatesList(GridModel gridModel)
        {
            var list = TemplatesManage.GetPageList(gridModel);
            Dictionary<string, T_BAS_Areas> cache = new Dictionary<string, T_BAS_Areas>();

            gridModel.datarows = (list.Select(c => new
            {
                id = c.TemplatesGuid,
                cell = new object[]
                {
                    c.TemplateName,
                    c.DeliveryTime,
                    c.IsPinkage,
                    c.ValuationWay,
                    c.IsActive,
                    c.Sort
                }
            }).ToArray());
            return Json(gridModel.PackagePageModel());
        }

        //保存模板
        public JsonResult SaveOrUpdate(T_BAS_Templates templates, List<T_BAS_ShippingMethod> list, List<T_BAS_PackageMail> packList)
        {
            var result = TemplatesManage.SaveTemplates(templates, list, packList);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        //删除模板
        public JsonResult DeleteTemplates(Guid templatesGuid)
        {
            var result = TemplatesManage.DeleteTemplates(templatesGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult EnableTemplates(Guid templatesGuid)
        {
            var result = TemplatesManage.EnableTemplate(templatesGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult DisableTemplate(Guid templatesGuid)
        {
            var result = TemplatesManage.DisableTemplate(templatesGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult SaveTemplateSetting(int state)
        {
            var result = ParameterManage.UpdateParam(ParameterName.LogisticsTemplate.LogisticsSum, state.ToString().ToLower());

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }
        #endregion


    }
}
