﻿using RFrameGenerate.BLL.Logistics;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace jiouosdp.Areas.Logistics.Models
{
    public class LogisticsModel
    {
        private T_BAS_Templates _templates = null;
        public T_BAS_Templates Templates
        {
            get
            {
                if (this._templates != null) return _templates;

                return new T_BAS_Templates();
            }
            set
            {
                this._templates = value;
            }
        }

        private List<T_BAS_ShippingMethod> _shippingMethodList = null;
        public List<T_BAS_ShippingMethod> ShippingMethodList
        {
            get
            {
                if (_shippingMethodList != null) return _shippingMethodList;

                _shippingMethodList = ShippingMethodManage.GetListByTemplate(this.Templates.TemplatesGuid);

                return _shippingMethodList;
            }
        }

        private List<T_BAS_PackageMail> _packList = null;
        public List<T_BAS_PackageMail> PackList
        {
            get
            {
                if (_packList == null && this.Templates.IsPinkage == 2)
                {
                    _packList = new List<T_BAS_PackageMail>(0);
                }
                if (_packList == null && this.Templates.IsPackageMail != null && !this.Templates.IsPackageMail.Value)
                {
                    _packList = new List<T_BAS_PackageMail>(0);
                }

                if (_packList != null) return _packList;

                _packList = PackageMailManage.GetList(this.Templates.TemplatesGuid);

                if (_packList == null) _packList = new List<T_BAS_PackageMail>();

                return _packList;
            }
        }

        public T_BAS_ShippingMethod FirstExpress
        {
            get
            {
                var model = this.ShippingMethodList.FirstOrDefault(m => string.IsNullOrEmpty(m.SupportArea) && m.ExType == 1);

                if (model == null) return new T_BAS_ShippingMethod()
                {
                    FirstArticleNum = 1,
                    ContinueArticleNum = 1
                };

                return model;
            }
        }

        public T_BAS_ShippingMethod FirstEMS
        {
            get
            {
                var model = this.ShippingMethodList.FirstOrDefault(m => string.IsNullOrEmpty(m.SupportArea) && m.ExType == 2);

                if (model == null) return new T_BAS_ShippingMethod()
                {
                    FirstArticleNum = 1,
                    ContinueArticleNum = 1
                };

                return model;
            }
        }

        public bool IsExpress
        {
            get
            {
                if (this.ShippingMethodList == null || this.ShippingMethodList.Count <= 0) return false;

                return this.ShippingMethodList.Exists(m => m.ExType == 1);
            }
        }

        public bool IsEMS
        {
            get
            {
                if (this.ShippingMethodList == null || this.ShippingMethodList.Count <= 0) return false;

                return this.ShippingMethodList.Exists(m => m.ExType == 2);
            }
        }

        public bool IsExpressData
        {
            get
            {
                return this.ShippingMethodList.Exists(m => !string.IsNullOrEmpty(m.SupportArea) && m.ExType == 1);
            }
        }

        public bool IsEMSData
        {
            get
            {
                return this.ShippingMethodList.Exists(m => !string.IsNullOrEmpty(m.SupportArea) && m.ExType == 2);
            }
        }
    }
}