﻿using jiouosdp.Areas.Marketing.Models;
using RFrameGenerate.BLL;
using RFrameGenerate.BLL.Marketing;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Marketing.Controllers
{
    [MerchantFilter()]
    public class MainController : Controller
    {
        // GET: /Marketing/Main/

        #region 活动列表

        [PF(PCode.MarketingManage.Coupon)]
        public ActionResult Index()
        {
            return View();
        }

        public JsonResult LoadActivityList(GridModel gridModel, int? state)
        {
            var list = StoreActivityManage.GetPageList(gridModel, state);

            gridModel.datarows = (list.Select(c => new
            {
                id = c.StoreActivityGuid,
                cell = new object[]
                {
                    c.ActivityName,                  
                    c.StartDate == null ? "" : c.StartDate.Value.ToString("yyyy-MM-dd HH:mm:ss"),
                    c.EndDate == null ? "" : c.EndDate.Value.ToString("yyyy-MM-dd HH:mm:ss"),
                    c.Amount,
                    c.ReceivedNum,
                    (c.TotalNum - c.ReceivedNum),
                    StoreActivityManage.CurrentState(c.State.Value , c.StartDate.Value , c.EndDate.Value),
                    GetCouponLink(c.StoreCouponsGuid),
                }
            }).ToArray());
            return Json(gridModel.PackagePageModel());
        }

        private string GetCouponLink(Guid couponGuid)
        {
            return "http://" + CurrentUser.GetMerchantUserID() + string.Format(".shop.{0}/coupons/index?couponGuid={1}", CurrentManage.DomainWxRoot, couponGuid);
        }
        #endregion

        #region 添加活动

        public ActionResult Save(Guid? activityGuid)
        {
            if (activityGuid == null || activityGuid.Value == Guid.Empty) return View(new ActivityCoupons());

            return View(new ActivityCoupons(activityGuid.Value));
        }

        public JsonResult SaveActivity(T_SA_StoreActivity activity, T_SA_StoreCoupons coupons, string guids)
        {
            var result = StoreActivityManage.SaveActivity(activity, coupons, guids);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }
        #endregion

        #region 查看活动

        public ActionResult Show(Guid activityGuid)
        {
            if (activityGuid == Guid.Empty) return Content("不存在活动！");

            var model = new ActivityCoupons(activityGuid);

            if (model.Activity.StoreActivityGuid == Guid.Empty) return Content("不存在活动！");

            return View(model);
        }

        #endregion

        #region 查看数据使用情况

        public ActionResult Statistics(Guid activityGuid)
        {
            if (activityGuid == Guid.Empty) return Content("未找到优惠券活动！");

            ActivityCoupons ac = new ActivityCoupons(activityGuid);

            if (ac == null || ac.Activity == null || ac.Activity.StoreActivityGuid == Guid.Empty) return Content("未找到优惠券活动！");

            return View(ac);
        }

        public JsonResult LoadCouponDetail(GridModel gridModel, Guid activityGuid)
        {
            var list = ActivityDetailManage.GetCouponPageList(gridModel, activityGuid);

            gridModel.datarows = (list.Select(c => new
            {
                id = c.MemberGuid,
                cell = new object[]
                {
                    c.MemberName,
                    c.MemberCount,
                    c.UsedCount,
                    c.ExpiryCount,
                    ActivityDetailManage.GetOrderNos(c.MemberGuid,activityGuid),
                    c.OrderAmount
                }
            }).ToArray());
            return Json(gridModel.PackagePageModel());
        }

        #endregion

        #region 关闭活动

        public JsonResult CloseActivity(Guid activityGuid)
        {
            var result = StoreActivityManage.CloseActivity(activityGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        #endregion

        #region 发送优惠券

        public JsonResult LoadMemberList(GridModel gridModel, string name)
        {
            var list = MemberManage.GetMembers(gridModel, name, m => new { m.MemberGuid, m.MemberNickName, m.HeadImgUrl, m.Sex, m.City, m.Province });

            gridModel.recordCount = list.RecordCount;
            gridModel.datarows = (list.Data.Select(c => new
            {
                id = c.MemberGuid,
                cell = new object[]
                {
                    c.MemberNickName,
                    c.HeadImgUrl,
                    c.Sex,
                    c.Province,
                    c.City
                }
            }).ToArray());
            return Json(gridModel.PackagePageModel());
        }

        public JsonResult SendSelectMembers(Guid[] membersGuid)
        {
            return Json(null);
        }

        #endregion
    }
}
