﻿using LitJson;
using RFrameGenerate.BLL;
using RFrameGenerate.Common;
using RFrameGenerate.Model;
using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Marketing.Controllers
{
    [MerchantFilter()]
    [PF(PCode.MarketingManage.MemberLevel)]
    public class MemberLevelController : Controller
    {
        // GET: /Marketing/MemberLevel/

        public ActionResult Index()
        {
            return View();
        }


        public JsonResult LoadMemberLevel(GridModel gridModel)
        {
            var list = RFrameGenerate.BLL.Member.MemberLevelManage.GetPageList(gridModel);

            gridModel.datarows = (list.Select(c => new
            {
                id = c.MemberLevelGuid,
                cell = new object[]
                {
                    c.LevelName,
                    c.LevelImg,
                    c.LevelExp
                }
            }).ToArray());

            return Json(gridModel.PackagePageModel());
        }

        public JsonResult SaveMemberLevel(Guid? memberLevelGuid, string levelName, string levelImg, int exp)
        {
            var result = RFrameGenerate.BLL.Member.MemberLevelManage.Save(memberLevelGuid, levelName, levelImg, exp);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult DelMemberLevel(Guid? memberLevelGuid)
        {
            var result = RFrameGenerate.BLL.Member.MemberLevelManage.Delete(memberLevelGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult SaevMemberLevelSate(bool state)
        {
            var result = RFrameGenerate.BLL.Member.MemberLevelManage.SaveMemberLevelState(state);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        } 
        #region 上传图片

        [HttpPost]
        public void Upload()
        {
            string returnstr = string.Empty;
            string relativePath = string.Empty;
            try
            {
                foreach (string upload in Request.Files)
                {
                    var file = Request.Files[upload];
                    string fileNameExt = Path.GetExtension(file.FileName).ToLower();

                    if (fileNameExt != ".jpg" && fileNameExt != ".gif" && fileNameExt != ".png" && fileNameExt != ".jpeg" && fileNameExt != ".mp4")
                    {
                        throw new Exception("不合适的文件,只能支持jpg|gif|png的文件");
                    }

                    if (!UpLoadFileHelp.HasFile(file)) continue;

                    if (file.ContentLength > 1024 * 100)
                        throw new Exception("请上传小于100K图片");

                    var dateTimeNow = DateTime.Now;
                    var basePath = string.Empty;

                    basePath = DictionaryConst.UpLoadPath.MemberLevelPath;

                    var fileName = dateTimeNow.ToString("yyyyMMddHHmmssfff")
                        + RadomCode.DigitalCode(3) + fileNameExt;

                    relativePath = basePath + "/" + fileName;
                    string DirUrl = Server.MapPath("~" + basePath);

                    UpLoadFileHelp.SaveInFileSystem(file, DirUrl, fileName);
                }

                Hashtable successHash = new Hashtable();
                successHash["error"] = 0;
                successHash["url"] = relativePath;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(successHash));
                Response.End();

            }
            catch (Exception e)
            {
                Hashtable failueHash = new Hashtable();
                failueHash["error"] = 1;
                failueHash["message"] = e.Message;
                Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
                Response.Write(JsonMapper.ToJson(failueHash));
                Response.End();
            }
        }

        public JsonResult DeleteImage(string path)
        {
            if (string.IsNullOrEmpty(path)) return Json(new { Result = "OK" });

            if (path.ToLower().IndexOf("/upload/divshop") < 0) return Json(new { Result = "OK" });

            var fileName = Server.MapPath(path);

            if (System.IO.File.Exists(fileName))
            {
                System.IO.File.Delete(fileName);
            }
            return Json(new { Result = "OK" });
        }

        #endregion

    }
}
