﻿using RFrameGenerate.BLL.Member;
using RFrameGenerate.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace jiouosdp.Areas.Marketing.Controllers
{
    [MerchantFilter()]
    [PF(PCode.MarketingManage.ProductDiscount)]
    public class ProductDiscountController : Controller
    {
        //
        // GET: /Marketing/ProductDiscount/

        public ActionResult Index()
        {
            return View();
        }

        public JsonResult LoadProductDiscountList(GridModel gridModel)
        {
            var list = ProductDiscountManage.GetPageList(gridModel, (a, b, c) => new { a.ProductDiscountGuid, b.ProductName, c.LevelName, a.DiscountType, a.DiscountProportion });

            gridModel.recordCount = list.RecordCount;
            gridModel.datarows = (list.Data.Select(c => new
            {
                id = c.ProductDiscountGuid,
                cell = new object[]
                {
                    c.ProductName,
                    c.LevelName,
                    c.DiscountType,                                       
                    c.DiscountProportion
                }
            }).ToArray());

            return Json(gridModel.PackagePageModel());
        }

        public ActionResult Save(Guid? discountGuid)
        {
            var model = ProductDiscountManage.GetDiscount(discountGuid);

            return View(model);
        }

        public JsonResult SaveProductDiscount(T_Vip_ProductDiscount discount)
        {
            var result = ProductDiscountManage.SaveProductDiscount(discount);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }

        public JsonResult DeleteProductDiscount(Guid discountGuid)
        {
            var result = ProductDiscountManage.DeleteProductDiscount(discountGuid);

            if (!result.State) return Json(new { Result = "NO", Msg = result.Msg });

            return Json(new { Result = "OK" });
        }
    }
}
